/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
import AmetysFront from 'AmetysFront';

export function getFileUrl(ametysObjectId, file, download, height, width, attributeName) {
  let fileNameWithExt = file.name;
  let index = fileNameWithExt.lastIndexOf('.');
  let name = fileNameWithExt.substring(0, index);
  let ext = fileNameWithExt.substring(index + 1);


let url = AmetysFront.getPluginDirectPrefix("workspaces")
  + "/get-workspace-ametys-object/"
  + attributeName + "/"
  + name + "." + ext
  + "/"
  + name;

if (height != 0 || width != 0 )
{
  url += "_max" + height + "x" + width;
}
url += "." + ext
    + "?download=" + download + "&id=" + ametysObjectId;


  return url;
}
