/*
 *  Copyright 2024 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

 import AmetysFront from 'AmetysFront';
import $j from 'jQuery';

export function navigateToMessage(commentId, parentId, highligth) {
  const node = $j(`[id=${commentId}]`);
  if (node.length == 0) return;
  const pos = node.position().top;
  const container = document.querySelector('#detailed-thread-container');

  // TODO compute real scroll top after mobile refacto
  $j(container).scrollTop(pos + 100);
  if (parentId == commentId)
  {
    AmetysFront.Event.fire('open-subreplies', commentId);
  }
  if (highligth)
  {
    node.removeClass('highligth-comment-done');
    node.addClass('highligth-comment');

    setTimeout(() => {
      node.removeClass('highligth-comment');
      node.addClass('highligth-comment-done');
    }, 1000);
  }

}
