/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/**
 * Helper used to display size related errors
 */

import AmetysFront from 'AmetysFront';
import i18n from 'i18n'
import { useFoldersStore } from '@/stores/folders'

/**
 * Display an error message if an action is canceled due to exceeded size error
 */
export function displaySizeExceededError(message, exceedMaxSizeFiles)
{
    const foldersStore = useFoldersStore();

    let text = message.replace(/\{0\}/g, AmetysFront.Utils.getReadableSize(foldersStore.storageSpaceLimit))
    let firstThree = exceedMaxSizeFiles.slice(0, 3);
    let difference = exceedMaxSizeFiles.length - firstThree.length;

    text = text + " " + firstThree.join(", ")


    if (difference > 1)
    {
      text = text + " " + i18n.PLUGINS_WORKSPACES_MODULE_UPLOAD_ERROR_FILE_MANAGER_SPACE_SEVERAL_OTHER.replace(/\{0\}/g, difference)
    }
    else if (difference == 1) {
      text = text + " " + i18n.PLUGINS_WORKSPACES_MODULE_UPLOAD_ERROR_FILE_MANAGER_SPACE_REACHED_ONE_OTHER
    }

    let errorObject = {
      title: i18n.PLUGINS_WORKSPACES_MODULE_UPLOAD_ERROR_FILE_MANAGER_SPACE_REACHED_TITLE,
      text: text,
      details: ""
    }

    if (difference > 0)
    {
      errorObject.details = exceedMaxSizeFiles.join(", ")
    }

    AmetysFront.Event.fire('loaderFail', errorObject)
}
