/*
 *  Copyright 2016 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces;

/**
 * Constants for event identifiers.
 */
public interface ObservationConstants
{
    /** Event id when a project is added. */
    public static final String EVENT_PROJECT_ADDED = "project.added";
    /** Event id when a project's configuration is updated. */
    public static final String EVENT_PROJECT_UPDATED = "project.updated";
    /** Event id when a project is deleted. */
    public static final String EVENT_PROJECT_DELETED = "project.deleted";
    /** Event id when a member is added. */
    public static final String EVENT_MEMBER_ADDED = "member.added";
    /** Event id when a member is deleted. */
    public static final String EVENT_MEMBER_DELETED = "member.deleted";
    
    /** Argument name for processed project */
    public static final String ARGS_PROJECT = "project";
    /** Argument name for processed project id */
    public static final String ARGS_PROJECT_ID = "projectId";
    /** Argument name for processed project name */
    public static final String ARGS_PROJECT_NAME = "project.name";
    /** Argument name for processed project members */
    public static final String ARGS_PROJECT_MEMBERS = "project.members";
    /** Argument name for processed member */
    public static final String ARGS_MEMBER = "project.member";
    /** Argument name for processed member id */
    public static final String ARGS_MEMBER_ID = "project.member.id";
    /** Argument name for processed member identity */
    public static final String ARGS_MEMBER_IDENTITY = "project.member.identity";
    /** Argument name for processed member identity type */
    public static final String ARGS_MEMBER_IDENTITY_TYPE = "project.member.identity.type";
    
    /** Event id when a new front edition page if created */
    public static final String EVENT_MINISITE_PAGE_CREATED = "minisite.page.created";
    /** Event id when a new front edition page if updated */
    public static final String EVENT_MINISITE_PAGE_UPDATED = "minisite.page.updated";
    /** Event id when a new front edition page if renamed */
    public static final String EVENT_MINISITE_PAGE_RENAMED = "minisite.page.renamed";
    /** Event id when a new front edition page if deleted */
    public static final String EVENT_MINISITE_PAGE_DELETED = "minisite.page.deleted";
    /** Argument name for the page title */
    public static final String ARGS_PAGE_TITLE = "minisite.page.title";
    
    /** Event id when a wall content is published. */
    public static final String EVENT_WALLCONTENT_ADDED = "wallcontent.added";
    
    /** Event id when a project news is (published notified to members). */
    public static final String EVENT_PROJECT_NEWS_PUBLISHED = "project.news.published";
    
    /** Event id when a task is created. */
    public static final String EVENT_TASK_CREATED = "task.created";
    /** Event id when a task is assigned to (a) user(s). */
    public static final String EVENT_TASK_ASSIGNED = "task.assigned";
    /** Event id when a task's closed status is changed. */
    public static final String EVENT_TASK_CLOSED_STATUS_CHANGED = "task.closed.status.changed";
    /** Event id when a task is modified. */
    public static final String EVENT_TASK_UPDATED = "task.updated";
    /** Event id when a task is deleted. */
    public static final String EVENT_TASK_DELETING = "task.deleting";
    /** Event id when a task is deleted. */
    public static final String EVENT_TASK_DELETED = "task.deleted";
    /** Event id when a task is commented. */
    public static final String EVENT_TASK_COMMENTED = "task.commented";
    /** Argument name for processed task */
    public static final String ARGS_TASK = "task";
    /** Argument name for processed task ID */
    public static final String ARGS_TASK_ID = "taskID";
    /** Argument name for processed task comment ID */
    public static final String ARGS_TASK_COMMENT_ID = "taskCommentId";
    /** Argument name for processed task comment content */
    public static final String ARGS_TASK_COMMENT = "taskComment";

    /** Event id when a thread is created. */
    public static final String EVENT_THREAD_CREATED = "forumthread.created";
    /** Event id when a thread is created. */
    public static final String EVENT_THREAD_MODIFIED = "forumthread.modified";
    /** Event id when a thread is created. */
    public static final String EVENT_THREAD_CLOSED = "forumthread.closed";
    /** Event id when a thread is created. */
    public static final String EVENT_THREAD_DELETED = "forumthread.deleted";
    /** Event id when a thread is commented. */
    public static final String EVENT_THREAD_COMMENTED = "forumthread.commented";
    /** Event id when a thread comment is accepted. */
    public static final String EVENT_THREAD_ACCEPTED = "forumthread.accepted";
    /** Event id when a thread comment is reported. */
    public static final String EVENT_THREAD_REPORTED = "forumthread.reported";
    /** Argument name for processed task */
    public static final String ARGS_THREAD = "forumthreadthread";
    /** Argument name for processed task */
    public static final String ARGS_THREAD_COMMENT = "forumthreadcomment";

    
    /** Event id when a resource is commented. */
    public static final String EVENT_RESOURCE_COMMENTED = "resource.commented";
    /** Argument name for file comment */
    public static final String ARGS_FILE_COMMENT = "fileComment";
    /** Argument name for file comment id */
    public static final String ARGS_FILE_COMMENT_ID = "fileCommentId";
}
