/*
 *  Copyright 2020 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces;

/**
 * Constants for workspaces plugin.
 */
public interface WorkspacesConstants
{
    /** The content type id for catalog news */
    public static final String CATALOG_NEWS_CONTENT_TYPE_ID = "org.ametys.plugins.workspaces.Content.catalogNews";
    
    /** The content type id for project news */
    public static final String PROJECT_NEWS_CONTENT_TYPE_ID = "org.ametys.plugins.workspaces.Content.projectNews";
    
    /** The id of content type associated to members */
    public static final String MEMBER_CONTENT_TYPE_ID = "org.ametys.plugins.workspaces.Content.member";
    
    /** The wall content type id */
    public static final String WALL_CONTENT_CONTENT_TYPE_ID = "org.ametys.plugins.workspaces.Content.wallContent";
    
    /** The content type id for project news */
    public static final String PROJECT_ALERT_CONTENT_TYPE_ID = "org.ametys.plugins.workspaces.Content.alert";
    
    /** ContentType for the about content */
    public static final String ABOUT_CONTENT_TYPE = "org.ametys.plugins.workspaces.Content.about";
    
    /** ContentType for the mini-site contents */
    public static final String PROJECT_ARTICLE_CONTENT_TYPE = "org.ametys.plugins.workspaces.Content.projectArticle";
    
    /** The workflow name for contents */
    public static final String CONTENT_WORKFLOW_NAME = "workspaces-content";
    
    /** The request attribute name holding the project name */
    public static final String REQUEST_ATTR_PROJECT_NAME = "projectName";
    
}
