/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.calendars.events;

/**
 * Calendar event attendee interface
 */
public class CalendarEventAttendee 
{
    private String _populationId;
    private String _login;
    private String _email;
    private boolean _external;
    private boolean _mandatory;
    
    /**
     * Get the population ID of the attendee
     * @return the population ID of the attendee
     */
    public String getPopulationId()
    {
        return _populationId;
    }
    
    /**
     * Get the login of the attendee
     * @return the login of the attendee
     */
    public String getLogin()
    {
        return _login;
    }
    
    /**
     * Get the email of the attendee
     * @return the email of the attendee
     */
    public String getEmail()
    {
        return _email;
    }
    
    /**
     * true if the attendee is external
     * @return true if the attendee is external
     */
    public boolean isExternal()
    {
        return _external;    
    }
    
    /**
     * true if the attendee is mandatory
     * @return true if the attendee is mandatory
     */
    public boolean isMandatory()
    {
        return _mandatory;
    }
    
    /**
     * Set the population ID of the attendee
     * @param populationId the population ID
     */
    public void setPopulationId(String populationId)
    {
        this._populationId = populationId;
    }
    
    /**
     * Set the login of the attendee
     * @param login the login
     */
    public void setLogin(String login)
    {
        this._login = login;
    }
    
    /**
     * Set the email of the attendee
     * @param email the email
     */
    public void setEmail(String email)
    {
        this._email = email;
    }
    
    /**
     * Set if the attendee is external
     * @param external is external
     */
    public void setIsExternal(boolean external)
    {
        this._external = external;
    }
    
    /**
     * Set if the attendee is mandatory
     * @param mandatory is mandatory
     */
    public void setIsMandatory(boolean mandatory)
    {
        this._mandatory = mandatory;
    }
    
}
