/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.dav;

import java.util.Arrays;
import java.util.List;

import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.environment.Request;

/**
 * Action to authenticate Webdav URL
 */
public class AuthenticateAction extends org.ametys.core.authentication.AuthenticateAction
{
    @Override
    protected List<String> _getContexts(Request request, Parameters parameters)
    {
        String name;
        try
        {
            name = parameters.getParameter("project");
        }
        catch (ParameterException e)
        {
            throw new IllegalArgumentException(e);
        }
        
        return Arrays.asList("/sites/" + name, "/sites-fo/" + name);
    }
}
