/*
 *  Copyright 2017 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.indexing.project;

import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

import org.ametys.cms.indexing.IndexingObserver;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.Observer;
import org.ametys.plugins.workspaces.ObservationConstants;
import org.ametys.plugins.workspaces.indexing.solr.SolrProjectIndexer;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.runtime.plugin.component.AbstractLogEnabled;

/**
 * {@link Observer} for {@link Project} deletion, for unindexing all solr documents related to this project
 */
public class SolrProjectDeletedObserver extends AbstractLogEnabled implements IndexingObserver, Serviceable
{
    /** The Solr project indexer */
    protected SolrProjectIndexer _solrProjectIndexer;

    @Override
    public void service(ServiceManager manager) throws ServiceException
    {
        _solrProjectIndexer = (SolrProjectIndexer) manager.lookup(SolrProjectIndexer.ROLE);
    }
    
    @Override
    public boolean supports(Event event)
    {
        return ObservationConstants.EVENT_PROJECT_DELETED.equals(event.getId());
    }
    
    @Override
    public int getPriority()
    {
        return MAX_PRIORITY + 3000;
    }
    
    @Override
    public void observe(Event event, Map<String, Object> transientVars) throws Exception
    {
        // Unindex
        String projectId = (String) event.getArguments().get(ObservationConstants.ARGS_PROJECT_ID);
        _solrProjectIndexer.unindexProject(projectId);
    }
}
