/*
 *  Copyright 2022 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.project.notification.preferences;

import java.util.Collection;
import java.util.Map;

import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;

import org.ametys.core.observation.AsyncObserver;
import org.ametys.core.observation.Event;
import org.ametys.plugins.workspaces.ObservationConstants;
import org.ametys.plugins.workspaces.members.JCRProjectMember.MemberType;
import org.ametys.plugins.workspaces.members.ProjectMemberManager.ProjectMember;

/**
 * Observer removing custom notification preferences on project deletion
 */
public class ProjectDeletedObserver implements AsyncObserver, Serviceable
{
    private NotificationPreferencesHelper _notificationPreferenceHelper;

    public void service(ServiceManager manager) throws ServiceException
    {
        _notificationPreferenceHelper = (NotificationPreferencesHelper) manager.lookup(NotificationPreferencesHelper.ROLE);
    }
    
    public boolean supports(Event event)
    {
        return ObservationConstants.EVENT_PROJECT_DELETED.equals(event.getId());
    }

    public int getPriority()
    {
        return Integer.MAX_VALUE;
    }

    public void observe(Event event, Map<String, Object> transientVars) throws Exception
    {
        String projectName = (String) event.getArguments().get(ObservationConstants.ARGS_PROJECT_NAME);
        @SuppressWarnings("unchecked")
        Collection<ProjectMember> projectMembers = (Collection<ProjectMember>) event.getArguments().get(ObservationConstants.ARGS_PROJECT_MEMBERS);
        for (ProjectMember projectMember : projectMembers)
        {
            if (projectMember.getType() == MemberType.USER)
            {
                _notificationPreferenceHelper.deleteProjectNotificationPreferences(projectMember.getUser().getIdentity(), projectName);
            }
        }
    }

}
