/*
 *  Copyright 2025 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.project.observers;

import org.ametys.cms.repository.ContentTypeExpression;
import org.ametys.core.observation.Event;
import org.ametys.plugins.repository.query.expression.AndExpression;
import org.ametys.plugins.repository.query.expression.Expression;
import org.ametys.plugins.repository.query.expression.Expression.Operator;
import org.ametys.plugins.repository.query.expression.StringExpression;
import org.ametys.plugins.workspaces.ObservationConstants;
import org.ametys.plugins.workspaces.WorkspacesConstants;
import org.ametys.plugins.workspaces.project.objects.Project;
import org.ametys.web.repository.SiteAwareAmetysObject;

/**
 * This observer reload ACL cache of catalog's news when a project was updated
 */
public class UpdateAclSorCacheOnProjectUpdated extends AbstractUpdateAclSorCacheObserver
{
    public boolean supports(Event event)
    {
        String eventId = event.getId();
        return eventId.equals(ObservationConstants.EVENT_PROJECT_UPDATED);
    }

    @Override
    protected Expression getContentsExpression(Event event, Project project)
    {
        // If project's categories or keywords have changed, the read access on catalog's news have changed (see CatalogNewsAccessController)
        Expression catalogCTypesExpr = new ContentTypeExpression(Operator.EQ, WorkspacesConstants.CATALOG_NEWS_CONTENT_TYPE_ID);
        Expression catalogSiteExpr = new StringExpression(SiteAwareAmetysObject.METADATA_SITE, Operator.EQ, _projectManager.getCatalogSiteName());
        return new AndExpression(catalogSiteExpr, catalogCTypesExpr);
    }
}
