/*
 *  Copyright 2021 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package org.ametys.plugins.workspaces.wall.observers;

import org.ametys.cms.ObservationConstants;
import org.ametys.cms.repository.Content;
import org.ametys.core.observation.Event;
import org.ametys.core.observation.Observer;
import org.ametys.plugins.workspaces.WorkspacesConstants;

/**
 * {@link Observer} to invalidate zone item cache of wall content service when a wall content is commented
 *
 */
public class InvalidateZoneItemCacheOnWallContentObserver extends AbstractInvalidateZoneItemCacheOnWallObserver
{
    public boolean supports(Event event)
    {
        boolean eventSupported = event.getId().equals(ObservationConstants.EVENT_CONTENT_REACTION_CHANGED);
        
        
        if (eventSupported)
        {
            Content content = (Content) event.getArguments().get(ObservationConstants.ARGS_CONTENT);
            return content != null && _contentTypeHelper.isInstanceOf(content, WorkspacesConstants.WALL_CONTENT_CONTENT_TYPE_ID);
        }
        
        return false;
    }

}
