<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                            xmlns:docbook="http://docbook.org/ns/docbook" 
						    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
						    xmlns:math="http://exslt.org/math" 
						    xmlns:ametys="org.ametys.cms.transformation.xslt.AmetysXSLTHelper"
                            xmlns:captcha="org.ametys.core.captcha.CaptchaHelper"
						    exclude-result-prefixes="docbook"
						    extension-element-prefixes="math ametys captcha">

    <xsl:import href="plugin:web://pages/comments/helper/comments_3.3.xsl"/>
    
    <xsl:template name="comment-form-field-name">
        <xsl:param name="comment-id" />
        
        <div class="field">
            <div class="input">
                <xsl:variable name="id" select="concat($comment-id, '-', $commentUniqueId, '-name')"/>
                <input type="text" name="name" id="{$id}" placeholder="skin.{$skin}:CONTENT_COMMENTS_POST_AUTHOR_NAME_PLACEHOLDER" i18n:attr="placeholder"/>
                <xsl:call-template name="fill-user-input-js">
                    <xsl:with-param name="id" select="$id"/>
                    <xsl:with-param name="field" select="'fullname'"/>
                </xsl:call-template>
            </div>
            <div class="field-end"></div>
        </div>
    </xsl:template>

    <xsl:template name="comment-form-field-mail">
        <xsl:param name="comment-id" />
        
        <div class="field">
            <div class="input">
                <xsl:variable name="id" select="concat($comment-id, '-', $commentUniqueId, '-email')"/>
                <input type="text" name="email" id="{$id}" placeholder="skin.{$skin}:CONTENT_COMMENTS_POST_AUTHOR_EMAIL_PLACEHOLDER" i18n:attr="placeholder"/>
                <xsl:call-template name="fill-user-input-js">
                    <xsl:with-param name="id" select="$id"/>
                    <xsl:with-param name="field" select="'email'"/>
                </xsl:call-template>
            </div>
            <div class="field-end"></div>
        </div>
    </xsl:template>
    
	<xsl:template name="comment-form-field-content">
		<xsl:param name="comment-id" />
        
        <div class="field comment">
			<div class="label comment">
				<label for="{$comment-id}-{$commentUniqueId}-text">
					<i18n:text i18n:key="CONTENT_COMMENTS_POST_AUTHOR_CONTENT" i18n:catalogue="skin.{$skin}"/>
					<xsl:call-template name="comment-form-manadtorymarker"/>
				</label> 
			</div>
			<div class="input">
				<textarea name="texte" id="{$comment-id}-{$commentUniqueId}-text" cols="72" rows="3"></textarea>
			</div>
			<div class="field-end"></div>
		</div>
	</xsl:template>
	
	<xsl:template name="comment-form-field-url">
		<xsl:param name="comment-id" />
        
        <div class="field">
			<div class="input">
				<input type="text" name="url" id="{$comment-id}-{$commentUniqueId}-url" placeholder="skin.{$skin}:CONTENT_COMMENTS_POST_AUTHOR_URL" i18n:attr="placeholder"/>
			</div>
			<div class="field-end"></div>
		</div>
	</xsl:template>	
	
	
	<xsl:template name="comment-form-field-hidemail">
		<xsl:param name="comment-id" />
        
        <div class="field checkbox">
        	<div class="input">
				<input type="checkbox" name="hide-email" id="{$comment-id}-{$commentUniqueId}-hide-email"/>
			</div>
			<div class="label">
				<label for="{$comment-id}-{$commentUniqueId}-hide-email"><i18n:text i18n:key="CONTENT_COMMENTS_POST_AUTHOR_HIDE_EMAIL" i18n:catalogue="skin.{$skin}"/></label> 
			</div>
			
			<div class="field-end"></div>
		</div>
	</xsl:template>		
	
	
	<xsl:template name="comment-form-field-captcha">
        <xsl:param name="comment-id" />
         
        <xsl:variable name="captcha-required"><xsl:call-template name="comment-captcha-required"/></xsl:variable>
        <xsl:if test="$captcha-required = 'true'">
    		<div class="field">
                <xsl:if test="captcha:requiresUserInteraction()">
        			<div class="label">
        				<label for="{$comment-id}-{$commentUniqueId}-captcha">
        					<i18n:text i18n:key="PLUGINS_CMS_CONTENT_COMMENTS_POST_AUTHOR_CAPTCHA" i18n:catalogue="plugin.cms"/>
        					<xsl:call-template name="comment-form-manadtorymarker"/>
        				</label>
        			</div>
                </xsl:if>
    			<div class="input">
    			
    				<xsl:call-template name="captcha">
    				
    					<xsl:with-param name="key-name">captcha-key</xsl:with-param>
    					<xsl:with-param name="key-id"><xsl:value-of select="$comment-id"/>-<xsl:value-of select="$commentUniqueId"/>-captcha-key</xsl:with-param>
    
    					<xsl:with-param name="value-name">captcha-value</xsl:with-param>
    					<xsl:with-param name="value-id"><xsl:value-of select="$comment-id"/>-<xsl:value-of select="$commentUniqueId"/>-captcha</xsl:with-param>
    					<xsl:with-param name="value-style"></xsl:with-param>
    					<xsl:with-param name="value-class"/>
    							
    					<xsl:with-param name="placeholder" select="'CONTENT_COMMENTS_POST_AUTHOR_CAPTCHA'"/>
						<xsl:with-param name="placeholder-i18n" select="true()"/>
						<xsl:with-param name="placeholder-catalogue" select="concat('skin.', $skin)"/>
    					
    					<xsl:with-param name="image-alt">PLUGINS_CMS_CONTENT_COMMENTS_POST_AUTHOR_CAPTCHA</xsl:with-param>
    					<xsl:with-param name="image-alt-i18n" select="true()"/>
    					<xsl:with-param name="image-alt-catalogue">plugin.cms</xsl:with-param>
    					<xsl:with-param name="image-style"></xsl:with-param>
    					<xsl:with-param name="image-class"/>
    					
    					<xsl:with-param name="js-funcname-torefresh">refresh_<xsl:value-of select="translate($comment-id, '-', '_')"/>_<xsl:value-of select="$commentUniqueId"/></xsl:with-param>
    				</xsl:call-template> 
    				
    			</div>
    			<div class="field-end"></div>
    		</div>
        </xsl:if>
	</xsl:template>	
	
	
	<!-- +
	     | The top part of a comment
	     + -->
	<xsl:template name="comment-header">
	    <xsl:param name="content-id" />
        
		<p class="comment-header">
			<a name="{@id}-{$content-id}"/>
				
			<script type="text/javascript">
				if (/(\?|&amp;)last-comment=highlight(#|&amp;)/.test(window.location.href))
				{
				   var commentId = window.location.hash.substr(1);
				   $("[name='" + commentId + "']").parent().parent().addClass('last-comment');
				}
			</script>

			<span class="comment-author">
				
				<span class="comment-author-name">
					<xsl:value-of select="@author-name" />
				</span>
			</span>
			
			<xsl:text> </xsl:text>
			
			<span class="comment-creation">
				<i18n:text i18n:key="CONTENT_COMMENTS_SHOW_DATE" i18n:catalogue="skin.{$skin}" />
				<xsl:text> </xsl:text>
				<span class="comment-creation-date">
					<i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss" pattern="d MMM" value="{@creation-date}"/>
					<xsl:text>, </xsl:text>
				</span>
				<xsl:text> </xsl:text>
				<i18n:time src-pattern="yyyy-MM-dd'T'HH:mm:ss" pattern="short" value="{@creation-date}"/>
			</span>
		</p>
	</xsl:template>
	
	<xsl:template name="comment-author-info">
	   <xsl:if test="@author-email or @author-url">
	       <xsl:if test="@author-email">
	           <div class="author-info">
    	           <i class="fa fa-envelope"></i>
	               <xsl:call-template name="mail-antispam">
	                   <xsl:with-param name="mail" select="@author-email"/>
	                   <xsl:with-param name="class" select="'comment-sendmail'"/>
	                   <xsl:with-param name="text"><i18n:text i18n:key="CONTENT_COMMENTS_SEND_MAIL" i18n:catalogue="skin.{$skin}"/><xsl:text> </xsl:text></xsl:with-param>
	               </xsl:call-template>
               </div>
           </xsl:if>
               
           <xsl:if test="@author-url">
                <div class="author-info">
                    <span class="comment-url">
                        <i class="fa fa-external-link"></i>
                        <a onclick="window.open(this.href); return false;" href="{@author-url}">
                            <i18n:text i18n:key="PLUGINS_CMS_CONTENT_COMMENTS_SHOW_VISIT" i18n:catalogue="plugin.cms" />
                            <xsl:text> </xsl:text>
                            <xsl:value-of select="@author-name" />
                        </a>
                    </span>
                </div>
            </xsl:if>
       </xsl:if>
	</xsl:template>
	
	<!-- +
	     | The bottom part of a comment
	     + -->
	<xsl:template name="comment-footer">
	    <xsl:param name="content-id" />
        
		<div class="comment-footer" >
		
			<xsl:call-template name="comment-answer-form-button" />
		
			<xsl:call-template name="comment-author-info" />
			
            <xsl:call-template name="comment-report">
                <xsl:with-param name="content-id" select="$content-id" />
            </xsl:call-template>
            
            <xsl:call-template name="comment-delete">
                <xsl:with-param name="content-id" select="$content-id" />
            </xsl:call-template>

            <xsl:call-template name="comment-like">
                <xsl:with-param name="content-id" select="$content-id" />
            </xsl:call-template>
            
            
		</div>
	</xsl:template>
	
	<xsl:template name="comment-answer-form-button">
        <!-- Add answer button only if it's the parent comment -->
        <xsl:if test="not(@level) or @level = 0">
	        <p class="answer-comment">
	       	  
	          <span>
	          <i class="fa fa-comment"></i>
	             <script type="text/javascript">
	                 document.write("&lt;a href='javascript: comment_form_switch_<xsl:value-of select="$commentUniqueId"/>(\"<xsl:value-of select="@id" />\")'&gt;<i18n:text i18n:key="PLUGINS_CMS_CONTENT_COMMENTS_ANSWER_TITLE" i18n:catalogue="plugin.cms"/>&lt;/a&gt;")
	             </script>
	          </span>
	        </p>
        </xsl:if>
    </xsl:template>
	
	<xsl:template name="comments-rss">
		<a href="{$site-uri-prefix}/_plugins/web/comments/rss.xml?contentId={@id}&amp;siteName={$site}">
			<i18n:text i18n:key="CONTENT_COMMENTS_RSS_LABEL" i18n:catalogue="skin.{$skin}"/>
		</a>
	</xsl:template>
		
</xsl:stylesheet>