<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                extension-element-prefixes="resolver ametys">

    <xsl:import href="plugin:web://pages/frontoffice-login/login.xsl"/>

	<xsl:template name="body">
        <xsl:call-template name="body-title"/>
    
        <xsl:call-template name="show-hint"/>
        <xsl:call-template name="show-errors"/>
        <xsl:call-template name="login"/>
    </xsl:template>
	
    <xsl:template name="body-title">
        <h1 class="g-font-primary-light g-font-size-24 color-grey g-mb-25--sm g-mb-15"><i18n:text i18n:key="PLUGINS_WEB_FO_LOGIN_TITLE" i18n:catalogue="plugin.web"/></h1>
    </xsl:template>
    
    <xsl:template name="show-hint">
        <p class="g-font-primary-light g-font-size-14 color-grey g-mb-15">
            <i18n:text i18n:key="PLUGINS_WEB_FRONTOFICE_MANDATORY_LABEL" i18n:catalogue="plugin.web"/>
        </p>
    </xsl:template>
    
    <xsl:template name="login-credential-providers">
        <xsl:if test="/LoginScreen/CredentialProviders/CredentialProvider">
            <xsl:choose>
                <xsl:when test="not((count(LoginScreen/CredentialProviders/CredentialProvider) = 1 and /LoginScreen/CredentialProviders/CredentialProvider[not(@isForm = 'true')]))">
                    <div class="login-part">
                        <xsl:for-each select="/LoginScreen/CredentialProviders/CredentialProvider">
                            <xsl:if test="position() != 1">
                                <div class="login-part-credentialproviders-separator"><div class="textin"><i18n:text i18n:key="PLUGINS_CORE_UI_LOGIN_SCREEN_FORM_SEPARATOR" i18n:catalogue="plugin.core-ui" /></div></div>
                            </xsl:if>
                            
                            <form method="post" class="login__form">
                                <input type="hidden" name="CredentialProviderIndex" value="{@index}"/>
                                <xsl:choose>
                                    <xsl:when test="@isForm = 'true' and (count(/LoginScreen/CredentialProviders/CredentialProvider[@isForm = 'true']) = 1 or @selected = 'true')">
                                        <xsl:call-template name="login-form"/>
                                    </xsl:when>
                                    <xsl:when test="@isNewWindowRequired = 'false'">
                                        <xsl:call-template name="login-credential-provider-reload"/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:call-template name="login-credential-provider-popup"/>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </form>
                        </xsl:for-each>
                        
                        <xsl:call-template name="login-back"/>
                    </div>
                </xsl:when>
                <xsl:when test="/LoginScreen/CredentialProviders/CredentialProvider[@isNewWindowRequired = 'true']">
                    <script type="text/javascript">
                        <xsl:call-template name="login-credential-provider-script"/>
                    </script>
                </xsl:when>
                <xsl:otherwise>
                    <!-- We are in a population with a single blocking CP that does not require a new window... this should not happen -->
                </xsl:otherwise>
            </xsl:choose>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="login-form-inputs-username-wrapper">
        <xsl:param name="placeholder"/>
        <xsl:param name="hint"/>

        <xsl:variable name="autocomplete">
            <xsl:choose>
                <xsl:when test="/LoginScreen/LoginForm/autocomplete = 'true'">on</xsl:when>
                <xsl:otherwise>off</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        <div class="input-group g-mb-15">
            <div class="input-group-prepend">
                <span class="input-group-text rounded-0 g-color-gray-dark-v5">
                    <img src="{ametys:skinURL('img/icon/User.svg')}" alt=""/>
                </span>
            </div>
            <input class="form-control form-control-md border-left-0 rounded-0 g-pl-0--md" type="text" name="Username" id="Username" autocomplete="{$autocomplete}" autofocus="true" value="{$login}" onFocus="this.select();">
                <xsl:if test="$placeholder != ''">
                    <xsl:attribute name="placeholder"><xsl:value-of select="$placeholder"/></xsl:attribute>
                    <xsl:attribute name="i18n:attr">placeholder</xsl:attribute>
                </xsl:if>
            </input>
        </div>
    </xsl:template>
    
    <xsl:template name="login-form-inputs-password-wrapper">
        <xsl:param name="placeholder"/>
        <xsl:param name="hint"/>

        <xsl:variable name="autocomplete">
            <xsl:choose>
                <xsl:when test="/LoginScreen/LoginForm/autocomplete = 'true'">on</xsl:when>
                <xsl:otherwise>off</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        <div class="input-group g-mb-15">
            <div class="input-group-prepend">
                <span class="input-group-text rounded-0 g-color-gray-dark-v5">
                    <img src="{ametys:skinURL('img/icon/lock.png')}" alt=""/>
                </span>
            </div>
            <input class="form-control form-control-md border-left-0 rounded-0 g-pl-0--md" type="password" name="Password" id="Password" placeholder="Password" autocomplete="{$autocomplete}">
                <xsl:if test="$placeholder != ''">
                    <xsl:attribute name="placeholder"><xsl:value-of select="$placeholder"/></xsl:attribute>
                    <xsl:attribute name="i18n:attr">placeholder</xsl:attribute>
                </xsl:if>
            </input>
        </div>
    </xsl:template>  
    
    <xsl:template name="login-form-inputs-rememberme-internal">
        <xsl:param name="label"/>
        
        <div class="input-group g-brd-primary--focus g-mb-15 g-height-auto-important">
            <label class="form-check-inline u-check g-pl-25 g-mb-0">
                <input class="g-hidden-xs-up g-pos-abs g-top-0 g-left-0" type="checkbox" name="rememberMe" id="rememberMe" value="true"/>
                <div class="u-check-icon-checkbox-v4 g-absolute-centered--y g-left-0 g-width-15 g-height-15">
                    <i class="fa g-font-size-12 color-green" data-check-icon=""></i>
                </div>
                <span class="g-font-size-14 g-font-primary-light color-grey"><i18n:text i18n:key="{substring-after($label, ':')}" i18n:catalogue="{substring-before($label, ':')}"/></span>
            </label>
        </div>
    </xsl:template>
    
    <xsl:template name="login-form-submit">
        <button type="submit" class="btn btn-md u-btn-teal theme-btn-teal g-font-size-14 g-py-15 g-px-20">
            <i18n:translate>
                <i18n:text i18n:key="PLUGINS_CORE_AUTHENTICATION_BLOCKING_CONNECTION_LABEL" i18n:catalogue="plugin.core-impl"/>
                <i18n:param>
                    <xsl:choose>
                        <xsl:when test="/LoginScreen/LoginForm/additionalLabel"><xsl:value-of select="/LoginScreen/LoginForm/additionalLabel"/></xsl:when>
                        <xsl:otherwise><i18n:text i18n:key='PLUGINS_CORE_UI_LOGIN_SCREEN_FORM_SUBMIT' i18n:catalogue='plugin.core-ui'/></xsl:otherwise>
                    </xsl:choose>
                </i18n:param>
            </i18n:translate>
        </button>
    </xsl:template>
    
    <xsl:template name="login-user-populations-submit">
        <button type="submit" class="btn btn-md u-btn-teal theme-btn-teal g-font-size-14 g-py-15 g-px-20"><i18n:text i18n:key='PLUGINS_CORE_UI_LOGIN_SCREEN_FORM_CONTINUE' i18n:catalogue='plugin.core-ui'/></button>
    </xsl:template>
    
</xsl:stylesheet>
