<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:docbook="http://docbook.org/ns/docbook" 
							exclude-result-prefixes="ametys resolver docbook">

	<xsl:import href="skin://stylesheets/content/article/article.xsl"/>
    <xsl:import href="plugin:web://stylesheets/content/common.xsl"/>
    
    <xsl:template name="common-content-body-title"/>
    
    <xsl:template name="common-content-body-content">
    
        <xsl:variable name="page-id"><xsl:call-template name="get-page-id"/></xsl:variable>
        <xsl:variable name="page-url" select="resolver:resolve('page', $page-id, false)"/>
        
        <div class="col-lg-4 col-md-6">
            <a href="{$page-url}" class="rounded-2 u-shadow-v1-3 g-pa-30 bg-white portlet g-mb-30">
                <div>
                    <h1 class="portlet__title"><xsl:value-of select="metadata/title"/></h1>
                    <div class="portlet__text">
                        <xsl:call-template name="common-content-body-simpletext">
                            <xsl:with-param name="text" select="metadata/abstract" />
                            <xsl:with-param name="defaultText" select="metadata/content/docbook:article" />
                            <xsl:with-param name="maxDefaultTextSize" select="200" />
                        </xsl:call-template>
                    </div>
                </div>
                <span class="portlet__link">
                    <i18n:text i18n:key="CONTENT_VIEW_READMORE" i18n:catalogue="plugin.cms"/>
                    <img src="{ametys:skinURL('/img/icon/Arrow_Next_green.svg')}" alt=""/>
                </span>
            </a>
        </div>
    </xsl:template>    
    
</xsl:stylesheet>
