<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2012 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                            xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                            xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            exclude-result-prefixes="ametys">

    <xsl:import href="plugin:multimedia://stylesheets/content/photosGallery/photosGallery-main.xsl"/>
    <xsl:import href="skin://stylesheets/content/photosGallery/photosGallery.xsl"/>
	
	<xsl:variable name="zone" select="ametys:zone('default')"/>
	
	<xsl:template name="common-content-head-css">
		 <xsl:choose>
            <xsl:when test="$zone = 'default'">
                <link rel="stylesheet" type="text/css" href="{ametys:skinURL('css/images-slider.css')}" media="screen, print, handheld"/>
            </xsl:when>
            <xsl:otherwise>
                <link rel="stylesheet" type="text/css" href="{ametys:skinURL('css/jquery/jquery.thumbnailscroller.css')}" media="screen, print, handheld" />
            </xsl:otherwise>    
        </xsl:choose>
        
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('css/photosgallery.css')}" media="screen, print, handheld"/>
		<xsl:comment>[if IE 7]&gt;&lt;link rel="stylesheet" href="<xsl:value-of select="ametys:skinURL('css/photosgallery.ie7.css')" />" type="text/css" /&gt;&lt;![endif]</xsl:comment>
	</xsl:template>	
	
	<xsl:template name="common-content-head-js">
		<xsl:choose>
            <xsl:when test="$zone = 'default'">
				<script type="text/javascript" src="{ametys:skinURL('js/jquery.mousewheel.js')}"></script>
		        <script type="text/javascript" src="{ametys:skinURL('js/ui.mouse.js')}"></script>
		        <script type="text/javascript" src="{ametys:skinURL('js/jquery.reflect.js')}"></script>
		        <script type="text/javascript" src="{ametys:skinURL('js/jquery-cflow.js')}"></script>
		        <script type="text/javascript">            
		            $j(document).ready( function() {
		                $j('#coverflow-<xsl:value-of select="$uniqueId"/>').coverflow(
		                {
		                    captions: true,
		                    useReflection: true
		                });
		            });             
		        </script>  
		   	</xsl:when>
		   	<xsl:otherwise>
                <script type="text/javascript" src="{ametys:skinURL('js/jquery.thumbnailscroller.js')}"></script>
                <script type="text/javascript">
                    $j(document).ready( function() {
                        $j('#tS-<xsl:value-of select="$uniqueId"/>').thumbnailScroller(
                        {
                            scrollerType:"hoverPrecise", 
                            scrollerOrientation:"vertical", 
                            scrollSpeed:2, 
                            scrollEasing:"easeOutCirc", 
                            scrollEasingAmount:800, 
                            acceleration:4, 
                            scrollSpeed:800, 
                            noScrollCenterSpace:10, 
                            autoScrolling:0, 
                            autoScrollingSpeed:2000, 
                            autoScrollingEasing:"easeInOutQuad", 
                            autoScrollingDelay:500 
                        });
                    });                        
                </script>
            </xsl:otherwise>
		</xsl:choose>      
	</xsl:template>
	
	<xsl:template name="photos">
		<xsl:choose>
            <xsl:when test="$zone = 'default'">
                <xsl:call-template name="cover-flow"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="vertical-list"/>
            </xsl:otherwise>
        </xsl:choose>
	</xsl:template>
	
	<xsl:template name="cover-flow">
		<xsl:if test="metadata/photos/entry/image">
			<div class="coverflowContainer">
	            <ul id="coverflow-{$uniqueId}" class="photos">
					<script type="text/javascript">
						$j("#coverflow-<xsl:value-of select="$uniqueId"/>").attr('style','display:none');
						$j("#coverflow-<xsl:value-of select="$uniqueId"/>").addClass('coverflow');
					</script>
					
					<xsl:for-each select="metadata/photos/entry[image]">
						<xsl:variable name="title">
							<xsl:choose>
								<xsl:when test="alt-text != ''"><xsl:value-of select="alt-text"/></xsl:when>
								<xsl:otherwise><xsl:value-of select="image/@filename"/></xsl:otherwise>
							</xsl:choose>
						</xsl:variable>
						
						<li>
							<a href="{resolver:resolve(image/@type, image/@path)}" class="pirobox_gallery_{$uniqueId}" rel="gallery" title="{$title}">
								<xsl:if test="$rendering-context = 'back'"><xsl:attribute name="internal">internal</xsl:attribute></xsl:if>
								
								<img id="img-{$uniqueId}-{generate-id()}" src="{resolver:resolveImage(image/@type, image/@path, 150, 150)}" alt="{$title}"/>
							</a>
						</li>
					</xsl:for-each>
				</ul>
	        </div>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="vertical-list">
		<div id="tS-{$uniqueId}" class="vertical">
			<script type="text/javascript">
				$j("#tS-<xsl:value-of select="$uniqueId"/>").addClass('jThumbnailScroller');
			</script>
            <div class="jTscrollerContainer">
                <ul class="jTscroller">
                    <xsl:for-each select="metadata/photos/entry[image]">
                    	<xsl:variable name="title">
							<xsl:choose>
								<xsl:when test="alt-text != ''"><xsl:value-of select="alt-text"/></xsl:when>
								<xsl:otherwise><xsl:value-of select="image/@filename"/></xsl:otherwise>
							</xsl:choose>
						</xsl:variable>
						
                        <li>                            
                            <a href="{resolver:resolve(image/@type, image/@path)}" class="pirobox_gallery_{$uniqueId}" rel="gallery" title="{$title}">
                            	<xsl:if test="$rendering-context = 'back'">
									<xsl:attribute name="internal">internal</xsl:attribute>
								</xsl:if>
                                <img src="{resolver:resolveImage(image/@type, image/@path, 0, 100)}" alt="{$title}"/>
                            </a>
                        </li>                            
                    </xsl:for-each>
                </ul>                
            </div>
            <a href="#" class="jTscrollerPrevButton"></a>
            <a href="#" class="jTscrollerNextButton"></a>
        </div>        
	</xsl:template>
	
</xsl:stylesheet>
