<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2010 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
				xmlns:docbook="http://docbook.org/ns/docbook" 
                xmlns:html="http://www.w3.org/1999/xhtml"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xlink="http://www.w3.org/1999/xlink"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                exclude-result-prefixes="docbook xlink html i18n resolver">

    <xsl:import href="plugin:web://stylesheets/io/docbook2html.xsl" />
    
    <!-- NOTE: 
         A previous namespace error in docbook2htmleditor.xsl forces here to write the templates like docbook:name|name,
         because the docbook of some contents is now malformed 
    -->
         
    <xsl:template match="docbook:para[contains(@class, 'code') or contains(@class, 'prettyprint')]|para[contains(@class, 'code') or contains(@class, 'prettyprint')]">
        
        <xsl:variable name="codeId" select="concat('code-', generate-id())"/>
             
        <!-- Alert when copy failed -->
        <div id="alert-{$codeId}" class="code-alert alert alert-danger alert-dismissible hide" role="alert" style="display: none">
            <h4 class="h5">
                <i class="fa fa-minus-circle"></i>
                <i18n:text i18n:key="SKIN_CONTENT_COPY_CODE_ERROR_TITLE" i18n:catalogue="skin.{$skin}"/>
            </h4>
            <i18n:text i18n:key="SKIN_CONTENT_COPY_CODE_ERROR" i18n:catalogue="skin.{$skin}"/>
        </div>
        <!-- Danger Alert -->
        
        <xsl:variable name="maxLines" select="10"/>
        <xsl:variable name="nbLines" select="count(docbook:phrase|phrase) + 1"/>
        
        <div class="inline-code-wrap"> 
            <xsl:variable name="codeCls">inline-code <xsl:if test="$nbLines &gt; $maxLines">inline-code--collapsed</xsl:if></xsl:variable>
            <pre id="{$codeId}" class="{$codeCls} {@class}">
                <xsl:if test="@class = 'prettyprintLinenums'"><xsl:attribute name="class"><xsl:value-of select="$codeCls"/> prettyprint linenums</xsl:attribute></xsl:if>
                <xsl:apply-templates select="child::node()" mode="code"/>
            </pre>
            
            <!-- No formatting for copy -->
            <pre id="{$codeId}-for-copy" style="display: none">
                <xsl:apply-templates select="child::node()" mode="code"/>
            </pre>
            
            <xsl:if test="$nbLines &gt; $maxLines">
                <div class="inline-code--expand" data-modal-target="#modal-{$codeId}" data-modal-effect="fadein">
                    <button type="button">
                        <i class="fa fa-code"></i>
                        <i18n:text i18n:key="SKIN_CONTENT_SHOW_CODE" i18n:catalogue="skin.{$skin}"/>
                    </button>
                </div>
            </xsl:if>
            <div class="inline-code--actions">
                <button type="button" id="copy-{$codeId}" title="skin.{$skin}:SKIN_CONTENT_COPY_CODE" i18n:attr="title">
                    <i class="fa fa-clone"></i>
                </button>
            </div>
            
            <xsl:if test="$nbLines &gt; $maxLines">
                <div class="inline-code-blur"></div>
            </xsl:if>
        </div>
          
        <!-- Modal dialog to show code -->      
        <div tabindex="0" id="modal-{$codeId}" class="modal-code text-left g-width-90x g-height-90x g-bg-white g-color-black g-pa-20" style="display: none;">
            <button type="button" class="close g-font-size-12 g-ml-5" onclick="Custombox.modal.close();">
                <i class="hs-icon hs-icon-close"></i>
            </button>
            <pre class="{@class}">
                <xsl:if test="@class = 'prettyprintLinenums'"><xsl:attribute name="class">prettyprint linenums</xsl:attribute></xsl:if>
                <xsl:apply-templates select="child::node()" mode="code"/>
            </pre>
        </div>
        
        <script type="text/javascript">
            $j('#copy-<xsl:value-of select="$codeId"/>').click(function() {
                try
                {
                    var content = $j('#<xsl:value-of select="$codeId"/>-for-copy').text();
                    content = content.replace(/\u00a0/g, " ");
                    $j(document.body).append('&lt;textarea id="textarea-<xsl:value-of select="$codeId"/>" style="position:absolute; top: -10000px;"/&gt;');
                    $j('#textarea-<xsl:value-of select="$codeId"/>').text(content).select();
                    document.execCommand("copy");
                    $j('#textarea-<xsl:value-of select="$codeId"/>').remove();
                    
                    var $this = $(this);
                    $this.addClass("copy-success");
                    $this.children("i").addClass("fa-check").removeClass("fa-clone");

                    setTimeout(function () { $this.removeClass("copy-success"); $this.children("i").addClass("fa-clone").removeClass("fa-check") }, 1000);
                } 
                catch(e) 
                {
                    $j('#alert-<xsl:value-of select="$codeId"/>').show().removeClass("hide").addClass("show");
                    setTimeout(function () { $j('#alert-<xsl:value-of select="$codeId"/>').removeClass("show").addClass("hide"); }, 3000);
                    setTimeout(function () { $j('#alert-<xsl:value-of select="$codeId"/>').hide() }, 3500);
                }
          
            });
        </script>
    </xsl:template>
    
    <xsl:template match="docbook:phrase[@role='linebreak']|phrase[@role='linebreak']" mode="code">
        <xsl:text>&#10;</xsl:text>
    </xsl:template>
    
    <xsl:template match="docbook:emphasis|emphasis" mode="code">
        <xsl:choose>
            <xsl:when test="@role='strong'">
                <strong><xsl:apply-templates mode="code"/></strong>
            </xsl:when>
            <xsl:otherwise>
                <em><xsl:apply-templates mode="code"/></em>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="docbook:table[contains(@class, 'data')]">
        <div class="table">
            <table>
                <xsl:attribute name="class"><xsl:value-of select="@class" /></xsl:attribute>
                <xsl:apply-templates select="child::node()"></xsl:apply-templates>
            </table>
        </div>
    </xsl:template>
    
    <xsl:template match="docbook:para[html:toc]">
        <xsl:if test="following-sibling::docbook:section">
            <ol class="toc">
                 <xsl:apply-templates select="following-sibling::docbook:section" mode="toc">
                    <xsl:with-param name="level" select="'1'"/>
                </xsl:apply-templates>
            </ol>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="docbook:section">
        <xsl:param name="level"/>
        <a name="{generate-id()}"/>
        <xsl:if test="docbook:title/node()">
            <xsl:element name="h{$level}">
                <xsl:call-template name="get-styles"/>
                <xsl:apply-templates select="docbook:title/node()"/>
            </xsl:element>
        </xsl:if>
        <xsl:apply-templates select="*[name() != 'section' and name() != 'title']"/>
        <xsl:apply-templates select="docbook:section">
            <xsl:with-param name="level" select="$level+1"/>
        </xsl:apply-templates>
    </xsl:template>

    <xsl:template match="docbook:section" mode="toc">
        <xsl:param name="level" />
        <xsl:param name="style" />
        <xsl:choose>
            <xsl:when test="not(docbook:title = '')">
                <li style="list-style-type:disc;">
                    <a href="#{generate-id()}">
                        <xsl:value-of select="docbook:title" />
                    </a>
                    <xsl:if test="docbook:section">
                        <ol>
                            <xsl:if test="$style != ''">
                                <xsl:attribute name="class"><xsl:value-of
                                    select="$style" /></xsl:attribute>
                            </xsl:if>
                            <xsl:apply-templates select="docbook:section"
                                mode="toc">
                                <xsl:with-param name="level" select="$level + 1" />
                            </xsl:apply-templates>
                        </ol>
                    </xsl:if>
                </li>
            </xsl:when>
            <xsl:otherwise>
                            <xsl:apply-templates select="docbook:section"
                                mode="toc">
                                <xsl:with-param name="level" select="$level + 1" />
                            </xsl:apply-templates>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template match="docbook:literallayout[@monospaced='true' and @class='monospaced']|literallayout[@monospaced='true' and @class='monospaced']">
        <span monospaced="true" class="monospaced">
            <xsl:apply-templates/>
        </span>
    </xsl:template>
    
    <!-- Remove pirobox (use fancybox) -->
    <xsl:template name="image-wrapper">
      <xsl:variable name="src-full" select="resolver:resolve(docbook:imagedata/@type, docbook:imagedata/@fileref)"/>

      <span style="display: inline-block; text-align: center" class="image-wrapper {../@class}">

            <xsl:choose>
                <xsl:when test="../@zoomable and not($src-full = '') and not(ancestor::docbook:link)">
                    <a href="{$src-full}" class="js-fancybox" data-fancybox="lightbox-gallery-{$uniqueId}" rel="single" title="{../docbook:caption}" data-overlay-bg="rgba(0, 0, 0, 1)">
                        <xsl:call-template name="image-wrapper-link-attributes"/>
                        <xsl:call-template name="image" />
                    </a>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="image" />
                </xsl:otherwise>
            </xsl:choose>          
                            
            <xsl:if test="../docbook:caption">
                <br style="clear: both"/>
            
                <span class="legend">
                    <xsl:variable name="width"><xsl:value-of select="substring-before(docbook:imagedata/@width, 'px')" /></xsl:variable>
                    <xsl:attribute name="style">display: inline-block;<xsl:if test="$width != ''"> width: <xsl:value-of select="$width"/>px;</xsl:if></xsl:attribute>
                    
                    <xsl:value-of select="../docbook:caption" />
                </span>
            </xsl:if>
        </span>
    </xsl:template>
    
</xsl:stylesheet>
