<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2018 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
		xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
		xmlns:xalan="http://xml.apache.org/xalan"
		xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
		xmlns:date="http://exslt.org/dates-and-times" extension-element-prefixes="date"
		exclude-result-prefixes="sitemap ametys resolver">

	<xsl:import href="skin://stylesheets/main.xsl" />

    <xsl:template name="body">
        <body class="bg-body page-index">
            <div id="overlaySection" onclick="void(0)"></div>
            
            <div class="wrapper footer-stick g-pt-130--lg g-pt-100">
                <xsl:call-template name="header" />
                <xsl:call-template name="center"/>
            </div>
            
            <xsl:call-template name="footer" />
            
        </body>
    </xsl:template>
    
    <xsl:template name="center">
        <div class="container g-pt-90"><!-- container -->
            <xsl:call-template name="main-zone"/>
            
            <xsl:call-template name="link-directory-input-data"/>
            
            <xsl:call-template name="home-search-input"/>
            
            <xsl:call-template name="bottom-zone"/>
            <!-- FIXME A décommenter si la solution 2 pour la zone du bas est choisie -->
            <!-- <xsl:call-template name="blocs-input-data"/> -->
        </div>
    </xsl:template>  
    
    <xsl:template name="home-search-input">
        <xsl:variable name="searchPage" select="ametys:findPagesIdsByTag('SEARCH')"/>
        <xsl:if test="$searchPage">
            <div class="search-middle u-shadow-v1-3 g-mb-100--lg g-mb-40"><!-- search-middle -->
                <form method="post" id="form-index-search" action="{resolver:resolve('page', $searchPage/@id)}">
                    <input id="form-index-search-textfield" name="textfield" type="text" placeholder="skin.{$skin}:SKIN_HELP_INPUT_PLACEHOLDER" i18n:attr="placeholder"/>
                    <input name="submit-form" type="hidden" value="mainSearch" />
                </form>
            </div><!-- search-middle END -->
            
            <script type="text/javascript">
                $j().ready(function() 
                {
                    $( "#form-index-search-textfield").keyup(function() {
                        if (event.key === "Enter")
                        {
                            $( "#form-index-search").submit();
                        }
                    });
                });
            </script>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="main-zone">
        <zone name="default" level="1"/>
    </xsl:template> 
    
    <xsl:template name="link-directory-input-data">
        <xsl:if test="/cms/inputData/linkDirectory/links/link">
            <div class="js-carousel u-carousel-v5 g-mb-60" id="carousel1"><!-- slider -->
                <xsl:for-each select="/cms/inputData/linkDirectory/links/link[@userLink='false' and position() &lt; 4]">
                    <div class="js-slide text-center g-px-15 g-mb-10">
                        <a target="_blank" title="{@title}" class="d-flex flex-column justify-content-center align-items-center text-center">
                            <xsl:attribute name="href">
                                <xsl:choose>
                                    <xsl:when test="@urlType = 'PAGE'">
                                        <xsl:value-of select="resolver:resolve('page', @url)"/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:value-of select="@url"/>
                                    </xsl:otherwise>
                                </xsl:choose>
                            </xsl:attribute>
                            <div class="d-flex align-items-center justify-content-center g-width-80 g-height-80 g-rounded-50x bg-transparent-white-0_2 g-mb-16">
                                <xsl:call-template name="link-illustration"/>
                            </div>
                            <p class="g-font-primary-light color-white g-font-size-16--md">
                                <xsl:value-of select="@content"></xsl:value-of>
                            </p>
                        </a>
                    </div>
                </xsl:for-each>
            </div><!-- slider END -->
        </xsl:if>
    </xsl:template> 
    
    <xsl:template name="link-illustration">
        <xsl:choose>
            <xsl:when test="@pictureType = 'glyph'">
                <i class="color-white g-font-primary-light g-font-size-26 {@pictureGlyph}"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:variable name="id">
                    <xsl:choose>
                        <xsl:when test="@pictureType = 'resource'">
                            <xsl:value-of select="@pictureId"/>
                        </xsl:when>
                        <xsl:when test="@pictureType = 'external'">
                            <xsl:value-of select="concat(@picturePath, '?objectId=', @id)"/>
                        </xsl:when>
                    </xsl:choose>
                </xsl:variable>
                <img src="{resolver:resolveBoundedImage(@imageType, $id, 26, 26)}" alt="{@pictureAlternative}"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="blocs-input-data">
        <xsl:if test="/cms/inputData/Model/blocs/content">
            <div class="row g-mb-80--md g-mb-40">
                <!-- Order blocs by sitemap -->
                <xsl:for-each select="/cms/inputData/sitemap//page">
                    <xsl:variable name="pageId" select="@sitemap:id"/>
                    <xsl:if test="/cms/inputData/Model/blocs/content[html/head/meta[@name='pages/page;id']/@content = $pageId]">
                        <xsl:variable name="content" select="/cms/inputData/Model/blocs/content[html/head/meta[@name='pages/page;id']/@content = $pageId]"/>
                        <div class="col-lg-4 col-md-6">
                            <a href="{resolver:resolve('page', $pageId)}" class="rounded-2 u-shadow-v1-3 g-pa-30 bg-white portlet g-mb-30">
                                <div>
                                    <h2 class="portlet__title"><xsl:value-of select="$content/@title"/></h2>
                                    <div class="portlet__text">
                                        <xsl:copy-of select="$content/html/body//p[contains(@class, 'content-abstract')]"/>
                                    </div>
                                </div>
                                <span class="portlet__link">
                                    <i18n:text i18n:key="CONTENT_VIEW_READMORE" i18n:catalogue="plugin.cms"/>
                                    <img src="{ametys:skinURL('/img/icon/Arrow_Next_green.svg')}" alt=""/>
                                </span>
                            </a>
                        </div>
                    </xsl:if>
                </xsl:for-each>
            </div>
        </xsl:if>
    </xsl:template>
    
</xsl:stylesheet>