<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
							xmlns:xalan="http://xml.apache.org/xalan"
							xmlns:math="java.lang.Math"
							xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
							xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            xmlns:user="org.ametys.plugins.userdirectory.transformation.xslt.UserXSLTHelper"
							exclude-result-prefixes="sitemap resolver ametys">
	
    <xsl:import href="skin://stylesheets/search.xsl" />
    <xsl:import href="skin://stylesheets/utils.xsl" />
    
    <xsl:variable name="allalertes" select="ametys:findPagesIdsByTag('ALL_FLASH_INFO')"/>
    
    <xsl:template name="header">
        <header class="ametys-header ametys-header_with-sidebar-left">
            <div class="container-fluid d-flex align-items-center px-0">
                <xsl:call-template name="header-left"/>
                
                <xsl:call-template name="header-middle"/>
                
                <xsl:call-template name="header-right"/>
            </div>
        </header>
    </xsl:template>
    
    <xsl:template name="header-left">
        <div class="ametys-header-left">
                    
            <div class="ametys-invoker-wrap">
                <span class="ametys-header-invoker"
                      data-target-hide="body">
                    <span class="ametys-header-invoker__bar"></span>
                    <span class="ametys-header-invoker__bar"></span>
                    <span class="ametys-header-invoker__bar"></span>
                    <span class="ametys-header-invoker__bar"></span>
                </span>
            </div>
            
            <!-- <div class="ametys-header-logo-wrap"> -->
            
            <!-- General search input -->
            <xsl:call-template name="search"/>
        </div>
    </xsl:template>
    
    <xsl:template name="header-middle">
        <div class="ametys-header-middle">
                    
            <div class="ametys-header-action-wrap">
                <div id="action" class="ametys-header-action">
                    
                    <ul class="ametys-header-action-nav">
                        
                        <xsl:call-template name="notification-links"/>
                        <xsl:call-template name="alerts"/>
                    </ul>
                </div>
                
                <span class="ametys-header-action-invoker"
                      data-target-show="#action">
                    <span class="ametys-header-action-invoker__icon material-icons filter_list"></span>
                </span>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="notification-links">
        <xsl:apply-templates select="cms/inputData/linkDirectory[@id='topMenu']/links/link" mode="top-menu">
           <xsl:with-param name="uniqueId" select="$uniqueId"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template name="alerts">
        <li class="ametys-header-action-nav__item alerts-item">
            
            <a href="{resolver:resolve('page', $allalertes/@id)}" target="_blank" class="ametys-header-action-nav__link">
                <div class="ametys-header-action-nav__item-left">
                	<span class="link-dynamic-info">
                        <xsl:choose>
                            <xsl:when test="count(/cms/inputData/Model/alerte-notification/content) != 0 and ametys:findPagesIdsByTag('BLOCKING_FLASH_INFO')">
                                <span class="ametys-header-action-nav__item-badge"><xsl:value-of select="count(/cms/inputData/Model/alerte-notification/content)"/></span>
                            </xsl:when>
                            <xsl:otherwise>
                                 <span class="ametys-header-action-nav__item-badge"><xsl:value-of select="count(/cms/inputData/Model/alerte-notification/content)"/></span>
                            </xsl:otherwise>
                        </xsl:choose>
                    </span>
                    <xsl:call-template name="alerts-icon"/>
                </div>
                <div class="ametys-header-action-nav__item-text"><i18n:text i18n:key="SKIN_ALERT" i18n:catalogue="skin.{$skin}" /></div>
            </a>
            <xsl:call-template name="display-alerts"/>
        </li>
    </xsl:template>
    
    <xsl:template name="alerts-icon">
    	<span class="ametys-header-action-nav__item-icon picture link-glyph material-icons notifications_none"></span>
    </xsl:template>
    
    <xsl:template name="display-alerts">
    
      <span class="link-info-tooltip">
         <xsl:choose>
           <xsl:when test="/cms/inputData/Model/alerte-notification/content">
                <span class="link-info-long-value"><i18n:text i18n:key="SKIN_ALERTS" i18n:catalogue="skin.{$skin}"/> (<xsl:value-of select="count(/cms/inputData/Model/alerte-notification/content)"/>)</span>
                <ul>
                 <xsl:for-each select="/cms/inputData/Model/alerte-notification/content">
                   <li class="link-info-item">
                       <xsl:copy-of select="html/body"/>
                   </li>
                </xsl:for-each>
                </ul>
                <xsl:call-template name="alerts-all-link"/> 
           </xsl:when>
           <xsl:otherwise>
               <xsl:call-template name="alerts-none"/>
           </xsl:otherwise>
       </xsl:choose>
     </span>
    </xsl:template>
    
    <xsl:template name="alerts-title">
        <span class="link-info-long-value"><i18n:text i18n:key="SKIN_ALERTS_TITLE" i18n:catalogue="skin.{$skin}"/></span>
    </xsl:template>
    
    <xsl:template name="alerts-none">
        <span class="dropdown empty">
            <span class="link-info-long-value"><i18n:text i18n:key="SKIN_ALERTS_NO_ALERT" i18n:catalogue="skin.{$skin}"/></span>
        </span>
    </xsl:template>
    
     <xsl:template name="alerts-all-link">
        <xsl:variable name="allalertes" select="ametys:findPagesIdsByTag('ALL_FLASH_INFO')"/>
        <xsl:if test="$allalertes">
           <div class="link">
               <a href="{resolver:resolve('page', $allalertes/@id)}" class="btn btn-info btn-sm">  
                   <span><i18n:text i18n:key="SKIN_ALERTS_ALL_ALERTS" i18n:catalogue="skin.{$skin}"/></span>
               </a>
           </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="alerts-mobile">
        <li class="icon alertes_mobiles" id="mes_alertes">
            <a href="{resolver:resolve('page', $allalertes/@id)}">
                <span class="flex">
                    <xsl:call-template name="alerts-icon"/>
                
                    <xsl:if test="count(/cms/inputData/Model/alerte-notification/content) != 0">
                        <span class="badge"> 
                            <xsl:value-of select="count(/cms/inputData/Model/alerte-notification/content)"/>
                        </span>
                    </xsl:if>
                </span>
            </a>
        </li>
    </xsl:template>
    
    <xsl:template name="header-right">
        <div class="ametys-header-right">
            <xsl:variable name="currentUser" select="ametys:user()"/>
            
            <div class="ametys-header-profile">
                <a class="ametys-header-profile__invoker">
                    <span class="ametys-header-profile__invoker-text">
                        <xsl:value-of select="substring($currentUser/user/firstname, 1, 1)"/><xsl:text>. </xsl:text>
                        <xsl:value-of select="$currentUser/user/lastname"/>
                    </span>
                    
                    <xsl:call-template name="user-profile-image">
                        <xsl:with-param name="size">32</xsl:with-param>
                        <xsl:with-param name="population" select="$currentUser/user/@population"/>
                        <xsl:with-param name="login" select="$currentUser/user/@login"/>
                        <xsl:with-param name="class">ametys-header-profile__invoker-img ametys-header-profile__invoker-img_right</xsl:with-param>
                    </xsl:call-template>
                </a>
                
                <xsl:call-template name="user-menu"/>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="user-menu">
        <xsl:variable name="currentUserPageId" select="user:getCurrentUserPage($lang)"/>
        <div>
            <xsl:if test="$currentUserPageId != ''">
                <a href="{resolver:resolve('page', $currentUserPageId)}">
                    <i18n:text i18n:key="SKIN_ACCOUNT" i18n:catalogue="skin.{$skin}"/>
                </a>
            </xsl:if>
            <a href="{ametys:siteUriPrefix()}/logout.html?requestedURL={ametys:siteUriPrefix()}/{$lang}/index.html">
                <i class="fas fa-sign-out-alt"></i>
                <i18n:text i18n:key="SKIN_LOGOUT" i18n:catalogue="skin.{$skin}"/>
            </a>
        </div>
    </xsl:template>
	
</xsl:stylesheet>