<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
							xmlns:xalan="http://xml.apache.org/xalan"
							xmlns:math="java.lang.Math"
							xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
							xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
							exclude-result-prefixes="sitemap resolver ametys">
	<!-- + 
	     | MENU
	     + -->
         
    <xsl:template name="menu">
        <a name="menu"></a>
        <ul id="secondaryMenu" class="ametys-sidebar-secondary-nav">
            <xsl:apply-templates select="/cms/inputData/sitemap/page[@PLUGIN_TAGS_SECTION and (not(@sitemap:invisible) or @sitemap:invisible = 'false')]" mode="main-menu-level1"/>
        </ul>
    </xsl:template>
    
    <xsl:template match="page" mode="main-menu-level1">
        <xsl:variable name="inPathCssClass"><xsl:if test="@sitemap:in-path = 'true'"> active</xsl:if></xsl:variable>
        
        <li class="ametys-sidebar-secondary-nav__item ametys-sidebar-secondary-nav__item_top-level{$inPathCssClass}">
            <div class="ametys-sidebar-secondary-nav__link{$inPathCssClass}">
                <a class="ametys-sidebar-secondary-nav__link-text" href="{resolver:resolve('page', @sitemap:id)}">
                    <xsl:if test="@sitemap:type = 'LINK' and @sitemap:link-type = 'WEB'">
                        <xsl:call-template name="external-link-attributes">
                            <xsl:with-param name="title" select="@sitemap:title"/>
                            <xsl:with-param name="className">ametys-sidebar-secondary-nav__link-text external</xsl:with-param>
                        </xsl:call-template>
                    </xsl:if>
                    <xsl:value-of select="@sitemap:title" />
                </a>
                
                <xsl:if test="page[not(@sitemap:invisible) or @sitemap:invisible = 'false']">
                    <xsl:apply-templates select="." mode="arrow-invoker"/>
                </xsl:if>
            </div>
            
            <xsl:if test="page[not(@sitemap:invisible) or @sitemap:invisible = 'false']">
                <ul id="subMenu{generate-id()}"
                    aria-labelledby="subMenu{generate-id()}Invoker"
                    data-parent="#secondaryMenu">
                    <xsl:attribute name="class">
                        <xsl:text>ametys-sidebar-secondary-nav ametys-sidebar-secondary-nav_submenu</xsl:text> 
                        <xsl:if test="not(@sitemap:in-path = 'true')"> collapse</xsl:if>
                    </xsl:attribute>
                                    
                    <xsl:apply-templates select="page[not(@sitemap:invisible) or @sitemap:invisible = 'false']" mode="main-menu-level2">
                        <xsl:with-param name="parentMenuId" select="concat('subMenu', generate-id())"/>
                    </xsl:apply-templates>
                </ul>
            </xsl:if>
        </li>
    </xsl:template>
    
    <xsl:template match="page" mode="main-menu-level2">
        <xsl:param name="parentMenuId"/>
        
        <xsl:variable name="inPathCssClass"><xsl:if test="@sitemap:in-path = 'true'"> active</xsl:if></xsl:variable>
        <li class="ametys-sidebar-secondary-nav__item{$inPathCssClass}">
            <div class="ametys-sidebar-secondary-nav__link{$inPathCssClass}">
                <a href="{resolver:resolve('page', @sitemap:id)}">
                    <xsl:if test="@sitemap:type = 'LINK' and @sitemap:link-type = 'WEB'">
                        <xsl:call-template name="external-link-attributes">
                            <xsl:with-param name="title" select="@sitemap:title"/>
                        </xsl:call-template>
                    </xsl:if>
                    <xsl:value-of select="@sitemap:title" />
                </a>
                
                 <xsl:if test="page[not(@sitemap:invisible) or @sitemap:invisible = 'false']">
                    <xsl:apply-templates select="." mode="arrow-invoker"/>
                </xsl:if>
            </div>
            
            <xsl:if test="page[not(@sitemap:invisible) or @sitemap:invisible = 'false']">
                <ul id="subMenu{generate-id()}"
                    aria-labelledby="subMenu{generate-id()}Invoker"
                    data-parent="#{$parentMenuId}">
                    <xsl:attribute name="class">
                        <xsl:text>ametys-sidebar-secondary-nav ametys-sidebar-secondary-nav_submenu</xsl:text> 
                        <xsl:if test="not(@sitemap:in-path = 'true')"> collapse</xsl:if>
                    </xsl:attribute>
                    
                    <xsl:apply-templates select="page[not(@sitemap:invisible) or @sitemap:invisible = 'false']" mode="main-menu-level3"/>
                </ul>
            </xsl:if>
        </li>
    </xsl:template>
    
    <xsl:template match="page" mode="main-menu-level3">
        <xsl:variable name="inPathCssClass"><xsl:if test="@sitemap:in-path = 'true'"> active</xsl:if></xsl:variable>
        
        <li class="ametys-sidebar-secondary-nav__item{$inPathCssClass}">
            <div class="ametys-sidebar-secondary-nav__link{$inPathCssClass}">
                <a href="{resolver:resolve('page', @sitemap:id)}">
                    <xsl:if test="@sitemap:type = 'LINK' and @sitemap:link-type = 'WEB'">
                        <xsl:call-template name="external-link-attributes">
                            <xsl:with-param name="title" select="@sitemap:title"/>
                        </xsl:call-template>
                    </xsl:if>
                    <xsl:value-of select="@sitemap:title" />
                </a>
            </div>
        </li>
    </xsl:template>
    
    <xsl:template match="page" mode="arrow-invoker">
        <xsl:variable name="collapsedCssClass"><xsl:if test="not(@sitemap:in-path) or  @sitemap:in-path = 'false'"> collapsed</xsl:if></xsl:variable>
        <a id="subMenu{generate-id()}Invoker" class="ametys-sidebar-secondary-nav__link-invoker{$collapsedCssClass}" href="#"
           aria-controls="subMenu{generate-id()}"
           data-target="#subMenu{generate-id()}">
           <xsl:choose>
                <xsl:when test="@sitemap:in-path = 'true'">
                    <xsl:attribute name="aria-expanded">true</xsl:attribute>
                    <xsl:attribute name="data-toggle"></xsl:attribute>
               </xsl:when>
               <xsl:otherwise>
                    <xsl:attribute name="aria-expanded">false</xsl:attribute>
                    <xsl:attribute name="data-toggle">collapse</xsl:attribute>
               </xsl:otherwise>
           </xsl:choose>

            <xsl:apply-templates select="." mode="arrow-invoker-icon"/>
        </a>
    </xsl:template>
    
    <xsl:template match="page" mode="arrow-invoker-icon">
    	<span class="material-icons keyboard_arrow_right"></span>
    </xsl:template>
	
</xsl:stylesheet>