<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
							xmlns:exsl="http://exslt.org/common"
							xmlns:math="java.lang.Math"
							xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
							xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
							exclude-result-prefixes="sitemap resolver ametys">

	<xsl:import href="plugin:socialnetworking://stylesheets/helpers/sharethis.xsl" />
    <xsl:import href="plugin:socialnetworking://stylesheets/helpers/sendByMail.xsl" />

	<xsl:variable name="raw-translations">
		<xsl:for-each select="/cms/page/metadata/translations/*">
			<xsl:variable name="hrefResolved" select="resolver:resolve('page', .)"/>
			<xsl:if test="$hrefResolved != ''">
				<xsl:element name="{local-name()}">
					<xsl:value-of select="$hrefResolved"/>
				</xsl:element>
			</xsl:if>
		</xsl:for-each>
	</xsl:variable>
	<xsl:variable name="translations" select="exsl:node-set($raw-translations)"/>

	<!-- + 
	     | ACCCESSIBILITY LINKS
	     + -->
	<xsl:template name="accessibility-links">
		<div id="page-wai-links" class="page-wai-links">
			<a href="#content"><i18n:text i18n:key="SKIN_ACCESSIBILITY_LINKS_GOTO_CONTENT" i18n:catalogue="skin.{$skin}"/></a>
			<a href="#search"><i18n:text i18n:key="SKIN_ACCESSIBILITY_LINKS_GOTO_SEARCH" i18n:catalogue="skin.{$skin}"/></a>
			<a href="#menu"><i18n:text i18n:key="SKIN_ACCESSIBILITY_LINKS_GOTO_MENU" i18n:catalogue="skin.{$skin}"/></a>
		</div>
	</xsl:template>

	
	<!-- + 
	     | BREAD CRUMB
	     + -->
	<xsl:template name="bread-crumb">
		<a name="breadcrumb"></a>
		
		<ul class="ametys-breadcrumb">
			<xsl:if test="/cms/inputData/sitemap/page[@sitemap:name = 'index']">
				<li class="ametys-breadcrumb__item">
                       <xsl:if test="$conf-microformat='true'">
                           <xsl:attribute name="itemscope">itemscope</xsl:attribute>
                           <xsl:attribute name="itemtype">http://data-vocabulary.org/Breadcrumb</xsl:attribute>
                       </xsl:if>

                       <a href="{$site-uri-prefix}/{$lang}/index.html" class="ametys-breadcrumb__link">
                           <xsl:if test="$conf-microformat='true'">
                               <xsl:attribute name="itemprop">url</xsl:attribute>
                           </xsl:if>

                           <span>
                               <xsl:if test="$conf-microformat='true'">
                                   <xsl:attribute name="itemprop">title</xsl:attribute>
                               </xsl:if>
                               
                               <xsl:value-of select="/cms/inputData/sitemap/page[@sitemap:name = 'index']/@sitemap:title"/>
                           </span>
                       </a>
                   </li>
			</xsl:if>
			
            <xsl:apply-templates select="/cms/inputData/sitemap/page[not(@sitemap:path = 'index') and @sitemap:in-path = 'true']|/cms/inputData/sitemap/page[@sitemap:path = 'index']/page[@sitemap:in-path = 'true']" mode="breadcrumb"/>
		</ul>
	</xsl:template>
    
    <xsl:template match="page" mode="breadcrumb">
        <li class="ametys-breadcrumb__item">
            <xsl:if test="$conf-microformat='true'">
               <xsl:attribute name="itemscope">itemscope</xsl:attribute>
               <xsl:attribute name="itemtype">http://data-vocabulary.org/Breadcrumb</xsl:attribute>
           </xsl:if>
               
           <xsl:call-template name="breadcrumb-separator"/>
           
           <xsl:choose>
                <xsl:when test="not(@sitemap:current)">
                    <a href="{resolver:resolve('page', @sitemap:id)}" class="ametys-breadcrumb__link">
                       <xsl:if test="$conf-microformat='true'">
                           <xsl:attribute name="itemprop">url</xsl:attribute>
                       </xsl:if>
                       <xsl:value-of select="@sitemap:long-title" />
                   </a>
               </xsl:when>
               <xsl:otherwise>
                    <span>
                       <xsl:if test="$conf-microformat='true'">
                           <xsl:attribute name="itemprop">title</xsl:attribute>
                       </xsl:if>
                       <xsl:value-of select="@sitemap:long-title" />
                   </span>
            </xsl:otherwise>
            </xsl:choose>
        </li>
        
        <xsl:apply-templates select="page[@sitemap:in-path = 'true']" mode="breadcrumb"/>
    
    </xsl:template>
    
    <xsl:template name="breadcrumb-separator">
        <span class="ametys-breadcrumb__divider"> / </span>
    </xsl:template>
	
	<!-- +
		 | PDF
		  -->
	<xsl:template name="pdf">
        <xsl:variable name="article-content-name" select="/cms/page/pageContents/zone[@name = 'default']/zoneItem[information/type-information/@id = 'org.ametys.web.default.Content.article' and information/type = 'CONTENT'][1]/information/contentName"/>
        <xsl:variable name="news-content-name" select="/cms/page/pageContents/zone[@name = 'default']/zoneItem[information/type-information/@id = 'org.ametys.plugins.news.Content.news' and information/type = 'CONTENT'][1]/information/contentName"/>
        <xsl:variable name="odf-content-name" select="/cms/page/pageContents/zone[@name = 'default']/zoneItem[information/type-information/@id = 'org.ametys.plugins.odf.Content.program' and information/type = 'CONTENT'][1]/information/contentName"/>
        
        <xsl:variable name="pdfHref">
            <xsl:choose>
                <xsl:when test="string-length($article-content-name) &gt; 0">
                    <xsl:value-of select="concat($site-uri-prefix, '/_content/', $article-content-name, '.pdf')"/>
                </xsl:when>
                <xsl:when test="string-length($news-content-name) &gt; 0">
                    <xsl:value-of select="concat($site-uri-prefix, '/_content/', $news-content-name, '.pdf')"/>
                </xsl:when>
                <xsl:when test="string-length($odf-content-name) &gt; 0">
                    <xsl:value-of select="concat($uri-prefix, '/plugins/odf-web/', $site, '/_content/', $odf-content-name, '.pdf')"/>
                </xsl:when>
            </xsl:choose>
        </xsl:variable>
              
		<xsl:if test="string-length($pdfHref) != 0">
			<div id="pdf-icon">
				<xsl:attribute name="class"><xsl:text>art-pdf</xsl:text><xsl:if test="$translations/*">-with-separator</xsl:if></xsl:attribute>
				<a href="{$pdfHref}" onclick="window.open(this.href); return false;" title="skin.{$skin}:SKIN_DOWNLOAD_PDF_TITLE" i18n:attr="title">
					<img src="{ametys:skinURL('templates/common/img/PDF.png')}" alt="skin.{$skin}:SKIN_DOWNLOAD_PDF_ALT" i18n:attr="alt"/>
				</a>
			</div>
			<xsl:if test="$translations/*">
				<script type="text/javascript">
					$j("#pdf-icon").removeClass("art-pdf-with-separator");
					$j("#pdf-icon").addClass("art-pdf");
				</script>
			</xsl:if>
		</xsl:if>
	</xsl:template>		
    
    <!-- +
         | Matomo stats
         + -->
    <xsl:template name="matomo-stats">
        <xsl:param name="csstemplate" select="$template"/>
        
        <xsl:variable name="piwikUrl" select="ametys:config('piwik-url')"/>
        <xsl:variable name="piwikId" select="ametys:siteParameter('piwik-id')"/>
        <xsl:variable name="statsEnabled" select="ametys:siteParameter('matomo-live-stats')"/>
        
        <xsl:if test="ametys:renderingContext() = 'front' and normalize-space($piwikId) != '' and normalize-space($piwikUrl) != '' and $statsEnabled = 'true'">
            <span class="nb-visits {$csstemplate}" style="display: none" tabindex="0">
                <span class="icon fa-solid fa-eye" aria-hidden="true"></span>
                <span id="nb-visits-multiple"><i18n:text i18n:key="SKIN_MATOMO_STATS_VISITS" i18n:catalogue="skin.{$skin}"/></span>
                <span id="nb-visits-single"><i18n:text i18n:key="SKIN_MATOMO_STATS_VISIT" i18n:catalogue="skin.{$skin}"/></span>
                
                <span class="nb-visits-tooltip sr-only">
                     <i18n:text i18n:key="SKIN_MATOMO_STATS_VISITS_TOOLTIP" i18n:catalogue="skin.{$skin}"/>
                </span>
            </span>
            <script type="text/javascript">
               $j(document).ready(function() {
                 AmetysMatomoHelper.getPageData(".nb-visits", "<xsl:value-of select="$site-uri-prefix" />", null, function() {
                    var nbVisits = $j(".nb-visits #nb-visits-multiple [data-matomo='nb-visits']").text();
                    if (nbVisits)
                    {
                        if (Number(nbVisits) == 1)
                        {
                            $j(".nb-visits #nb-visits-multiple").remove();
                        }
                        else
                        {
                            $j(".nb-visits #nb-visits-single").remove();
                        }
                            
                        $j(".nb-visits").show();
                        
                        // Tooltip
                        $j(".nb-visits").attr("data-toggle", "tooltip");
                        $j(".nb-visits").attr("data-placement", "top");
                        $j(".nb-visits").attr("data-original-title", $j(this).text());
                        $j(".nb-visits").attr("title", $j(".nb-visits .nb-visits-tooltip").text());
                        $j(".nb-visits").tooltip();
                    }
                    else
                    {
                        $j(".nb-visits").remove();
                    }
                  });
               });
            </script>
        </xsl:if>
    </xsl:template>
	
</xsl:stylesheet>
