<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
		xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
		xmlns:xalan="http://xml.apache.org/xalan"
		xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
		xmlns:date="http://exslt.org/dates-and-times" extension-element-prefixes="date"
		exclude-result-prefixes="sitemap ametys">

	<xsl:import href="skin://stylesheets/main.xsl" />
	
	<!-- EDITION FO -->
    <xsl:import href="plugin:front-edition://stylesheets/front-edition.xsl"/>
    
    <xsl:template name="additionnal-script" >
        <xsl:call-template name="ametys-front-edition-head">
            <xsl:with-param name="start">load</xsl:with-param>
            <xsl:with-param name="editActionId">2</xsl:with-param>
            <xsl:with-param name="insertAttachmentActionId">2</xsl:with-param>
            <xsl:with-param name="edition-mode-only" select="false()"/>
        </xsl:call-template>
    </xsl:template>
    
    <!-- + 
         | ADDITIONNAL CSS
         + -->
    <xsl:template name="front-edition-css">
        <link rel="stylesheet" href="{ametys:skinURL('templates/common/scss/front-edition/front-edition.css')}" />
    </xsl:template>
	
    <!-- + 
	     | MAIN ZONE
	     + -->
	<xsl:template name="main-zone">
	   <xsl:call-template name="ametys-front-edition-page-toolbar">
            <xsl:with-param name="add-contents-config">
                [
                {"contentType": "org.ametys.web.default.Content.article", "icon": "fas fa-file-alt", "zoneName": "default", "label": "<i18n:text i18n:key="SKIN_FRONT_EDITION_TOOLBAR_PAGE_ACTIONS_ADD_ARTICLE" i18n:catalogue="skin.{$skin}"/>"},
                {"contentType": "org.ametys.plugins.news.Content.news", "icon": "fas fa-file-alt", "zoneName": "default", "label": "<i18n:text i18n:key="SKIN_FRONT_EDITION_TOOLBAR_PAGE_ACTIONS_ADD_NEWS" i18n:catalogue="skin.{$skin}"/>"},
                {"contentType": "org.ametys.plugins.multimedia.Content.document", "icon": "fas fa-file-alt", "zoneName": "default", "label": "<i18n:text i18n:key="SKIN_FRONT_EDITION_TOOLBAR_PAGE_ACTIONS_ADD_DOCUMENT" i18n:catalogue="skin.{$skin}"/>"},
                {"contentType": "org.ametys.plugins.multimedia.Content.audio", "icon": "fas fa-file-alt", "zoneName": "default", "label": "<i18n:text i18n:key="SKIN_FRONT_EDITION_TOOLBAR_PAGE_ACTIONS_ADD_AUDIO" i18n:catalogue="skin.{$skin}"/>"},
                {"contentType": "org.ametys.plugins.multimedia.Content.video", "icon": "fas fa-file-alt", "zoneName": "default", "label": "<i18n:text i18n:key="SKIN_FRONT_EDITION_TOOLBAR_PAGE_ACTIONS_ADD_VIDEO" i18n:catalogue="skin.{$skin}"/>"},
                {"contentType": "org.ametys.web.default.Content.article", "icon": "fas fa-file-alt", "zoneName": "aside", "label": "<i18n:text i18n:key="SKIN_FRONT_EDITION_TOOLBAR_PAGE_ACTIONS_ADD_ARTICLE_TO_SIDEAREA" i18n:catalogue="skin.{$skin}"/>"}
                ]
            </xsl:with-param>
            <xsl:with-param name="add-page-config">{                 
               "default-pagetype" : "template",                 
               "default-template" : "page",                 
               "default-pagecontent-type" : "contenttype",   
               "pagetype-card-template-filter": ["page", "page-2-columns"]       
               }</xsl:with-param> 
        </xsl:call-template>
		<div>
			<xsl:attribute name="class">
				<xsl:text>ametys-main-content-inner</xsl:text>
			</xsl:attribute>
			<div class="ametys-main-content-body">
                <xsl:call-template name="matomo-stats"/>
				<xsl:call-template name="bread-crumb"/>
			
				<div class="row">
					<div class="col-xl-8 col-print-8">
						<a name="content"></a>
						<zone name="default" level="1"/>
					</div>
					<div class="col-xl-4 col-print-4 sidebar">
                        <div class="row">
							<zone name="aside" level="2"/>
                        </div>
					</div>
				</div>
			</div>
		</div>
	</xsl:template>
    
    <xsl:template name="zone-item-class">
        <xsl:variable name="zone-name" select="../@name"/>
        
        <xsl:if test="position() mod 2 = 0"><xsl:text>even </xsl:text></xsl:if>                                
        <xsl:if test="position() = 1"><xsl:text>first </xsl:text></xsl:if>
        <xsl:if test="position() = last()"><xsl:text>last </xsl:text></xsl:if>
        <xsl:if test="$zone-name = 'aside'"><xsl:text>col-md-6 col-xl-12 col-print-12</xsl:text></xsl:if>
    </xsl:template>
	
	<xsl:template name="zone-item-before">
      <xsl:param name="position"/>
      <xsl:param name="count"/>
      <xsl:param name="zone-name"/>
      <xsl:param name="level"/>
      <xsl:param name="inherited"/>
      <xsl:param name="id"/>
      <xsl:param name="type"/>
      <xsl:param name="content-id"/>
      <xsl:param name="service"/>
      <xsl:param name="content-type"/>
      
      <xsl:if test="$type = 'CONTENT'">       
        <xsl:choose>
          <xsl:when test="$zone-name = 'aside'">
              <!-- Small version of toolbar -->
              <xsl:call-template name="ametys-front-edition-content-toolbar">
                <xsl:with-param name="content-id" select="$content-id"/>
                <xsl:with-param name="zone-name" select="$zone-name"/>
                <xsl:with-param name="zone-item-id" select="@id"/>
                <xsl:with-param name="edit-view-name">edition-fo</xsl:with-param>
                <xsl:with-param name="items">['edit', 'current-step', {type: 'menu', label: '', icon: 'fas fa-ellipsis-v', items: ['workflow-action-3', 'workflow-action-4', 'workflow-action-7', 'workflow-action-10', 'tag', 'move', 'remove']}]</xsl:with-param>
              </xsl:call-template>
          </xsl:when>
          <xsl:when test="$zone-name = 'default'">
              <!-- Default toolbar for default zone -->
              <xsl:call-template name="ametys-front-edition-content-toolbar">
                <xsl:with-param name="content-id" select="$content-id"/>
                <xsl:with-param name="zone-name" select="$zone-name"/>
                <xsl:with-param name="zone-item-id" select="@id"/>
                <xsl:with-param name="edit-view-name">edition-fo</xsl:with-param>
                <xsl:with-param name="items">['edit', 'current-step', {type: 'menu', label: '', icon: 'fas fa-ellipsis-v', items: ['workflow-action-3', 'workflow-action-4', 'workflow-action-7', 'workflow-action-10', 'tag', 'move', 'remove']}]</xsl:with-param>
              </xsl:call-template>
          </xsl:when>
        </xsl:choose> 
      </xsl:if>
    </xsl:template>
    
</xsl:stylesheet>