<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:exslt="http://exslt.org/common"
                xmlns:math="http://exslt.org/math" 
                extension-element-prefixes="ametys math exslt">
    
    <xsl:import href="plugin:web://pages/comments/helper/comments_3.3.xsl"/>
    <xsl:import href="skin://stylesheets/utils.xsl" />
    
    <xsl:variable name="comment-date-format" select="ametys:translate(concat('skin.', $skin, ':SKIN_COMMENTS_DATE_FORMAT'))"></xsl:variable>
    
    <xsl:template name="comments-rss">
        <a class="comments-rss" title="plugin.web:PLUGINS_WEB_RSS_COMMENTS_LABEL" i18n:attr="title" href="{$site-uri-prefix}/_plugins/web/comments/rss.xml?contentId={@id}&amp;siteName={$site}">
            <i18n:text i18n:key="SKIN_COMMENTS_RSS" i18n:catalogue="skin.{$skin}"/>
        </a>
    </xsl:template>
    
    <xsl:template name="comments-empty">
         <div class="comments-count"><i18n:text i18n:key="SKIN_COMMENTS_TITLE" i18n:catalogue="skin.{$skin}"/></div>              
    </xsl:template>
    
    <xsl:template name="comment">
        <xsl:param name="content-id" />
        <xsl:param name="level">0</xsl:param>
        
        <li id="{@id}">
            <xsl:attribute name="class"><xsl:call-template name="comment-class"/></xsl:attribute>
            
            <a name="{@id}-{$content-id}"/>
            
            <xsl:call-template name="comment-author-avatar">
                 <xsl:with-param name="content-id" select="$content-id" />
            </xsl:call-template>
            
            <div class="comment__inner">
                <xsl:call-template name="comment-author"/>
                
                <xsl:call-template name="comment-content"/>
                
                <xsl:call-template name="comment-footer">
                    <xsl:with-param name="content-id" select="$content-id" />
                    <xsl:with-param name="level" select="$level" />
                </xsl:call-template>
                
                <xsl:call-template name="comment-sub-comments">
                    <xsl:with-param name="content-id" select="$content-id" />
                    <xsl:with-param name="level" select="$level + 1" />
	            </xsl:call-template>
                
	            <!-- Add answer button only if it's the parent comment -->
	            <xsl:if test="$level = 0">
	                <xsl:call-template name="comment-answer-form">
	                  <xsl:with-param name="content-id" select="$content-id" />
	                </xsl:call-template>
	            </xsl:if>
            </div>
        </li>   
    </xsl:template>
    
    <xsl:template name="comment-author-avatar">
        <div class="comment-img">
            <img src="{author-img-url}" />
        </div>
    </xsl:template>
    
    <xsl:template name="comment-author">
        <div class="comment-author">
            <xsl:value-of select="@author-name" />
            <xsl:call-template name="comment-date"/>
        </div>
    </xsl:template>
    
    <xsl:template name="comment-date">
        <span class="comment-creation">
            <xsl:text> - </xsl:text>
            <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="{$comment-date-format}" value="{@creation-date}"/>
        </span>
    </xsl:template>
    
    <xsl:template name="comment-footer">
        <xsl:param name="content-id" />
        <xsl:param name="level" />
        
        <div class="comment-footer" >
            <div class="comment-footer__buttons">
	            <xsl:call-template name="comment-report">
	                <xsl:with-param name="content-id" select="$content-id" />
	            </xsl:call-template>
	            
	            <xsl:call-template name="comment-delete">
	                <xsl:with-param name="content-id" select="$content-id" />
	            </xsl:call-template>
	
	            <xsl:call-template name="comment-like">
	                <xsl:with-param name="content-id" select="$content-id" />
	            </xsl:call-template>
            </div>
            
            <xsl:if test="$level = 0">
	            <xsl:call-template name="comment-answer-form-button" />
            </xsl:if>
            
        </div>
    </xsl:template>
    
    <xsl:template name="comment-delete-form-field-submit">
         <xsl:param name="title" />
         <xsl:param name="tooltip" />
         <xsl:param name="class" />
         
         <a href="#" title="{$title}" i18n:attr="title" onclick="return delete_comment_form_submit_{$deleteUniqueId}('{@id}')"><i class="fas fa-trash-alt"></i></a>
    </xsl:template>
    
    <xsl:template name="comment-like-form-field-submit">
         <xsl:param name="title" />
         <xsl:param name="tooltip" />
         
         <button class="ametys-like-button" title="{$title}" i18n:attr="title" onclick="return like_comment_form_submit_{$likeUniqueId}('{@id}')"></button>
    </xsl:template>
    
    <xsl:template name="comment-report-form-field-submit">
         <xsl:param name="title" />
         <xsl:param name="tooltip" />
         
         <a href="#" title="{$title}" i18n:attr="title" onclick="return report_comment_form_submit_{$reportUniqueId}('{@id}')"><i class="fas fa-exclamation-triangle"></i></a>
    </xsl:template>
    
    <!-- 
        | Override of form fields 
        | Ignore url and hide email field
        | Name and email are hidden because ser is necessarely connected
        +-->
    <xsl:template name="comment-form-showhint"/>
    
    <xsl:template name="comment-form-field-name">
        <xsl:param name="comment-id" />
        
        <input type="hidden" name="name" id="{$comment-id}-{$commentUniqueId}-name"/>
    </xsl:template>
    
    <xsl:template name="comment-form-field-mail">
        <xsl:param name="comment-id" />
        
        <input type="hidden" name="email" id="{$comment-id}-{$commentUniqueId}-email"/>
    </xsl:template>
    
    <xsl:template name="comment-form-field-url">
        <xsl:param name="comment-id" />
        
        <input type="hidden" name="url" id="{$comment-id}-{$commentUniqueId}-url" value=""/>
    </xsl:template> 
    
    <xsl:template name="comment-form-field-hidemail">
        <xsl:param name="comment-id" />
        
        <input type="hidden" name="hide-email" id="{$comment-id}-{$commentUniqueId}-hide-email" value="value"/>
    </xsl:template> 
    
    <xsl:template name="comment-form-field-captcha">
        <!-- No captcha required on intranet -->
    </xsl:template>
    
    <xsl:template name="comment-form-field-content">
        <xsl:param name="comment-id" />
        
        <div class="comment-form-field-content">
            <div class="comment-form-field-content__img">
                <img src=""/>
            </div>
            <div class="comment-form-field-content__input">    
                <textarea placeholder="skin.{$skin}:SKIN_COMMENTS_CONTENT_PLACEHOLDER" i18n:attr="placeholder" name="text" id="{$comment-id}-{$commentUniqueId}-text"></textarea>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="comment-add-form">
        <xsl:param name="content-id" />
    
        <!-- Form is not hidden -->
        <xsl:call-template name="comment-form" >
          <xsl:with-param name="accessibility-title">plugin.cms:PLUGINS_CMS_CONTENT_COMMENTS_POST_DESC</xsl:with-param>
          <xsl:with-param name="comment-id">comment</xsl:with-param>
          <xsl:with-param name="content-id" select="$content-id" />
        </xsl:call-template>
        
        <script type="text/javascript">
            getAmetysUser(function(user) {
                if (user)
                {
                    var $form = $j('.comments-wrapper form');
                    $form.find("input[name='name']").val(user.fullname);
                    $form.find("input[name='email']").val(user.email);
                    $form.find('.comment-form-field-content__img img').attr('src', '<xsl:value-of select="$site-uri-prefix"/>/_plugins/user-directory/user/' + user.populationId + '/' + user.login + '/image_45?lang=<xsl:value-of select="$lang"/>');
                }
            });
            
            comment_form_switch_<xsl:value-of select="$commentUniqueId"/>('comment');
        </script>
    </xsl:template>
    
    <!-- Overriden to not focus textarea input except for answser (comment's form is always visible) -->
    <xsl:template name="comment-form-switch-form-javascript">
        var form = document.getElementById(commentId + '-<xsl:value-of select="$commentUniqueId"/>');
        if (form.style.display == 'none')
        {
            form.style.display = '';
            if (commentId != 'comment')
            {
                $("#" + form.id + " textarea[name=text]").focus();
            }
        }
        else
        {
            form.style.display = 'none';
        }
    </xsl:template>
    
    <xsl:template name="comment-form-field-submit">
         <xsl:param name="comment-id" />
         
         <a href="#" class="comment-form-submit-btn" title="plugin.cms:PLUGINS_CMS_CONTENT_COMMENTS_POST_AUTHOR_SUBMIT" i18n:attr="title" onclick="return comment_form_submit_{$commentUniqueId}('{$comment-id}')"><i class="fas fa-paper-plane"></i></a>
    </xsl:template>
</xsl:stylesheet>