;(function ($) {
  'use strict';

  var AmetysTools = window.AmetysTools || {};

  AmetysTools = (function () {

    function AmetysTools(element, options) {

      var $self = this;

      /**
       * Current element.
       *
       * @public
       */
      this.$element = $(element);

      /**
       * Current options set by the caller including defaults.
       *
       * @public
       */
      $self.options = $.extend(true, {}, AmetysTools.defaults, options);

      this.initialize();

    }

    return AmetysTools;

  }());

  AmetysTools.defaults = {
    qty: 6,
    appsListQty: {
      xs: 2,
      md: 2
    },
    containerSelector: null,
    listSelector: null,
    listItemSelector: null,
    listItemTooltipSelector: null,
    listItemTooltipInvokerSelector: null,
    listItemTooltipErrorSelector: null,
    listItemTooltipLoginErrorSelector: null,
    listLinkSelector: null,
    gridSelector: null,
    toggleSelector: null,
    toggleTextSelector: null,
    toolsNoItemsTextSelector: null,
    footerSelector: null,
    editModeCheckSelector: null,
    addNewItemFormContainerSelector: null,
    addNewItemFormSelector: null,
    addNewItemFormFields: {
      url: null,
      title: null,
      color: null,
      colorId: null,
      linkId: null,
      submit: null
    },
    extraContainerSelector: null,
    extraListSelector: null,
    extraGridSelector: null,
    extraScrollbarSelector: null,
    extraListItemSelector: null,
    toggleActiveClass: null,
    sidebarSelector: null,
    modalRemove: {
      id: null,
      closeInvoker: null,
      deleteInvoker: null
    },
    modalDeactivate: {
      id: null,
      closeInvoker: null,
      deactivateInvoker: null
    },
    mesOutilsGrid: null,
    mesOutilsExtraGrid: null,
    extraScrollbar: null,
    isExtraInitialized: false,
    invoker: null,
    isEditModeCheck: false,
    isOpened: false,
    currentItemInfo: null,

    onReorder: function() {}
  };

  /**
   * Initialization of the plugin.
   *
   * @protected
   */
  AmetysTools.prototype.initialize = function () {
    // vars
    var $self = this;

    // rewrite array
    $self.options.sidebarSelector = '[data-sidebar]';
    $self.options.toggleActiveClass = 'ametys-show-more_active';

    $self.options.containerSelector = '#' + $self.$element[0].id;

    $self.options.listSelector = $self.options.containerSelector + ' [data-list-wrap]';
    $self.options.gridSelector = $self.options.containerSelector + ' [data-list]';
    $self.options.listItemSelector = $self.options.gridSelector + ' [data-list-item]';
    $self.options.listItemTooltipSelector = $self.options.gridSelector + ' .link-info-tooltip';
    $self.options.listItemTooltipInvokerSelector = $self.options.gridSelector + ' .link-dynamic-info';
    $self.options.listItemTooltipErrorSelector = $self.options.gridSelector + ' .link-info-error-message';
    $self.options.listItemTooltipLoginErrorSelector = $self.options.gridSelector + ' .link-change-password-link';
    $self.options.listLinkSelector = $self.options.gridSelector + ' [data-list-link]';

    $self.options.toolsNoItemsTextSelector = $self.options.containerSelector + ' [data-no-items-text]';

    $self.options.footerSelector = $self.options.containerSelector + ' [data-footer]';
    $self.options.toggleSelector = $self.options.containerSelector + ' [data-toggle]';
    $self.options.toggleTextSelector = $self.options.containerSelector + ' [data-toggle-text]';
    $self.options.editModeCheckSelector = $self.options.containerSelector + ' [data-edit-mode-toggle]';

    $self.options.addNewItemFormContainerSelector = $self.options.containerSelector + ' [data-add-new-item-wrap]';
    $self.options.addNewItemFormSelector = $self.options.containerSelector + ' [data-add-new-item-form]';
    $self.options.addNewItemFormFields.url = $self.options.addNewItemFormSelector + ' [data-add-new-item-field-url]';
    $self.options.addNewItemFormFields.title = $self.options.addNewItemFormSelector + ' [data-add-new-item-field-title]';
    $self.options.addNewItemFormFields.color = $self.options.addNewItemFormSelector + ' [data-add-new-item-field-color]:checked';
    $self.options.addNewItemFormFields.linkId = $self.options.addNewItemFormSelector + " [name='linkId']";
    $self.options.addNewItemFormFields.submit = $self.options.addNewItemFormSelector + ' [data-add-new-item-field-submit]';

    $self.options.extraListSelector = $self.options.containerSelector + ' [data-extra-list-wrap]';
    $self.options.extraScrollbarSelector = $self.options.containerSelector + ' [data-extra-list-scroll]';
    $self.options.extraGridSelector = $self.options.containerSelector + ' [data-extra-list]';
    $self.options.extraListItemSelector = $self.options.extraGridSelector + ' [data-extra-list-item]';
    $self.options.extraListEmptyTextSelector = $self.options.containerSelector + ' [data-extra-list-empty-text]';

    $self.options.modalRemove.id = $self.options.containerSelector + ' [data-delete-modal]';
    $self.options.modalRemove.deleteInvoker = $self.options.modalRemove.id + ' [data-delete-modal-confirm]';
    $self.options.modalRemove.closeInvoker = $self.options.modalRemove.id + ' [data-delete-modal-close]';

    $self.options.modalDeactivate.id = $self.options.containerSelector + ' [data-deactivate-modal]';
    $self.options.modalDeactivate.deactivateInvoker = $self.options.modalDeactivate.id + ' [data-deactivate-modal-confirm]';
    $self.options.modalDeactivate.closeInvoker = $self.options.modalDeactivate.id + ' [data-deactivate-modal-close]';

    // vars
    var windowWidth = window.innerWidth,
      apps = document.querySelector($self.options.listSelector),
      rows = function () {
        if (windowWidth <= 768) {
          return $self.options.appsListQty.xs;
        } else {
          return $self.options.appsListQty.md;
        }
      },
      newMesOutilsEdit = this.mesOutilsEdit($self.options.containerSelector, $self.options.gridSelector, $self.options.listItemSelector, $self.options.qty, $self.options.appsListQty.xs, $self.options.appsListQty.md),
      newMesOutilsToggle = this.mesOutilsToggle($self.options.gridSelector, $self.options.listItemSelector, $self.options.qty, $self.options.appsListQty.xs, $self.options.appsListQty.md),
      formValues = {
        url: $($self.options.addNewItemFormFields.url).val(),
        title: $($self.options.addNewItemFormFields.title).val(),
        color: $($self.options.addNewItemFormFields.color).val(),
        colorId: $($self.options.addNewItemFormFields.color).attr("data-color-id"),
        linkId: $($self.options.addNewItemFormFields.linkId).val(),
        submit: $($self.options.addNewItemFormFields.submit)
      };

    if(!$($self.options.listItemSelector).length) {

      $($self.options.toolsNoItemsTextSelector).show();

    }

    if ($($self.options.listItemSelector).length < $self.options.qty) {

      $($self.options.footerSelector).hide();

    }

    // set min-height for the apps list container
    apps.style.maxHeight = $($self.options.listItemSelector).length ? $self.setMinHeight($self.options.listItemSelector, $($self.options.listItemSelector).length < $self.options.qty ? $($self.options.listItemSelector).length : $self.options.qty, rows()) + 'px' : 0;

    // initialization of apps list with Muuri plugin
    $self.options.mesOutilsGrid = new Muuri($self.options.gridSelector, {
      dragEnabled: true,
      dragHammerSettings: {
        touchAction: 'pan-y'
      },
      dragStartPredicate: function (item, hammerEvent) {
        if ($($self.options.editModeCheckSelector)) {
          return $($self.options.editModeCheckSelector).is(':checked') ? Muuri.ItemDrag.defaultStartPredicate(item, hammerEvent) : false;
        }
      }
    });

    $self.options.mesOutilsGrid.on('dragMove', function () {
      document.ontouchmove = function (e) {
        e.preventDefault();
      }
    });

    $self.options.mesOutilsGrid.on('dragEnd', function (el) {
      $self.options.onReorder(el);

      document.ontouchmove = function () {
        return true;
      };
    });

    $self.options.mesOutilsGrid.on('dragReleaseEnd', function (el) {
        $self.$element.trigger('elementMoved', [el.getElement()]);
    });
//    $self.options.mesOutilsGrid.on('add', function (el) {
//        $self.$element.trigger('elementActivated', [el[0].getElement()]);
//    });

    // edit mode
    $($self.options.editModeCheckSelector).on('change', function () {
      var $toggleEl = $($self.options.toggleSelector),
        defaultText = $toggleEl.data('default-text'),
        activeText = $toggleEl.data('active-text');

      apps.style.maxHeight = newMesOutilsEdit();

      if ($self.options.isEditModeCheck === true) {
          $($self.options.toggleTextSelector).text(activeText);
          $toggleEl.addClass($self.options.toggleActiveClass);
          $self.options.isOpened = true;
          
          $($self.options.listLinkSelector).each(function () {
    this.addEventListener('click', $self.preventClick);
          });
          
      } else {
          $($self.options.toggleTextSelector).text(defaultText);
          $toggleEl.removeClass($self.options.toggleActiveClass);
          $self.options.isOpened = false;
          
          $($self.options.listLinkSelector).each(function () {
              this.removeEventListener('click', $self.preventClick, false);
          });
          
      }

      if ($($self.options.addNewItemFormContainerSelector).length) {
        $($self.options.addNewItemFormContainerSelector).slideToggle(400);
      }

      if ($($self.options.listItemSelector).length > $self.options.qty) {

        $($self.options.footerSelector).slideToggle(400);

      }

      if ($($self.options.extraListSelector).length) {
        $($self.options.extraListSelector).slideToggle(400, function () {
          if (!$self.options.isExtraInitialized) {
            document.querySelector($self.options.extraGridSelector).style.width = $self.setWidth($self.options.extraListItemSelector) + 'px';

            // initialization list container with Perfect Scrollbar plugin
            $self.options.extraScrollbar = new PerfectScrollbar($self.options.extraScrollbarSelector, {
              wheelSpeed: 2,
              wheelPropagation: true,
              minScrollbarLength: 20,
              suppressScrollX: false
            });

            $self.options.mesOutilsExtraGrid = new Muuri($self.options.extraGridSelector, {
              // dragEnabled: true,
              // dragSortInterval: 0,
              // dragSort: function (item) {
              //   return [$self.options.mesOutilsGrid];
              // }
            });

            $self.options.isExtraInitialized = true;
          }
        });
      }
    });

    // delete item from main list
    var $confirmationDeleteModal = new Custombox.modal({
      content: {
        effect: 'fadein',
        target: $self.options.modalRemove.id
      }
    });

    $($self.options.gridSelector).on('click', '.ametys-tools-list__item[data-app-type="custom"] .ametys-tools-list__action', function (e) {
      AmetysTools.defaults.invoker = e.target;

      if (!('Custombox' in window)) return;

      $confirmationDeleteModal.open();
    });

    $($self.options.modalRemove.closeInvoker).on('click', function () {
      Custombox.modal.close();
    });

    $($self.options.modalRemove.deleteInvoker).on('click', function () {
      var $target = $self.closestElement(AmetysTools.defaults.invoker, '.muuri-item');

      $self.options.currentItemInfo = $self.options.mesOutilsGrid.getItems($target)[0];

      $self.options.mesOutilsGrid.hide($target, {
        onFinish: function (items) {
          var item = items[0],
            itemElem = document.createElement('li');

          itemElem.classList.add('ametys-tools-list__item');

          itemElem.innerHTML = item._element.innerHTML;

          apps.style.maxHeight = $self.setMaxHeight($self.options.gridSelector) + 'px';

          $self.options.mesOutilsGrid.remove(item, {
            removeElements: true
          });

          if($($self.options.listItemSelector).length) {

            $($self.options.toolsNoItemsTextSelector).hide();

          } else {

            $($self.options.toolsNoItemsTextSelector).show();

          }

          if ($self.options.isEditModeCheck === false) {

            if ($($self.options.listItemSelector).length > $self.options.qty) {

              $($self.options.footerSelector).show();

            }

          }

          window.dispatchEvent(new Event('resize'));
          $self.$element.trigger('elementDeleted', [$target]);
          
          Custombox.modal.close();
        }
      });
    });

    // deactivate item and move it to extra items list
    var $confirmationDeactivateModal = new Custombox.modal({
      content: {
        effect: 'fadein',
        target: $self.options.modalDeactivate.id
      }
    });

    $($self.options.gridSelector).on('click', '.ametys-tools-list__item:not([data-app-type="custom"]) .ametys-tools-list__action', function (e) {
      AmetysTools.defaults.invoker = e.target;

      if (!('Custombox' in window)) return;

      $confirmationDeactivateModal.open();
    });

    $($self.options.modalDeactivate.closeInvoker).on('click', function () {
      Custombox.modal.close();
    });

    $($self.options.modalDeactivate.deactivateInvoker).on('click', function () {
      var $target = $self.closestElement(AmetysTools.defaults.invoker, '.muuri-item');

      $self.options.currentItemInfo = $self.options.mesOutilsGrid.getItems($target)[0];

      $self.options.mesOutilsGrid.hide($target, {
        onFinish: function (items) {
          var item = items[0],
            itemElem = document.createElement('li');

          itemElem.classList.add('ametys-tools-list__item');
          itemElem.dataset.extraListItem = '';

          itemElem.innerHTML = item._element.innerHTML;

          apps.style.maxHeight = $self.setMaxHeight($self.options.gridSelector) + 'px';

          $self.options.mesOutilsGrid.remove(item, {
            removeElements: true
          });

          if($($self.options.listItemSelector).length) {

            $($self.options.toolsNoItemsTextSelector).hide();

          } else {

            $($self.options.toolsNoItemsTextSelector).show();

          }

          if ($self.options.isEditModeCheck === false) {

            if ($($self.options.listItemSelector).length > $self.options.qty) {

              $($self.options.footerSelector).show();

            }

          }

          Custombox.modal.close();

          if ($($self.options.extraListSelector).length && item._element.dataset.appType !== 'custom') {
            $self.options.mesOutilsExtraGrid.add(itemElem, {
              index: 0
            });

            document.querySelector($self.options.extraGridSelector).style.width = $self.setWidth($self.options.extraListItemSelector) + 'px';

            $self.options.mesOutilsExtraGrid.layout();
            window.dispatchEvent(new Event('resize'));

            $self.options.extraScrollbar.update();
          }
          
          $self.$element.trigger('elementDeactivated', [$target]);
        }
      });
    });

    // add item to main list and remove form extra items section
    $($self.options.extraGridSelector).on('click', '.ametys-tools-list__action', function (e) {
      e.preventDefault();

      var $target = $self.closestElement(e.target, '.muuri-item');

      $self.options.currentItemInfo = $self.options.mesOutilsExtraGrid.getItems($target)[0];

      $self.options.mesOutilsExtraGrid.hide($target, {
        onFinish: function (items) {
          var item = items[0],
            itemElem = document.createElement('li');

          itemElem.classList.add('ametys-tools-list__item');
          itemElem.dataset.listItem = '';

          itemElem.innerHTML = item._element.innerHTML;

          $self.options.mesOutilsExtraGrid.remove(item, {
            removeElements: true
          });

          itemElem.childNodes[0].addEventListener('click', $self.preventClick);

          $self.options.mesOutilsGrid.add(itemElem);

          apps.style.maxHeight = $self.setMaxHeight($self.options.gridSelector) + 'px';

          document.querySelector($self.options.extraGridSelector).style.width = $self.setWidth($self.options.extraListItemSelector) + 'px';

          $self.options.mesOutilsExtraGrid.layout();

          $self.options.extraScrollbar.update();
          
          $self.$element.trigger('elementActivated', [$target]);
        }
      });
    });

    // add new item to main list according the fields values
    if ($($self.options.addNewItemFormSelector).length) {
      $($self.options.addNewItemFormSelector).find('input').on('keyup change', function () {
        formValues = {
          url: $($self.options.addNewItemFormFields.url).val(),
          title: $($self.options.addNewItemFormFields.title).val(),
          color: $($self.options.addNewItemFormFields.color).val(),
          colorId: $($self.options.addNewItemFormFields.color).attr("data-color-id"),
          linkId: $($self.options.addNewItemFormFields.linkId).val(),
          submit: $($self.options.addNewItemFormFields.submit)
        };

        if (formValues.url !== '' && formValues.title !== '') {
          $(formValues.submit).prop('disabled', false);
        } else {
          $(formValues.submit).prop('disabled', true);
        }
      });
    }

    $($self.options.addNewItemFormSelector).on('submit', function (e) {
      e.preventDefault();

      if (formValues.url !== '' && formValues.title !== '') {
        var itemElem = document.createElement('div'),
          template = '<li class="ametys-tools-list__item" data-list-item data-app-type="custom">\n' +
            '<a data-serverid="' + formValues.linkId + '" class="ametys-tools-list__link" target="_blank" data-list-link href="' + formValues.url + '">\n' +
                '<span class="ametys-tools-list__icon" data-color-id="' + formValues.colorId + '" style="background-color: ' + formValues.color + ';">\n' +
                    '<span class="ametys-tools-list__action"></span>\n' +
                    '<span class="ametys-tools-list__icon-content">' + formValues.title.slice(0, 2) + '</span>\n' +
                '</span>\n' +
                '<span class="ametys-tools-list__title">' + formValues.title + '</span>\n' +
                '<span class="ametys-tools-list__action"></span>\n' +
            '</a>\n' +
            '</li>';

        itemElem.innerHTML = template;

        itemElem.firstChild.childNodes[1].addEventListener('click', $self.preventClick);

        $self.options.mesOutilsGrid.add(itemElem.firstChild);

        $self.options.currentItemInfo = $self.options.mesOutilsGrid.getItems(itemElem.firstChild)[$self.options.mesOutilsGrid.getItems(itemElem.firstChild).length - 1];

        $($self.options.addNewItemFormFields.url).val('');
        $($self.options.addNewItemFormFields.title).val('');
        $($self.options.addNewItemFormFields.linkId).val('');

        $(formValues.submit).prop('disabled', true);

        apps.style.maxHeight = $self.setMaxHeight($self.options.gridSelector) + 'px';
      }

      if($($self.options.listItemSelector).length) {

        $($self.options.toolsNoItemsTextSelector).hide();

      }

      if ($self.options.isEditModeCheck === false) {

        if ($($self.options.listItemSelector).length > $self.options.qty) {

          $($self.options.footerSelector).show();

        }

      }
      $self.$element.trigger('elementActivated', [null]);
    });

    // toggle main list container
    $($self.options.toggleSelector).on('click', function () {
      var $this = $(this),
        defaultText = $this.data('default-text'),
        activeText = $this.data('active-text');

      if ($self.options.isEditModeCheck === false) {
        $this.toggleClass($self.options.toggleActiveClass);

        if ($this.hasClass($self.options.toggleActiveClass)) {
          $($self.options.toggleTextSelector).text(activeText);
        } else {
          $($self.options.toggleTextSelector).text(defaultText);
        }

        apps.style.maxHeight = newMesOutilsToggle();
      }
    });

    $($self.options.sidebarSelector).on('transitionend webkitTransitionEnd oTransitionEnd otransitionend MSTransitionEnd', function () {

      $self.options.mesOutilsGrid.refreshItems().layout();

      if ($($self.options.extraContainerSelector).length && $self.options.isExtraInitialized) {
        $self.options.mesOutilsExtraGrid.refreshItems().layout();
      }

    });

    // tooltips
    $($self.options.listItemTooltipInvokerSelector).on('mouseenter touchstart', function () {
      var $this = $(this),
        thisOffsetTop = $this.offset().top,
        thisOffsetLeft = $this.offset().left,

        $tooltip = $this.find($($self.options.listItemTooltipSelector)),
        $tooltipParent = $this.parents($self.options.listLinkSelector),
        $tooltipError = $this.parents($self.options.listItemSelector).find($($self.options.listItemTooltipErrorSelector)),
        $tooltipErrorInnerHTML = $tooltipError.html(),
        $tooltipLoginError = $this.parents($self.options.listItemSelector).find($($self.options.listItemTooltipLoginErrorSelector)),
        $tooltipLoginErrorInnerHTML = $tooltipLoginError.html(),
        tooltipInnerHTML = $tooltip.html();


      if ($('#tools-tooltip').length) {

        $('#tools-tooltip').removeClass('error near-the-left-side');
        $('#tools-tooltip .ametys-tools-tooltip-content').html('');

      }

      if (!$('#tools-tooltip').length) {

        $('<div id="tools-tooltip" class="ametys-tools-tooltip"><div class="ametys-tools-tooltip-content"></div></div>').appendTo('body');

      }

      $('#tools-tooltip .ametys-tools-tooltip-content').html(function () {
        if ($tooltipParent.hasClass('error') && $tooltipError.length) {

          return $tooltipErrorInnerHTML;

        } else if ($tooltipParent.hasClass('error') && $tooltipLoginError.length) {

          return $tooltipLoginErrorInnerHTML;

        } else {

          return tooltipInnerHTML;

        }
      });

      $('#tools-tooltip').css({
        top: thisOffsetTop + 38,
        left: thisOffsetLeft > $($self.options.gridSelector).offset().left + 100 ? thisOffsetLeft - 155 : thisOffsetLeft - 76
      });

      if(thisOffsetLeft < $($self.options.gridSelector).offset().left + 100) {

        $('#tools-tooltip').addClass('near-the-left-side');

      }

      if ($tooltipParent.hasClass('error')) {

        $('#tools-tooltip').addClass('error');

      }

      $('#tools-tooltip').show();

      if (!$self.isTouchDevices()) {

        $('#tools-tooltip').on('mouseenter', function () {

          $('#tools-tooltip').addClass('visible')

        });

        $('#tools-tooltip').on('mouseleave', function () {

          $('#tools-tooltip').hide();

          $('#tools-tooltip').removeClass('visible')

        });

      }

    });

    if (!$self.isTouchDevices()) {

      $($self.options.listLinkSelector).on('mouseleave', function () {

        setTimeout(function () {

          if ($('#tools-tooltip').length && !$('#tools-tooltip').hasClass('visible')) {

            $('#tools-tooltip').hide();

            $('#tools-tooltip').removeClass('visible');

          }

        });

      });

    } else {

      $(document).on('touchstart', function() {

        $('#tools-tooltip').hide();

        $('#tools-tooltip').removeClass('visible');

      });

    }

    return this;

  };

  AmetysTools.prototype.closestElement = function (element, selector) {
    if (window.Element && !Element.prototype.closest) {
      var isMatch = elementMatches(element, selector);

      while (!isMatch && element && element !== document) {
        element = element.parentNode;
        isMatch = element && element !== document && elementMatches(element, selector);
      }

      return element && element !== document ? element : null;
    } else {
      return element.closest(selector);
    }
  };

  AmetysTools.prototype.setWidth = function (el) {
    var $items = document.querySelectorAll(el),
      itemsLength = $items.length,
      i = 0,
      resultWidth = 0;

    while (i < itemsLength) {
      resultWidth += $items[i].offsetWidth;

      i++;
    }

    return resultWidth;
  };

  AmetysTools.prototype.setMinHeight = function (singleItem, qty, rows) {
    var $items = document.querySelectorAll(singleItem),
      min = 0,
      itemsInRow = qty / rows,
      maxItemHeight = 0,
      countRows = 0,
      countElements = 0;

    if (countRows !== 0) {

      while (countRows < rows) {

        while (countElements < itemsInRow) {
          maxItemHeight += $items[countElements].offsetHeight > maxItemHeight ? $items[countElements].offsetHeight : 0;

          countElements++;
        }

        min += maxItemHeight;

        countRows++;

        itemsInRow += itemsInRow;

        maxItemHeight = 0;

      }

    } else {

        while (countElements < itemsInRow) {
          maxItemHeight += $items[countElements].offsetHeight > maxItemHeight ? $items[countElements].offsetHeight : 0;

          countElements++;
        }

        min += maxItemHeight * rows;

    }

    return min;
  };

  AmetysTools.prototype.setMaxHeight = function (target) {
    var $target = document.querySelector(target);

    return $target.offsetHeight;
  };

  AmetysTools.prototype.mesOutilsEdit = function (container, grid, singleItem, qty, xs, md) {
    var $self = this;

    return function () {
      var windowWidth = window.innerWidth,
        rows = function () {
          if (windowWidth <= 768) {
            return xs;
          } else {
            return md;
          }
        };

      if (!$self.options.isEditModeCheck) {
        $self.options.isEditModeCheck = true;

        document.querySelector(container).classList.add('ametys-edit-mode-on');

        return $self.setMaxHeight(grid) + 'px';
      } else {
        $self.options.isEditModeCheck = false;

        document.querySelector(container).classList.remove('ametys-edit-mode-on');

        return $self.setMinHeight(singleItem, $($self.options.listItemSelector).length < $self.options.qty ? $($self.options.listItemSelector).length : qty, rows()) + 'px';
      }
    }
  };

  AmetysTools.prototype.mesOutilsToggle = function (grid, item, qty, xs, md) {
    var $self = this;

    return function () {
      var windowWidth = window.innerWidth,
        rows = function () {
          if (windowWidth <= 768) {
            return xs;
          } else {
            return md;
          }
        };

      if (!$self.options.isOpened) {
        $self.options.isOpened = true;

        return $self.setMaxHeight(grid) + 'px';
      } else {
        $self.options.isOpened = false;

        return $self.setMinHeight(item, qty, rows()) + 'px';
      }
    }

  };

  AmetysTools.prototype.preventClick = function (e) {

    return e.preventDefault();

  };

  AmetysTools.prototype.isTouchDevices = function () {
    return (('ontouchstart' in window) || (navigator.MaxTouchPoints > 0) || (navigator.msMaxTouchPoints > 0));
  };

  AmetysTools.prototype.itemInfo = function () {
    var $self = this;

    return $self.options.currentItemInfo;
  };

  AmetysTools.prototype.update = function () {
    var $self = this,
      windowWidth = window.innerWidth,
      rows = function () {
        if (windowWidth <= 768) {
          return $self.options.appsListQty.xs;
        } else {
          return $self.options.appsListQty.md;
        }
      };

    if (!$($self.options.editModeCheckSelector).is(':checked')) {
      if (windowWidth !== window.innerWidth) {
        windowWidth = window.innerWidth;

        document.querySelector($self.options.listSelector).style.maxHeight = $self.setMinHeight($self.options.listItemSelector, $self.options.qty, rows()) + 'px';
      }
    } else {
      document.querySelector($self.options.listSelector).style.maxHeight = $self.setMaxHeight($self.options.gridSelector) + 'px';
    }

  };

  $.fn.HSAmetysTools = function () {
    var _ = this,
      opt = arguments[0],
      args = Array.prototype.slice.call(arguments, 1),
      l = _.length,
      i,
      ret;
    for (i = 0; i < l; i++) {
      if (typeof opt == 'object' || typeof opt == 'undefined')
        _[i].AmetysTools = new AmetysTools(_[i], opt);
      else
        ret = _[i].AmetysTools[opt].apply(_[i].AmetysTools, args);
      if (typeof ret != 'undefined') return ret;
    }
    return _;
  };

})(jQuery);