<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
		xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:filenameutils="org.apache.commons.io.FilenameUtils"
        extension-element-prefixes="resolver ametys filenameutils">
	
	<xsl:import href="plugin:server-directory://pages/services/server-directory/files_small_3.3.xsl"/>
	<xsl:import href="view://services/web/pages/services/resources.xsl"/>   
	
    <!-- Used by common -->         
    <xsl:template name="common-service-head-css">    
        <link type="text/css" rel="stylesheet" href="{ametys:skinURL('zones/index-resources/scss/main.css')}" media="screen, print, handheld"/>
        <link type="text/css" rel="stylesheet" href="{ametys:skinURL('zones/index-resources/scss/print.css')}" media="screen, print, handheld"/>
    </xsl:template>
    
    <xsl:template name="common-service-head-js">
        <script type="text/javascript" src="{ametys:pluginResourceURL('web', 'js/jquery.treeview.min.js')}"><xsl:comment>empty</xsl:comment></script>
        
        <script type="text/javascript">
            $j(document).ready(function(){
                $j("#resources-<xsl:value-of select="$id"/>").treeview({ collapsed: true });
            });
        </script>                  
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-title"/>
    
    <xsl:template name="attachment-list">
	    	<div id="resources-{$id}">
	    		<xsl:if test="$template ='index'"><xsl:attribute name="class">card mb-4 <xsl:value-of select="$override-card-styles"/></xsl:attribute></xsl:if>
	    		<xsl:attribute name="data-settings">
			    	<xsl:text>{
						 "listQty": {
						   "xs": 4,
							 "lg": 2
						 }
					 }</xsl:text>
				</xsl:attribute>
				<header class="card-header">
					<h1 class="card-title">
			        	<xsl:call-template name="card-header-icon"/>
			        	<xsl:choose>
				            <xsl:when test="$header != ''">
				              	<xsl:value-of select="$header"/>
				            </xsl:when>
				            <xsl:otherwise>
				            	<i18n:text i18n:key="SKIN_DOC_SERVICES" i18n:catalogue="skin.{$skin}"/>
				            </xsl:otherwise>
				        </xsl:choose>
			        </h1>
				</header>
				
				<div class="card-body pt-0">
					
					<div class="ametys-resources-wrap" data-list-wrap="">
						
				        <ul class="ametys-resources" data-list="">
				        	<xsl:if test="$template != 'index'">
				            <xsl:apply-templates select="Node[@type = 'collection']">
			                    <xsl:sort select="@name"/>
			                </xsl:apply-templates>
							</xsl:if>
			                
			            <xsl:apply-templates select="Node[@type = 'resource']">
			                    <xsl:sort select="@name"/>
			                </xsl:apply-templates>
				
				        </ul>
				    </div>
											
				</div>
				
				<xsl:if test="$template ='index'">
					<footer class="card-footer text-center">
						<span class="ametys-show-more ametys-show-more--inverse"
						      data-toggle="" 
						      data-default-text="skin.{$skin}:SKIN_DISPLAY_MORE" 
						      data-active-text="skin.{$skin}:SKIN_DISPLAY_LESS" i18n:attr="data-default-text data-active-text">
							<span class="ametys-show-more__text"
							      data-toggle-text=""><i18n:text i18n:key="SKIN_DISPLAY_MORE" i18n:catalogue="skin.{$skin}"/></span>
							<span class="ametys-show-more__icon material-icons expand_more"></span>
						</span>
					</footer>
				</xsl:if>
			</div>
		
		  <xsl:if test="$template ='index'">
			<script>
				setTimeout(function () {
					$j('#resources-<xsl:value-of select="$id"/>').HSExpandableContent($j('#resources-<xsl:value-of select="$id"/>').data('settings'));
				});
				
				$j(window).on('resize', function () {
					$j('#resources-<xsl:value-of select="$id"/>').HSExpandableContent('update');
				});
			</script>
		  </xsl:if>
    </xsl:template>
    
    <xsl:template name="card-header-icon">
    	<span class="card-header__icon material-icons filter-none"></span>
    </xsl:template>
    
    <xsl:template match="Node[@type = 'collection' and parent::*]">
        <li class="ametys-resources__item" data-list-item="">
        	<div class="ametys-resources__link">
        	  <div class="ametys-resources__icon ametys-square-icon">
            	<xsl:call-template name="FolderIcon"/>
              </div>
              <h2 class="ametys-resources__title"><xsl:value-of select="@name"/></h2>
            </div>
            <xsl:if test="$template != 'index'">
	            <xsl:if test="Node">
                <ul class="ametys-resources">
	                    <xsl:apply-templates select="Node[@type = 'collection']">
                        <xsl:sort select="@name"/>
                    </xsl:apply-templates>
                    
	                    <xsl:apply-templates select="Node[@type = 'resource']">
                        <xsl:sort select="@name"/>
                    </xsl:apply-templates>                
                </ul>
            </xsl:if>
	      </xsl:if>
            
        </li>
    </xsl:template>

    <xsl:template match="Node[@type = 'resource']">
        <li class="ametys-resources__item" data-list-item="">
            <a href="{resolver:resolve('explorer', @id, true())}" title="{@name}" class="ametys-resources__link">
	            <div class="ametys-resources__icon ametys-square-icon">
					<xsl:call-template name="Icons"/>
				</div>
                <h2 class="ametys-resources__title">
                	<xsl:value-of select="substring-before(@name, '.')"/>
<!--                 	<span class="g-font-size-12 d-block text-center"><xsl:call-template name="format-size"><xsl:with-param name="size" select="@size"/></xsl:call-template></span> -->
                </h2>
            </a>
<!--             <xsl:call-template name="DublinCore"/>          -->
        </li>
    </xsl:template>
		
</xsl:stylesheet>		
