<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2024 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:filenameutils="org.apache.commons.io.FilenameUtils"
        extension-element-prefixes="resolver ametys filenameutils">
        
    <xsl:variable name="common-service-css-class-name">attachments photo-gallery</xsl:variable>
    
    <xsl:variable name="imgSizeWidth">
        <xsl:choose>
            <xsl:when test="ametys:serviceViewParameter('imgSizeWidth') != ''"><xsl:value-of select="ametys:serviceViewParameter('imgSizeWidth')"/></xsl:when>
            <xsl:otherwise>325</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    
    <xsl:variable name="imgSizeHeight">
        <xsl:choose>
            <xsl:when test="ametys:serviceViewParameter('imgSizeHeight') != ''"><xsl:value-of select="ametys:serviceViewParameter('imgSizeHeight')"/></xsl:when>
            <xsl:otherwise>200</xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    
    <xsl:template name="common-service-head-css">    
        <link type="text/css" rel="stylesheet" href="{ametys:skinURL('zones/photo-gallery/scss/main.css')}" media="screen, print, handheld"/>
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('templates/common/scss/richtext.css')}" media="screen, print, handheld"/>
        <link rel="stylesheet" media="screen" href="{ametys:skinURL('templates/common/plugins/simple-lightbox/css/simple-lightbox.min.css')}" type="text/css" />
    </xsl:template>  
    
    <xsl:template name="common-content-head-js">
        <script type="text/javascript" src="{ametys:skinURL('templates/common/plugins/simple-lightbox/js/simple-lightbox.jquery.min.js')}"/>
        <script type="text/javascript">
            $j(document).ready(function () {
                $j('#gallery-photo-<xsl:value-of select="$uniqueId"/> .ametys-gallery-photo__item a').simpleLightbox();
            });
        </script>
    </xsl:template>
    
    <xsl:template name="photo-gallery-item">
        <xsl:param name="imgType"/>
        <xsl:param name="imgUri"/>
        <xsl:param name="filename"/>
        
        <li class="ametys-gallery-photo__item">
            <a href="{resolver:resolve($imgType, $imgUri)}" class="lightbox-gallery-{$uniqueId}" data-fancybox="lightbox-gallery-{$uniqueId}" rel="gallery" title="{$filename}" data-speed="350" data-caption="{$filename}">
                  <xsl:if test="$rendering-context = 'back'">
                      <xsl:attribute name="internal">internal</xsl:attribute>
                  </xsl:if>
                  <img src="{resolver:resolveCroppedImage($imgType, $imgUri, $imgSizeHeight, $imgSizeWidth)}" alt="" data-caption="{$filename}" />
                  <xsl:call-template name="photo-gallery-item-icon"/>
             </a>
         </li>  
   </xsl:template>
   
   <xsl:template name="photo-gallery-item-icon">
        <span class="ametys-gallery-photo__item_icon">
            <i class="hs-icon hs-icon-magnifier" aria-hidden="true"></i>
        </span>
   </xsl:template>
         

</xsl:stylesheet> 
    
     