<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        exclude-result-prefixes="ametys">
    
    <xsl:import href="common/home-card-search.xsl"/>
    
    <xsl:variable name="common-service-css-class-name">kiosk <xsl:value-of select="$template"/></xsl:variable>
    
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-head-css">
	    <link rel="stylesheet" href="{ametys:skinURL('zones/index-kiosk/scss/main.css')}" />
    </xsl:template> 
    
    <xsl:template name="header-default">
        <i18n:text i18n:key="SKIN_WEBTV" i18n:catalogue="skin.{$skin}"/>
    </xsl:template>
    
    <xsl:template name="card-header-icon">
        <i class="card-header__icon icofont-read-book"></i>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-content">
        <xsl:choose>
            <xsl:when test="$template = 'index'">
                <div class="card mb-4 {$override-card-styles}">
                    <xsl:call-template name="header"/>
                    
                    <xsl:call-template name="search-results"/>
                </div>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="search-results"/>
            </xsl:otherwise>
        </xsl:choose>
        
        <script type="text/javascript">
            $j.HSCore.components.HSCarousel.init("#kiosk-<xsl:value-of select="$uniqueId" />");
    
            $j("#sidebar").on("transitionend webkitTransitionEnd oTransRsearchitionEnd otransitionend MSTransitionEnd",
            function () {
                $j("#kiosk-<xsl:value-of select="$uniqueId" />").slick("setPosition");
            });
    
            $j.HSCore.components.HSPopup.init(".ametys-kiosk__link");
        </script>
    </xsl:template>
    
    <xsl:template name="hits">
		<ul data-ametys-search-role="hits" id="kiosk-{$uniqueId}" class="ametys-kiosk"
			data-slides-show="4" data-slides-scroll="1" data-infinite="true"
			data-responsive='[{
                "breakpoint": 992,
                "settings": {
                  "slidesToShow": 3
                }
              }, {
                "breakpoint": 768,
                "settings": {
                  "slidesToShow": 2
                }
              }]'>
             <xsl:for-each select="/search/hits/hit">
              	<xsl:call-template name="hit"/>
            </xsl:for-each>
         </ul>
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.ContentSaxer']" mode="class-attribute">
        <xsl:text/>ametys-kiosk__item<xsl:text> </xsl:text>
    </xsl:template>   
    
    
</xsl:stylesheet>