<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
							xmlns:xalan="http://xml.apache.org/xalan"
							xmlns:math="java.lang.Math"
							xmlns:exsl="http://exslt.org/common"
							xmlns:exslt="http://exslt.org/common"
							xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
							xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            xmlns:date="http://exslt.org/dates-and-times"
                            xmlns:stringutils="org.apache.commons.lang.StringUtils"
                            xmlns:text="http://ametys.org/text/3.0"
							exclude-result-prefixes="sitemap resolver ametys date stringutils text exslt">
	
	<xsl:import href="skin://services/link-directory/pages/services/directory/utils/inputdata_utils.xsl"/>
	<xsl:import href="skin://stylesheets/utils.xsl" />
	<xsl:import href="skin://stylesheets/config/config.xsl" />
	<xsl:import href="skin://stylesheets/head.xsl" />
	<xsl:import href="skin://stylesheets/menus.xsl" />
    <xsl:import href="skin://stylesheets/header.xsl" />
    <xsl:import href="skin://stylesheets/footer.xsl" />
	<xsl:import href="skin://stylesheets/search.xsl" />
	<xsl:import href="skin://stylesheets/others.xsl" />
	<xsl:import href="skin://stylesheets/weather.xsl" />
	
	<xsl:variable name="uniqueId" select="substring-after(math:random(), '.')"/>
	<xsl:variable name="user" select="ametys:user()"/>
    <xsl:variable name="rawCurrentUser">
        <xsl:call-template name="user-info">
            <xsl:with-param name="imgWidth">80</xsl:with-param>
        </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="currentUser" select="exslt:node-set($rawCurrentUser)"/>
    
    <xsl:variable name="notificationCenterEnabled" select="ametys:siteParameter('notification-center-enabled')"/>
    <xsl:variable name="pageFollowEnabled" select="ametys:siteParameter('page-follow-enabled')"/>
	
	<!-- + 
	     | BASE
	     + -->
	<xsl:template name="template">
		<html class="accessible-on">
			<xsl:call-template name="head"/>
			<body>
				<xsl:call-template name="accessibility-links"/>
				
				<xsl:call-template name="blocking-alerts"/>
				
				<xsl:call-template name="header"/>
				
				<main class="position-relative">
					<xsl:call-template name="main-background-image"/>
			
					<aside id="sidebar" class="js-custom-scroll ametys-sidebar ametys-sidebar_left"
					       data-sidebar="">
					       
					    <xsl:call-template name="header-logo"/>
					       
						<xsl:call-template name="weather"/>
						
						<xsl:call-template name="lateral-menu"/>
						
						<xsl:call-template name="menu"/>
					
					</aside>
					
					<!-- Note This is an empty zone named 'default' -->
					<div class="ametys-main ametys-main_with-sidebar-left">
						<div class="ametys-main-content">
							
							<xsl:call-template name="main-zone"/>
						</div>
					</div>
					
					<xsl:call-template name="footer"/>
                    
                    <xsl:call-template name="scroll-top"/>
					
					<div class="ametys-overlay" style="display: none;"
					     data-target-hide="body"></div>
				
				</main>
				
			</body>
		</html>
	</xsl:template>
    
    <!-- Use this template to personnalize the background image of a page (based on a skin's resource, a explorer resource, a view parameter, ...)-->
    <xsl:template name="main-background-image">
        <!-- <xsl:attribute name="style">background-image: url('<xsl:value-of select="ametys:skinURL('img/bg-1.jpg')"/>')</xsl:attribute> -->
    </xsl:template>
	
	<xsl:template name="header-logo">
	    <h1 class="ametys-sidebar-logo-wrap top">
							
			<a id="sidebarLogo" class="ametys-sidebar-logo" href="{$site-uri-prefix}/{$lang}/index.html">
				<xsl:call-template name="header-logo-img"/>
			</a>
		</h1>
    </xsl:template>
    
    <xsl:template name="header-logo-img">
		<img class="ametys-sidebar-logo__img" src="{ametys:skinURL('templates/common/img/logo-white.png')}" width="140px" alt="Intra" />
	</xsl:template>
	
	<xsl:template name="blocking-alerts">
        <xsl:if test="/cms/inputData/Model/blocking-alerts/content">
            <div class="bandeau-warning ametys__warning-message">
                <xsl:for-each select="/cms/inputData/Model/blocking-alerts/content">
                    <div class="container" data-flashinfo-id="{@id}@{@lastModifiedAt}">
                        <xsl:copy-of select="html/body/node()"/>
                    </div>
                </xsl:for-each>
                <div class="bandeau-warning-buttons">
                    <a href="#" class="btn btn-grey btn-sm ametys__warning-message_mark-as-read" onclick="AmetysFlashInfo.markAsRead()"><i18n:text i18n:key="SKIN_ALERTS_BANNER_MARK_AS_READ" i18n:catalogue="skin.{$skin}" /></a>
                    <i class="material-icons ametys__warning-message_close" onclick="AmetysFlashInfo.showLater()">clear</i>
                </div> 
            </div>
            <script type="text/javascript">
                function hideBanner() {
                    $j('.bandeau-warning').removeClass('show');
                }
                
                function showBanner() {
                    $j('.bandeau-warning').addClass('show');
                }
                
                $j().ready(function() {
                    // Init and show flash info popup
                    AmetysFlashInfo.initialize(".bandeau-warning", showBanner, hideBanner, "<xsl:value-of select="ametys:siteUriPrefix()"/>");
                });
            </script>
        </xsl:if>
    </xsl:template>
	
	
	
	<xsl:template name="lateral-menu">
		<ul class="ametys-sidebar-main-nav">			
			<xsl:apply-templates select="/cms/inputData/linkDirectory[@id='lateralMenu']/links/link" mode="lateral-menu">
              <xsl:with-param name="uniqueId" select="$uniqueId"/>
              <xsl:with-param name="location" select="'sidebar'"/>
           </xsl:apply-templates>
		</ul>
	</xsl:template>
	
	<!-- Pirobox replace by fancybox -->
    <xsl:template name="head-js-pirobox"/>
    <xsl:template name="head-css-pirobox"/>
    
    <xsl:template name="head-css-fancybox">
        <link rel="stylesheet" href="{ametys:skinURL('templates/common/plugins/fancybox/jquery.fancybox.css')}"/>
    </xsl:template>
    
    <xsl:template name="head-js-fancybox">
        <script src="{ametys:skinURL('templates/common/plugins/fancybox/jquery.fancybox.js')}"></script>
        <script type="text/javascript">
          $(document).on('ready', function () {
            $j('.js-fancybox').fancybox();
          });
        </script>
    </xsl:template>
	
</xsl:stylesheet>
