<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
        xmlns:math="java.lang.Math"
        exclude-result-prefixes="ametys">
    
    <xsl:import href="plugin:web://pages/services/search/search-default.xsl"/>         
    
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-head-css">
    	<!-- Document Zone -->
	    <link rel="stylesheet" href="{ametys:skinURL('zones/document/scss/main.css')}" />
<!-- 	    <link rel="stylesheet" href="{ametys:skinURL('zones/document/scss/print.css')}" /> -->
	    <!-- End Document Zone -->
    	<!-- Search Zone -->
	    <link rel="stylesheet" href="{ametys:skinURL('zones/search/scss/main.css')}"/>
<!-- 	    <link rel="stylesheet" href="{ametys:skinURL('zones/search/scss/print.css')}"/> -->
	    <!-- End Search Zone -->
	
	    <!-- Filter Zone -->
	    <link rel="stylesheet" href="{ametys:skinURL('zones/filter/scss/main.css')}"/>
<!-- 	    <link rel="stylesheet" href="{ametys:skinURL('zones/filter/scss/print.css')}"/> -->
	    <!-- End Filter Zone -->
	
	    <!-- Paginator Zone -->
	    <link rel="stylesheet" href="{ametys:skinURL('zones/paginator/scss/main.css')}"/>
	    <link rel="stylesheet" href="{ametys:skinURL('zones/paginator/scss/print.css')}"/>
	    <!-- End Paginator Zone -->
    
	    <script type="text/javascript">
    
            function filtersFunction(){
              let selectedItems = [];

              $j(".ametys-search__customselect_btn").on("click", function() {
                var $self = $j(this);
                var selectedItemsBefore = $self.find("input").val().split(", ");
                selectedItems = [];

                if($self.hasClass("active")) {
                  $self.removeClass("active");
                } else {
                  closeCustomeSelect();
                  $self.addClass("active");
                  selectedItems = selectedItemsBefore;
                  fillUpWithCheckedItems($self, selectedItems);
                }
              });

              $j(".ametys-search__customselect_list li").on("change", function(event) {
                var $self = $j(this);
                var labelText = $j(this).find("label").text();
                const index = selectedItems.indexOf(labelText);
                if(index > -1) {
                  selectedItems.splice(index, 1);
                } else {
                  selectedItems.push(labelText);
                }
                selectedItems = selectedItems.filter(item => item);
                fillUpWithCheckedItems($self, selectedItems);
              });

              $(document).mouseup(e => {
                var customDropdown = $j(".ametys-search__customselect");
                if (!customDropdown.is(e.target) &amp;&amp; customDropdown.has(e.target).length === 0) {
                  customDropdown.find(".ametys-search__customselect_btn").removeClass('active');
                }
              });

              function closeCustomeSelect() {
                $j(".ametys-search__customselect_btn").each(function() {
                  $j(this).removeClass("active");
                });
              }

              function fillUpWithCheckedItems(self, itemsList) {
                self.closest(".ametys-search__customselect").find("button input").val(itemsList.join(', ').toString());
              }
            }
          
          </script>
    </xsl:template> 
    
    <!-- Used in common.xsl -->
    <xsl:template name="common-service-body-nonempty-content-content">
        <xsl:call-template name="noscript"/>
    
        <xsl:call-template name="form-criteria"/>
        
        <xsl:call-template name="search-results"/>
        
        <xsl:call-template name="link"/>
        
        <script>
        	$j(document).ready(function($j) {
       			filtersFunction();
       		});
          </script>
    </xsl:template>
    
    <!-- Override to add class ametys-search -->
    <xsl:template name="form-criteria">
        <xsl:call-template name="js-sumit-bo"/>
        <form method="post" class="row g-mb-30" data-ametys-search-role="form" name="{$search-form-id}" id="{$search-form-id}">
            <xsl:if test="$result-display-type = 'IN_PLACE_OF_CRITERIA' and /search/hits and /search/hits/@total > 0">
                <xsl:attribute name="style">display: none;</xsl:attribute>
            </xsl:if>
            <xsl:if test="$result-display-type = 'ON_PAGE'">
                <xsl:attribute name="action"><xsl:value-of select="resolver:resolve('page', /search/result-page)"/>#<xsl:value-of select="$anchor-id" /></xsl:attribute>
            </xsl:if>
            
            <div class="ametys-search">
                <xsl:call-template name="form-search"/>
            </div>
        </form> 
    </xsl:template>
    
    <xsl:template match="criterion" mode="field-input">
        <xsl:param name="value"/>
        
        <xsl:variable name="id"><xsl:call-template name="criterion-id"/></xsl:variable>
        <input id="{$id}" type="text" name="{@name}" value="{$value}" class="form-control ametys-search__input" />
		<script type="text/javascript">
  			$j('#<xsl:value-of select="$id"/>').attr('placeholder', '<xsl:value-of select="label"/>');
  		</script>
        <!-- autocomplete removed -->
    </xsl:template>
    
    <xsl:template match="criterion[starts-with(@name, 'user.input.criterion.common$wording$textfield') or starts-with(@name, 'user.input.criterion.common$titleorwording$textfield')]" mode="field-input">
        <xsl:param name="value"/>
        
        <xsl:variable name="id"><xsl:call-template name="criterion-id"/></xsl:variable>
        <input id="{$id}" type="text" name="{@name}" value="{$value}"  class="form-control ametys-search__input" placeholder="skin.{$skin}:SKIN_SERVICE_SEARCH_VIEW_FULLTEXT_LABEL" i18n:attr="placeholder"/>
    </xsl:template>
    
    <xsl:template match="criterion[enumeration]" mode="field-input">
        <xsl:param name="value"/>
        
        <xsl:variable name="id"><xsl:call-template name="criterion-id"/></xsl:variable>
        
        <div class="ametys-search-multiselect">
	        <select id="{$id}" name="{@name}" class="form-control selectpicker ametys-search__dropdown" title="{label}" multiple="multiple">
<!--             <xsl:apply-templates select="." mode="criterion-enumeration-select"/> -->
            
            <xsl:apply-templates select="." mode="criterion-enumeration-options"> 
			    <xsl:with-param name="value" select="$value"/> 
			</xsl:apply-templates>
        </select>
	    </div>
    </xsl:template>
    
    <xsl:template match="criterion" mode="field">
        <xsl:param name="value"/>
        
<!--         <div class="form-group g-mb-0 col-6"> -->
            <xsl:apply-templates select="." mode="field-input">
                <xsl:with-param name="value" select="$value"/>
            </xsl:apply-templates>
<!--         </div> -->
    </xsl:template>
    
     <xsl:template name="submit-inputs-button">
	    <!-- Template common for submit button -->
	    <xsl:call-template name="common-utils-input-submit">
	        <xsl:with-param name="class-name">search btn-info</xsl:with-param>
	        <xsl:with-param name="i18nkey" select="'plugin.web:PLUGINS_WEB_SERVICE_SEARCH_VIEW_BUTTON_OK'" />
	        <xsl:with-param name="onclick">
	            <xsl:call-template name="search-js-submit-button">
	            	<xsl:with-param name="callback-function">filtersFunction</xsl:with-param>
	            </xsl:call-template>
	        </xsl:with-param>
	    </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="sorts"/>
    
    <xsl:template name="hits">
        <div data-ametys-search-role="hits" class="row">
            <xsl:for-each select="/search/hits/hit">
             <xsl:call-template name="hit"/>
            </xsl:for-each>
        </div>
    </xsl:template>
    
    <xsl:template name="hit">
        <div>
            <xsl:apply-templates select="."/>
        </div>
    </xsl:template>
    
    <xsl:template name="form-result">
        <xsl:variable name="raw-is-title-visible">
            <xsl:call-template name="common-service-body-nonempty-content-title"/>
        </xsl:variable>
        <xsl:variable name="level">
            <xsl:choose>
                <xsl:when test="string-length($raw-is-title-visible) &gt; 0">2</xsl:when>
                <xsl:otherwise>1</xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        
        <div>
            <xsl:call-template name="anchor" />
            
            <xsl:if test="/search/hits/hit">
                <xsl:if test="count(/search/form/fields/criterion) > 0">
                	<span class="d-flex align-items-center mb-3">
                		<xsl:call-template name="card-header-icon"/>
                    	<xsl:element name="h{$level}">
                    		<xsl:attribute name="class">ametys-search__resultats</xsl:attribute>
                    		<i18n:text i18n:key="PLUGINS_WEB_SERVICE_SEARCH_VIEW_RESULTS_TITLE" i18n:catalogue="plugin.web"/>
                    	</xsl:element>
                    </span>
                </xsl:if>
                
                <xsl:call-template name="results-for"/>

                <xsl:call-template name="sorts"/>
            </xsl:if>
        </div>
       
    </xsl:template>
    
    <xsl:template name="card-header-icon">
    	<i class="card-header__icon material-icons">arrow_forward</i>
    </xsl:template>
    
    <xsl:template name="search-results-children">
        <xsl:call-template name="form-criteria-hidden"/>
        
        <xsl:if test="$result-display-type = 'IN_PLACE_OF_CRITERIA' and /search/hits and /search/hits/@total > 0">
            <xsl:call-template name="back-button"/>
        </xsl:if>
        
        <xsl:if test="$result-display-type = 'ABOVE_CRITERIA' or $result-display-type = 'IN_PLACE_OF_CRITERIA'" >
            <xsl:call-template name="form-result"/>
            <xsl:call-template name="form-result-js"/>
        </xsl:if>
        
        <xsl:choose>
            <xsl:when test="/search/hits/hit">
	               <xsl:call-template name="facet-filter"/>
                   
	               <xsl:call-template name="hits"/>
                <xsl:call-template name="pagination"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:if test="/search/hits">
                    <!-- hits is present but no single hit => there is no result -->
	                <xsl:call-template name="no-result"/>
                </xsl:if>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <!-- Overrides the one in /search/helpers/html/hits.xsl -->
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.ResourceSaxer']" mode="class-attribute">search-hit</xsl:template>
    <!-- Overrides the one in /search/helpers/html/hits.xsl -->
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.PageSaxer']" mode="class-attribute">search-hit</xsl:template>
    <!-- Overrides the one in /search/helpers/html/hits.xsl -->
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.ContentSaxer']" mode="class-attribute">search-hit</xsl:template>
    
    <!-- Overrides the one in /search/helpers/html/hits.xsl -->
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.PageSaxer']">
        <xsl:attribute name="class">
            <xsl:apply-templates select="." mode="class-attribute"/>
        </xsl:attribute>
        <div class="service-search-item">
            <xsl:apply-templates select="." mode="image"/>
            <xsl:apply-templates select="." mode="title-link"/>
        </div>
        <xsl:apply-templates select="." mode="abstract"/>
<!--         <xsl:apply-templates select="." mode="date"/> -->
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.PageSaxer']" mode="title-link">
        <a class="card-title">
            <xsl:attribute name="href"><xsl:call-template name="hit-page-title-href" /></xsl:attribute>
            <xsl:value-of select="title"/>
        </a>
    </xsl:template>
    
</xsl:stylesheet>