<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:exslt="http://exslt.org/common"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:datetime="http://ametys.org/datetime/4.2"
                xmlns:dateutils="org.ametys.core.util.DateUtils"
                exclude-result-prefixes="ametys resolver dateutils datetime"
                extension-element-prefixes="datetime exslt">  
    
    <xsl:import href="plugin:core://stylesheets/helper/datetime.xsl"/>
    <xsl:import href="plugin:web://stylesheets/content/common.xsl"/>
    <xsl:import href="skin://stylesheets/config/config.xsl"/>
    <xsl:import href="skin://stylesheets/utils.xsl"/>
    
    <xsl:variable name="date-time-format" select="ametys:translate(concat('skin.', $skin, ':SKIN_DATE_TIME_FORMAT'))"></xsl:variable>
    <xsl:variable name="date-format" select="ametys:translate(concat('skin.', $skin, ':SKIN_DATE_FORMAT'))"></xsl:variable>
    
    <xsl:variable name="hideTitle" select="$zone = 'default' and ametys:zoneParameter('default', 'hideTitle') = 'true'" />
    
    <xsl:variable name="override-card-styles"></xsl:variable>
    
    <!-- Number of likers display with their fullname in likes/unlike button tooltip -->
    <xsl:variable name="maxLikersInTooltip">3</xsl:variable>
    
    <xsl:template name="common-content-head-css">
         <link rel="stylesheet" type="text/css" href="{ametys:skinURL('templates/common/scss/richtext.css')}" media="screen, print, handheld"/>
         <!-- Hero Zone -->
         <link rel="stylesheet" href="{ametys:skinURL('zones/hero/scss/main.css')}" />
         <!-- End Hero Zone -->
         
         <xsl:call-template name="custom-content-css"/>
    </xsl:template>     
    
    <xsl:template name="common-content-head-js">
        <xsl:call-template name="content-likes-script"/>
    </xsl:template>
    
    <!-- Custom css class for content rendering -->
    <xsl:template name="custom-content-css"/>
    
    <xsl:template name="common-content-body-title-content">
        <xsl:choose>
            <xsl:when test="$zone = 'default' and metadata/illustration/image">
                <xsl:call-template name="zone-header-with-img"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="zone-header-no-img"/>
            </xsl:otherwise>
        </xsl:choose>        
    </xsl:template>
    
    <xsl:template name="common-content-body-content">
        <!-- Image -->
        <xsl:if test="$zone != 'default'">
            <xsl:call-template name="common-content-body-image-bigsize"/>    
        </xsl:if>
    
        <div class="flex-center">
            <!-- Tags -->
            <xsl:call-template name="badge"/>
            
            <!-- Dates -->
            <xsl:call-template name="common-content-body-content-dates"/>
            
            <!-- Likes -->
            <xsl:call-template name="content-likes"/>
        </div>
        
        <!-- Rich content -->
        <div class="ametys-richtext">
            <xsl:call-template name="common-content-body-content-rich"/>
        </div>
        
        <!-- Contact, Publish date... -->
        <xsl:call-template name="common-content-body-meta"/>        

        <!-- Comments -->
        <xsl:call-template name="common-content-body-comments"/>
    </xsl:template>   
    
	<!-- Contact, Publish date... -->
    <xsl:template name="common-content-body-meta">
        <xsl:if test="((metadata/contact/name or metadata/contact/mail) and $conf-content-displayauthor = 'true') or (@lastValidatedAt and $conf-content-displaydate = 'true')">
            <div class="meta">
                <xsl:call-template name="common-content-body-contact"/>
                <xsl:call-template name="common-content-body-publish-date"/>
            </div>
        </xsl:if>
    </xsl:template>

    <!-- Template used to display the contact -->
    <xsl:template name="common-content-body-contact">
        <xsl:if test="(metadata/contact/name or metadata/contact/mail) and $conf-content-displayauthor = 'true'">
            <p class="content-contact">
                <i18n:text i18n:key="CONTENT_VIEW_CONTACT" i18n:catalogue="plugin.cms"/>
                <xsl:text> </xsl:text>
                <xsl:if test="metadata/contact/name"><xsl:value-of select="metadata/contact/name"/></xsl:if>
                <xsl:if test="metadata/contact/name and metadata/contact/mail"><xsl:text> (</xsl:text></xsl:if>
                <xsl:if test="metadata/contact/mail">
                    <xsl:call-template name="mail-antispam">
                        <xsl:with-param name="mail" select="metadata/contact/mail"></xsl:with-param>
                    </xsl:call-template>
                </xsl:if>
                <xsl:if test="metadata/contact/name and metadata/contact/mail"><xsl:text>)</xsl:text></xsl:if>
            </p>
        </xsl:if>    
    </xsl:template>
    
    <xsl:template name="common-content-body-publish-date"/>   
    
    <!-- +
		 | HEADERS
		 + -->
	<xsl:template name="zone-header-with-img">
		<xsl:param name="title" select="metadata/title"/>
        <xsl:param name="subtitle" select="metadata/document-subtitle"/>
        <xsl:param name="image" select="metadata/illustration/image"/>
        <xsl:param name="alternative" select="metadata/illustration/alt-text"/>
        
        <div class="ametys-hero">
        	<xsl:choose>
        		<xsl:when test="$template = 'page-2-columns'">
                     <img alt="{$alternative}" src="{resolver:resolveCroppedImage($image/@type, $image/@path, 457, 932)}"/>
        		</xsl:when>
        		<xsl:otherwise>
                    <img alt="{$alternative}" src="{resolver:resolveCroppedImage($image/@type, $image/@path, 396, 1413)}"/>
        		</xsl:otherwise>
        	</xsl:choose>
         
	        <xsl:if test="not($hideTitle)">
	            <h1 class="ametys-hero__title">
	                <xsl:value-of select="$title"/>
	                <xsl:if test="$subtitle != ''">
	                    <span class="ametys-content-subtitle"><xsl:value-of select="$subtitle"/></span>
	                </xsl:if>
	            </h1>
	        </xsl:if>
            
        </div>
	</xsl:template>
    
    <xsl:template name="zone-header-no-img">
        <xsl:param name="title" select="metadata/title"/>
        <xsl:param name="subtitle" select="metadata/document-subtitle"/>
        
        <xsl:if test="not($hideTitle)">
            <h1>
                <span class="ametys-content-title"><xsl:value-of select="$title"/></span>
                <xsl:if test="$subtitle != ''">
                    <span class="ametys-content-subtitle"><xsl:value-of select="$subtitle"/></span>
                </xsl:if>
            </h1>
        </xsl:if>
    </xsl:template>
	
    <xsl:template name="common-content-body-content-dates">
        <xsl:param name="startDate" select="metadata/start-date"/>
        <xsl:param name="endDate" select="metadata/end-date"/>
        <xsl:param name="hideDate" select="metadata/hide-date"/>
        
        <xsl:if test="($startDate != '' or $endDate != '') and not($hideDate = 'true')">
            <span class="ametys-time">
                <i class="material-icons">access_time</i>
                <xsl:call-template name="dates">
                    <xsl:with-param name="startDate" select="$startDate"/>
                    <xsl:with-param name="endDate" select="$endDate"/>
                </xsl:call-template>
            </span>        
        </xsl:if>
    </xsl:template>
    
	<xsl:template name="dates">
		<xsl:param name="startDate"/>
		<xsl:param name="endDate"/>
        <xsl:param name="isDatetime">true</xsl:param>
        
        <xsl:choose>
            <xsl:when test="$startDate and not($endDate)">
                <xsl:call-template name="common-date-pattern">
                    <xsl:with-param name="date" select="$startDate"/>
                    <xsl:with-param name="role" select="'dtstart'"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="$endDate and not($startDate)">
                <xsl:call-template name="common-date-pattern">
                    <xsl:with-param name="date" select="$endDate"/>
                    <xsl:with-param name="role" select="'dtstart'"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="$startDate and $endDate and $isDatetime = 'true' and datetime:sameDateTime($startDate, $endDate)">
				<xsl:call-template name="common-date-pattern">
					<xsl:with-param name="date" select="$startDate"/>
                    <xsl:with-param name="role" select="'dtstart'"/>
				</xsl:call-template>
			</xsl:when> 
            <xsl:when test="$startDate and $endDate and not($isDatetime = 'true') and datetime:sameDate($startDate, $endDate)">
                <xsl:call-template name="common-date-pattern">
                    <xsl:with-param name="date" select="$startDate"/>
                    <xsl:with-param name="role" select="'dtstart'"/>
                </xsl:call-template>
            </xsl:when> 
            <xsl:when test="$startDate and $endDate">
                <xsl:call-template name="common-date-pattern">
                    <xsl:with-param name="date" select="$startDate"/>
                    <xsl:with-param name="role" select="'dtstart'"/>
                </xsl:call-template>
                <span><i18n:text i18n:key="CONTENT_NEWS_DATE_TO" i18n:catalogue="plugin.news"/></span>
                <xsl:call-template name="common-date-pattern">
                    <xsl:with-param name="date" select="$endDate"/>
                    <xsl:with-param name="role" select="'dtend'"/>
                </xsl:call-template>
            </xsl:when>
        </xsl:choose>
    </xsl:template>
        
	<xsl:template name="common-date-pattern">
        <xsl:param name="date"/>
        <xsl:param name="role"/>
        
        <xsl:choose>
            <xsl:when test="$role = 'dtstart' or $role = 'dtend'">
                <abbr class="{$role}">
                    <span class="value-title" title="{$date}">
                        <xsl:call-template name="common-utils-date-pattern">
                            <xsl:with-param name="date" select="$date"/>
                        </xsl:call-template>
                    </span>
                </abbr>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="common-utils-date-pattern">
                    <xsl:with-param name="date" select="$date"/>
                </xsl:call-template>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
     <!-- Template used for date format -->
    <xsl:template name="common-utils-date-pattern">
        <xsl:param name="date"/>
        
        <xsl:choose>
            <xsl:when test="dateutils:isAtMidnight($date, '')">
                <!-- If hour is 00:00 do not display hours -->
                <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="{$date-format}" value="{$date}"/>
            </xsl:when>
            <xsl:otherwise>
                <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="{$date-time-format}" value="{$date}"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
     <xsl:template name="badge">
        <xsl:variable name="tags"><xsl:call-template name="get-content-tags"/></xsl:variable>
        
        <xsl:if test="exslt:node-set($tags)/tag">
            <span class="tags">
                <xsl:for-each select="exslt:node-set($tags)/tag[position() &lt;= 3]">
                    <span class="ametys-tag-v2">
                        <xsl:if test="$useTagColor and @bgColor">
                            <xsl:attribute name="style">background-color: <xsl:value-of select="@bgColor"/>; color: <xsl:value-of select="@textColor"/></xsl:attribute>
                        </xsl:if>
                        <xsl:value-of select="." />
                   </span>
                </xsl:for-each>
            </span>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="content-likes">
        <xsl:if test="metadata/likes = 'true'">
            <span data-ametys-content-likes="{@id}" class="ametys-content-likes">
                <button 
                    type="button"
                    onclick="AmetysFront.ContentReactions.likeOrUnlike('{@id}', $j(this).attr('data-ametys-content-own-liker') == 'true', likeOrUnlikeContentCb_{$uniqueId})"
                    title="plugin.cms:PLUGINS_CMS_CONTENT_LIKE_TITLE"
                    i18n:attr="title"
                    data-ametys-content-own-liker="false" 
                    aria-pressed="false" 
                    aria-describedby="tooltip-{$uniqueId}"
                    class="ametys-content-likes__btn">
                    <span aria-hidden="true" class="icon like far fa-heart"></span>
                    <span aria-hidden="true" class="icon unlike fas fa-heart"></span>
                </button>
                <span id="tooltip-{$uniqueId}" role="tooltip" class="sr-only">
                    <!-- tootip content with likers-->
                </span>
                <span data-ametys-content-likes-count="true" class="ametys-content-likes__count"></span>
            </span>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="content-likes-script">
        <xsl:if test="metadata/likes = 'true'">
            <script type="text/javascript" src="{concat(ametys:uriPrefix(), '/plugins/cms/resources/js/AmetysFront/ContentReactions.', ametys:lang(), '.js')}"/>
            
            <script type="text/javascript">
                // Tippy plugin to hide tooltip on ESC
                const hideContentLikesTooltipOnEs_<xsl:value-of select="$uniqueId"/> = {
                  name: 'hideOnEsc',
                  defaultValue: true,
                  fn({hide}) {
                    function onKeyDown(event) {
                      if (event.keyCode === 27) {
                        hide();
                      }
                    }
                    return {
                      onShow() {
                        document.addEventListener('keydown', onKeyDown);
                      },
                      onHide() {
                        document.removeEventListener('keydown', onKeyDown);
                      },
                    };
                  },
                };
                    
                function updateContentLikes_<xsl:value-of select="$uniqueId"/>(contentId, likers)
                {
                    let $likesEl = $j("[data-ametys-content-likes='" + contentId + "']");
                    let $btn = $likesEl.find("button");
                    let nbLikes = likers.length;
                    let maxNbLikers = <xsl:value-of select="$maxLikersInTooltip"/>;
                    let ownLiker = false;
                    
                    // Update count
                    $likesEl.find("[data-ametys-content-likes-count]").html(nbLikes);
                    if (nbLikes==0)
                    {
                        $likesEl.find("[data-ametys-content-likes-count]").hide();
                    }
                    else
                    {
                        $likesEl.find("[data-ametys-content-likes-count]").show();
                    }
                    
                    // Update likers
                    let likerTooltips = "";
                    $j.each(likers, function(i, liker) {
                        if (ametysUser &amp;&amp; liker.login == ametysUser.login &amp;&amp; liker.populationId == ametysUser.populationId)
                        {
                            ownLiker = true;
                        }
                        
                        if (i &lt; maxNbLikers)
                        {
                            likerTooltips += "&lt;span class='like'>" + liker.fullname + "&lt;/span>"
                        }
                    });
                    
                    let otherCount = nbLikes - maxNbLikers;
                    if (otherCount == 1)
                    {
                        likerTooltips += "&lt;span class='like'><i18n:text i18n:key="PLUGINS_CMS_CONTENT_LIKE_OTHER_TOOLTIP" i18n:catalogue="plugin.cms"/>&lt;/span>"
                    }
                    else if (otherCount &gt; 1)
                    {
                        likerTooltips += "&lt;span class='like'>" + "<i18n:text i18n:key="PLUGINS_CMS_CONTENT_LIKE_OTHERS_TOOLTIP" i18n:catalogue="plugin.cms"/>".replace(/\{0}/, otherCount) + "&lt;/span>";
                    }
                    
                    if (likerTooltips)
                    {
                        $likesEl.find("[role=tooltip]").html(likerTooltips);
                        
                        // Tooltip
                        $btn.attr("data-toggle", "tooltip");
                        $btn.attr("data-html", true);
                        $btn.attr("data-placement", "top");
                        $btn.attr("data-original-title", $likesEl.find("[role=tooltip]").html());
                        $btn.attr("title", $likesEl.find("[role=tooltip]").html());
                        $btn.tooltip();
                    }
                    
                    $btn.attr("data-ametys-content-own-liker", ownLiker);
                    
                    if (ownLiker)
                    {
                        $btn.addClass("active");
                        $btn.attr("title", "<i18n:text i18n:key="PLUGINS_CMS_CONTENT_UNLIKE_TITLE" i18n:catalogue="plugin.cms"/>");
                        $btn.attr("aria-pressed", "true");
                    }
                    else
                    {
                        $btn.removeClass("active");
                        $btn.attr("title", "<i18n:text i18n:key="PLUGINS_CMS_CONTENT_LIKE_TITLE" i18n:catalogue="plugin.cms"/>");
                        $btn.attr("aria-pressed", "false");
                    }
                }
                
                function likeOrUnlikeContentCb_<xsl:value-of select="$uniqueId"/>(contentId, result, liked)
                {
                    if (result.updated)
                    {
                        updateContentLikes_<xsl:value-of select="$uniqueId"/>(contentId, result.actors);
                    }
                }
                
                $j(document).ready(function(){
                    AmetysFront.ContentReactions.getLikes('<xsl:value-of select="@id"/>', updateContentLikes_<xsl:value-of select="$uniqueId"/>);
                });
            </script>
        </xsl:if>
    </xsl:template>
    
</xsl:stylesheet>    