<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2024 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                            xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                            xmlns:exsl="http://exslt.org/common"
                            xmlns:math="java.lang.Math"
                            xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
                            xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            exclude-result-prefixes="sitemap resolver ametys">
    
    <!-- Refresh delay for subscription notification -->
    <xsl:variable name="notificationCenterRefreshDelay" select="ametys:siteParameter('notification-center-refresh-delay') * 60000"/><!-- refresh delay in min -->
    <!-- Max number of content's title to display in tooltip -->
    <xsl:variable name="maxContentsInTooltip">3</xsl:variable>
    <!-- View of contents displayed into popup -->
    <xsl:variable name="subscriptionViewName">subscription</xsl:variable>
    
    <!-- +
         | Notifications item in header with subscriptions
         + -->
    <xsl:template name="my-subscriptions">
        <xsl:if test="$notificationCenterEnabled = 'true'">
            <li class="ametys-header-action-nav__item abo-section" style="display: none;">
                <button class="ametys-header-action-nav__link" type="button">
                    <div class="ametys-header-action-nav__item-left">
                        <xsl:call-template name="my-subscriptions-icon"/>
                        <span class="link-dynamic-info" style="display: none">
                            <span class="ametys-header-action-nav__item-badge" data-subscriptions-nb-unread="true"></span>
                        </span>
                    </div>
                    <div class="ametys-header-action-nav__item-text">
                        <i18n:text i18n:key="SKIN_MY_SUBSCRIPTIONS" i18n:catalogue="skin.{$skin}" />
                    </div>
                </button>
                <div class="link-info-tooltip abo-dropdown">
                    <ul class="link-abo-list">
                        <!-- Notifications will be inserted here -->
                    </ul>
                    
                    <p data-subscriptions-no-item="true" style="display: none"><i18n:text i18n:key="SKIN_MY_SUBSCRIPTIONS_NO_ITEM" i18n:catalogue="skin.{$skin}"/></p>
                    <p data-subscriptions-no-subscription="true" style="display: none"><i18n:text i18n:key="SKIN_MY_SUBSCRIPTIONS_NO_SUBSCRIPTION" i18n:catalogue="skin.{$skin}"/></p>
                    
                    <xsl:call-template name="notification-center-config"/>
                </div>
                
                <xsl:call-template name="notification-center-modal"/>
                <xsl:call-template name="notification-center-js"/>
            </li>
        </xsl:if>
    </xsl:template>
    
    <!-- +
         | Link to page with subscriptions service
         + -->
    <xsl:template name="notification-center-config">
        <xsl:variable name="tagSubscriptionPage" select="ametys:findPagesIdsByTag('TAG_SUBSCRIPTIONS_CONFIG')"/>
        <xsl:if test="$tagSubscriptionPage">
            <div class="link-abo-configure">
              <a href="{resolver:resolve('page', $tagSubscriptionPage/@id)}"><i18n:text i18n:key="SKIN_MY_SUBSCRIPTIONS_CONFIG" i18n:catalogue="skin.{$skin}"/><i class="fas fa-cog" aria-hidden="true"></i> </a>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="my-subscriptions-icon">
        <span class="ametys-header-action-nav__item-icon">
            <svg class="ametys-header-action-nav__item-icon" width="28px" height="19px" viewBox="0 0 28 19" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                <g aria-hidden="true" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                    <g transform="translate(-929, -24)" fill="#1ABC9C" fill-rule="nonzero">
                        <g transform="translate(929, 14)">
                            <g transform="translate(0, 10.184)">
                                <path
                                    d="M24.472,0 C24.472,1.43733333 24.472,2.87466667 24.472,4.312 L24.472,6.048 C24.472,6.12266667 24.4626667,6.16933333 24.444,6.188 C24.4253333,6.20666667 24.3786667,6.20666667 24.304,6.188 C23.5946667,6.00133333 22.9786667,6.20666667 22.456,6.804 C22.4186667,6.72933333 22.4093333,6.636 22.428,6.524 L22.428,5.152 C22.4093333,3.976 22.4093333,3.09866667 22.428,2.52 C22.428,2.408 22.4093333,2.32866667 22.372,2.282 C22.3346667,2.23533333 22.2506667,2.22133333 22.12,2.24 C20.7386667,2.38933333 19.5906667,2.56666667 18.676,2.772 C17.444,3.052 16.3426667,3.444 15.372,3.948 C15.2226667,4.04133333 15.12,4.13466667 15.064,4.228 C15.008,4.32133333 14.98,4.46133333 14.98,4.648 C14.9986667,5.97333333 14.9986667,7.97066667 14.98,10.64 L14.98,14 C15.0173333,14.0373333 15.0733333,14.0373333 15.148,14 C17.0333333,13.3093333 19.2733333,12.8333333 21.868,12.572 C21.9613333,12.572 22.0266667,12.586 22.064,12.614 C22.1013333,12.642 22.12,12.7026667 22.12,12.796 C22.0826667,13.3933333 22.1573333,13.9346667 22.344,14.42 C22.3813333,14.5133333 22.3813333,14.574 22.344,14.602 C22.3066667,14.63 22.2506667,14.644 22.176,14.644 L22.148,14.644 C21.14,14.7186667 20.104,14.8586667 19.04,15.064 C17.4906667,15.3626667 16.2493333,15.736 15.316,16.184 C14.4386667,16.576 13.5426667,16.576 12.628,16.184 C11.8253333,15.8293333 10.9293333,15.5306667 9.94,15.288 C9.156,15.1013333 8.232,14.9333333 7.168,14.784 L5.796,14.644 C5.70266667,14.644 5.64666667,14.6253333 5.628,14.588 C5.60933333,14.5506667 5.61866667,14.4946667 5.656,14.42 C5.824,13.8973333 5.89866667,13.384 5.88,12.88 C5.86133333,12.768 5.87533333,12.6886667 5.922,12.642 C5.96866667,12.5953333 6.05733333,12.5813333 6.188,12.6 C8.78266667,12.8613333 11.0226667,13.3373333 12.908,14.028 C12.9453333,13.9906667 12.9546667,13.916 12.936,13.804 L12.936,13.748 C12.936,9.64133333 12.9453333,6.56133333 12.964,4.508 C12.964,4.30266667 12.8706667,4.144 12.684,4.032 C11.4706667,3.36 9.912,2.856 8.008,2.52 C7.52266667,2.44533333 6.79466667,2.352 5.824,2.24 C5.69333333,2.22133333 5.60933333,2.23533333 5.572,2.282 C5.53466667,2.32866667 5.516,2.41733333 5.516,2.548 L5.516,6.748 C5.21733333,6.44933333 4.9,6.258 4.564,6.174 C4.228,6.09 3.864,6.11333333 3.472,6.244 L3.444,6.048 L3.444,0.224 L3.472,0 L3.948,0 C3.98533333,0.0373333333 4.04133333,0.056 4.116,0.056 L4.172,0.056 C5.64666667,0.112 7.04666667,0.261333333 8.372,0.504 C10.5373333,0.858666667 12.3386667,1.456 13.776,2.296 C13.8506667,2.33333333 13.916,2.34733333 13.972,2.338 C14.028,2.32866667 14.0933333,2.30533333 14.168,2.268 C14.8773333,1.876 15.54,1.57733333 16.156,1.372 C17.0706667,1.036 18.088,0.765333333 19.208,0.56 C20.104,0.392 21.1493333,0.252 22.344,0.14 C22.4746667,0.121333333 22.6706667,0.112 22.932,0.112 C23.3986667,0.0933333333 23.744,0.056 23.968,0 L24.472,0 Z M3.108,7.392 C2.94,8.77333333 2.70666667,10.08 2.408,11.312 L2.408,11.368 C2.38933333,11.48 2.38933333,11.5686667 2.408,11.634 C2.42666667,11.6993333 2.48266667,11.7413333 2.576,11.76 C2.66933333,11.7786667 2.73466667,11.7646667 2.772,11.718 C2.80933333,11.6713333 2.83733333,11.6013333 2.856,11.508 L2.884,11.452 C2.996,10.9853333 3.12666667,10.2666667 3.276,9.296 L3.416,8.456 L3.444,8.232 C3.46266667,8.02666667 3.48133333,7.87733333 3.5,7.784 C3.53733333,7.56 3.62133333,7.38733333 3.752,7.266 C3.88266667,7.14466667 4.04133333,7.09333333 4.228,7.112 C4.41466667,7.13066667 4.56866667,7.21 4.69,7.35 C4.81133333,7.49 4.88133333,7.66266667 4.9,7.868 L4.9,10.08 C4.88133333,11.2746667 4.88133333,12.18 4.9,12.796 C4.9,13.6173333 4.704,14.3266667 4.312,14.924 C3.73333333,15.8386667 3.36,16.7906667 3.192,17.78 C3.17333333,17.892 3.136,17.9573333 3.08,17.976 C3.024,17.9946667 2.94,17.9853333 2.828,17.948 C1.67066667,17.5373333 0.802666667,17.2386667 0.224,17.052 C0.112,17.0146667 0.042,16.9726667 0.014,16.926 C-0.014,16.8793333 0,16.8 0.056,16.688 C0.354666667,16.0906667 0.532,15.428 0.588,14.7 C0.644,14.1026667 0.616,13.4213333 0.504,12.656 C0.429333333,11.984 0.392,11.48 0.392,11.144 C0.373333333,10.5093333 0.578666667,9.93066667 1.008,9.408 C1.32533333,9.05333333 1.82,8.55866667 2.492,7.924 L2.968,7.476 C2.98666667,7.45733333 3.03333333,7.42933333 3.108,7.392 Z M24.864,7.364 C25.0133333,7.45733333 25.2,7.62533333 25.424,7.868 L25.592,8.036 C25.704,8.12933333 25.8626667,8.27866667 26.068,8.484 C26.2733333,8.68933333 26.432,8.83866667 26.544,8.932 C27.0293333,9.324 27.3466667,9.8 27.496,10.36 C27.6453333,10.864 27.664,11.4426667 27.552,12.096 C27.44,12.8613333 27.384,13.468 27.384,13.916 C27.3653333,14.588 27.4306667,15.1946667 27.58,15.736 C27.7293333,16.184 27.8506667,16.5106667 27.944,16.716 C27.9813333,16.8093333 27.9953333,16.8793333 27.986,16.926 C27.9766667,16.9726667 27.9346667,17.0053333 27.86,17.024 L25.088,17.976 C24.9386667,18.032 24.8546667,17.9853333 24.836,17.836 C24.6866667,16.9026667 24.2386667,15.8106667 23.492,14.56 C23.2306667,14.1493333 23.1,13.664 23.1,13.104 L23.1,7.924 C23.1,7.56933333 23.226,7.32666667 23.478,7.196 C23.73,7.06533333 23.9773333,7.084 24.22,7.252 C24.388,7.38266667 24.4906667,7.60666667 24.528,7.924 C24.6773333,9.19333333 24.8546667,10.304 25.06,11.256 L25.088,11.312 C25.1066667,11.3866667 25.116,11.4426667 25.116,11.48 L25.144,11.508 C25.1626667,11.6013333 25.1953333,11.6713333 25.242,11.718 C25.2886667,11.7646667 25.3493333,11.7786667 25.424,11.76 C25.6106667,11.7413333 25.6666667,11.6106667 25.592,11.368 L25.228,9.632 L25.172,9.296 C25.0413333,8.456 24.9386667,7.812 24.864,7.364 Z M11.592,6.104 C11.592,6.36533333 11.5826667,6.538 11.564,6.622 C11.5453333,6.706 11.494,6.748 11.41,6.748 C11.326,6.748 11.1533333,6.71066667 10.892,6.636 C9.73466667,6.26266667 8.652,5.992 7.644,5.824 C7.55066667,5.80533333 7.48533333,5.77266667 7.448,5.726 C7.41066667,5.67933333 7.392,5.60933333 7.392,5.516 C7.42933333,5.21733333 7.42933333,4.928 7.392,4.648 C7.392,4.51733333 7.41533333,4.43333333 7.462,4.396 C7.50866667,4.35866667 7.588,4.35866667 7.7,4.396 C9.1,4.676 10.164,4.93733333 10.892,5.18 C11.1533333,5.25466667 11.326,5.31533333 11.41,5.362 C11.494,5.40866667 11.5453333,5.47866667 11.564,5.572 C11.5826667,5.66533333 11.592,5.84266667 11.592,6.104 Z M11.592,8.54 C11.592,8.82 11.5826667,9.002 11.564,9.086 C11.5453333,9.17 11.494,9.20733333 11.41,9.198 C11.326,9.18866667 11.1533333,9.14666667 10.892,9.072 C10.0146667,8.792 8.932,8.52133333 7.644,8.26 C7.55066667,8.24133333 7.48533333,8.218 7.448,8.19 C7.41066667,8.162 7.392,8.10133333 7.392,8.008 C7.42933333,7.69066667 7.42933333,7.364 7.392,7.028 C7.392,6.93466667 7.41533333,6.874 7.462,6.846 C7.50866667,6.818 7.56933333,6.81333333 7.644,6.832 C8.95066667,7.09333333 10.2013333,7.41066667 11.396,7.784 C11.5266667,7.80266667 11.592,7.88666667 11.592,8.036 L11.592,8.54 Z M16.324,6.076 C16.324,5.81466667 16.3333333,5.642 16.352,5.558 C16.3706667,5.474 16.422,5.40866667 16.506,5.362 C16.59,5.31533333 16.7626667,5.25466667 17.024,5.18 C17.7706667,4.93733333 18.844,4.676 20.244,4.396 C20.356,4.35866667 20.4353333,4.35866667 20.482,4.396 C20.5286667,4.43333333 20.5473333,4.50333333 20.538,4.606 C20.5286667,4.70866667 20.524,4.844 20.524,5.012 C20.5613333,5.348 20.5426667,5.572 20.468,5.684 C20.4306667,5.77733333 20.3466667,5.83333333 20.216,5.852 C20.1413333,5.88933333 20.02,5.91266667 19.852,5.922 C19.684,5.93133333 19.5626667,5.94533333 19.488,5.964 C18.4053333,6.22533333 17.4626667,6.48666667 16.66,6.748 C16.5293333,6.804 16.436,6.81333333 16.38,6.776 C16.324,6.73866667 16.3053333,6.65466667 16.324,6.524 C16.3426667,6.468 16.3426667,6.37466667 16.324,6.244 L16.324,6.076 Z M16.324,8.54 C16.324,8.27866667 16.3333333,8.106 16.352,8.022 C16.3706667,7.938 16.422,7.87266667 16.506,7.826 C16.59,7.77933333 16.7626667,7.71866667 17.024,7.644 C17.864,7.364 18.9373333,7.09333333 20.244,6.832 C20.356,6.81333333 20.4353333,6.82266667 20.482,6.86 C20.5286667,6.89733333 20.5426667,6.972 20.524,7.084 L20.524,7.308 C20.5053333,7.532 20.5053333,7.69066667 20.524,7.784 C20.5426667,7.952 20.5193333,8.07333333 20.454,8.148 C20.3886667,8.22266667 20.272,8.27866667 20.104,8.316 C18.984,8.50266667 17.836,8.80133333 16.66,9.212 C16.5106667,9.268 16.4126667,9.27266667 16.366,9.226 C16.3193333,9.17933333 16.3053333,9.09066667 16.324,8.96 C16.3426667,8.904 16.3426667,8.81066667 16.324,8.68 L16.324,8.54 Z M11.592,11.06 C11.592,11.3213333 11.5826667,11.494 11.564,11.578 C11.5453333,11.662 11.494,11.6993333 11.41,11.69 C11.326,11.6806667 11.1533333,11.6386667 10.892,11.564 C9.69733333,11.2093333 8.63333333,10.948 7.7,10.78 C7.588,10.7426667 7.50866667,10.7006667 7.462,10.654 C7.41533333,10.6073333 7.392,10.528 7.392,10.416 C7.42933333,10.0986667 7.42933333,9.79066667 7.392,9.492 C7.392,9.36133333 7.46666667,9.30533333 7.616,9.324 C8.624,9.51066667 9.884,9.81866667 11.396,10.248 C11.5453333,10.304 11.6106667,10.4066667 11.592,10.556 L11.592,11.06 Z"
                                    id="Shape"></path>
                            </g>
                        </g>
                    </g>
                </g>
            </svg>
        </span>
    </xsl:template>
    
    <!-- +
         | Script for notifications tooltip and popup
         + -->
    <xsl:template name="notification-center-js">
        <script type="text/javascript">
        
            // Get notifications in tooltip
            function getTagNotificationsCb (subscriptions)
            {
                // Clear items
                $j('.link-abo-list .link-abo-item').remove();
                
                let unreadCount = 0;
                if (subscriptions &amp;&amp; subscriptions.length) // the user has subscriptions
                {
                    // show notifications item
                    $j('.ametys-header-action-nav__item.abo-section').show();
                    
                    // hide hint for no subscription
                    $j('[data-subscriptions-no-subscription]').hide();
                    
                    $j.each(subscriptions, function (i, subscription) {
                    
                      var contents = subscription.contents || [];
                      if (contents.length)
                      { 
                          subscription.formattedLastActivityDate = AmetysFront.Utils.toReadableDate(subscription.lastActivityDate);
                        
                          let max = Math.min(<xsl:value-of select="$maxContentsInTooltip"/>, contents.length);
                          let titles = [];
                          for (var i=0; i &lt; max; i++)
                          {
                               titles.push(contents[i].title);
                          }
                          
                          if (!subscription.hasRead)
                          { 
                              unreadCount++;
                          }
                        
                          subscription.contentTitles = titles.join(', ');
                        
                          let remainContents = contents.length - 3;
                          if (remainContents > 1)
                          {
                              subscription.contentTitles += "<i18n:text i18n:key="SKIN_MY_SUBSCRIPTIONS_OTHERS" i18n:catalogue="skin.{$skin}"/>".replace(/\{0\}/, remainContents);
                          }
                          else if (remainContents == 1)
                          {
                              subscription.contentTitles += "<i18n:text i18n:key="SKIN_MY_SUBSCRIPTIONS_OTHER" i18n:catalogue="skin.{$skin}"/>";
                          }
                          
                          // Insert item for the subscription with summary of updated contents
                          $j('.link-abo-list').append(`&lt;li class="link-abo-item">
                                &lt;div class="link-abo-item__top">
                                      &lt;span class="tag">${subscription.tag.label}&lt;/span>
                                      &lt;div class="date-bull">
                                        &lt;span class="date">${subscription.formattedLastActivityDate}&lt;/span>
                                        ${!subscription.hasRead ? '&lt;span class="bull active">&lt;/span>' : ''}
                                      &lt;/div>
                                &lt;/div>
                                &lt;p>${subscription.contentTitles}&lt;/p>
                                &lt;button type="button" aria-haspopup="dialog" 
                                           data-ametys-tag-notifications-subscription="${subscription.id}"
                                           data-ametys-tag-notifications-date="${subscription.formattedLastActivityDate}" 
                                           data-ametys-tag-notifications-tag="${subscription.tag.label}" 
                                           onclick="AmetysFront.UserNotifications.showContentsOfSubscription(this, '<xsl:value-of select="$subscriptionViewName"/>', showNotificationsContents)">
                                  <i18n:text i18n:key="SKIN_MY_SUBSCRIPTIONS_SEE_CONTENTS" i18n:catalogue="skin.{$skin}"/>
                                &lt;/button>
                              &lt;/li>`);
                         
                      }
                    });
                    
                    if ($j('.link-abo-list .link-abo-item').length)
                    {
                        $j('[data-subscriptions-no-item]').hide();
                    }
                    else
                    {
                        // user has subscriptions but none with new contents
                        $j('[data-subscriptions-no-item]').show();
                    }
                    
                    $j('[data-subscriptions-nb-unread]').html(unreadCount);
                    if (unreadCount > 0)
                    {
                        $j('[data-subscriptions-nb-unread]').parent().show();
                    }
                    else
                    {
                        $j('[data-subscriptions-nb-unread]').parent().hide();
                    }
                }
                else
                {
                    // No subscription
                    $j('[data-subscriptions-no-subscription]').show();
                    $j('[data-subscriptions-nb-unread]').parent().hide();
                    
                    // Display notification item only if there is a page to handle subscription
                    if ($j('.abo-section .link-abo-configure').length)
                    {
                        $j('.ametys-header-action-nav__item.abo-section').show();
                    }
                    
                }
            }
            
            var parentItemPos;
            var parentSize;
            var parentHeight;
            var modalContent;
            var aboItemContent;
            var openModalInvoker;
            
            // click outside .abo-dropdown display none
              $j(document).click(function (event) {
                if (
                  !$j(event.target).is(".abo-dropdown") &amp;&amp;
                  !$j(event.target).is(".action-modal *") &amp;&amp;
                  !$j(event.target).is(".abo-section *") &amp;&amp;
                  !$j(event.target).is(".abo-dropdown *") &amp;&amp;
                  !$j(event.target).is(".action-modal") &amp;&amp;
                  !$j(event.target).is(".ametys-overlay-modal") &amp;&amp;
                  !$j(event.target).is('.ametys-modal *') &amp;&amp;
                  !$j(event.target).is('.ametys-modal')
                ) {
                   $j(".abo-dropdown").css('display', 'none');
                }
              });
            
            // Open popup with all contents of a subscription with animation
            function showNotificationsContents(btn)
            {
                openModalInvoker = $j(btn);
                
                let $modal = $j(AmetysFront.UserNotifications.TAG_NOTIFICATIONS_CONTENTS_SELECTOR);
                
                const parentItem = $j(btn).closest(".link-abo-item");
                $j(".abo-section .abo-dropdown").css("display", "block");
                $modal.addClass("active");
          
                parentItemPos = $j(parentItem).offset();
                parentSize = $j(parentItem).outerWidth();
                parentHeight = $j(parentItem).outerHeight();
                aboItemContent = parentItem.html();
                modalContent = $modal.html();
                $modal.addClass("link-abo-item");
                $modal.html(aboItemContent);
        
                const tagMove = $modal.find('.tag');
                const linkAboP = $modal.find('.link-abo-item p');
        
                var windowWidth = $j(window).width();
                var windowHeight = $j(window).height();
        
                var spaceAbove = parentItemPos.top;
                var spaceBelow = windowHeight - (parentItemPos.top + parentHeight);
                var spaceLeft = parentItemPos.left;
                var spaceRight = windowWidth - (parentItemPos.left + parentSize);
        
                var finalWidth = Math.min(windowWidth, windowWidth - 150); 
                var finalHeight = Math.min(windowHeight, windowHeight - 150); 
                var finalTop, finalLeft, finalRight;
        
                finalTop = 75;
        
                if (finalWidth / 2 &lt; spaceLeft &amp;&amp; finalWidth / 2 &lt; spaceRight) {
                  finalLeft = Math.max(
                    75,
                    parentItemPos.left - finalWidth / 2 + parentSize / 2
                  );
                } else {
                  finalLeft = windowWidth - finalWidth - 75;
                }
        
                if(windowWidth &lt; 768) {
                  finalTop = 0;
                  finalLeft = 0;
                  finalWidth = "100svw";
                  finalHeight = "100svh";
                }
        
                $modal.css({
                  transition: "none",
                  top: parentItemPos.top - 12,
                  left: parentItemPos.left - 12,
                  height: parentHeight + 24,
                  width: parentSize + 24,
                  overflow: "hidden",
                  boxShadow: "none",
                  borderRadius: "10px",
                  transform: "initial",
                  padding: "12px",
                });
        
                $j(tagMove).css({
                    position: "absolute",
                    top: "0px", 
                });
        
                $j(linkAboP).css({
                  opacity: 1,
                });
        
                setTimeout(function () {
                  $modal.css({
                    transition: "0.6s all ease-in-out",
                    top: finalTop, 
                    left: finalLeft, 
                    height: finalHeight,
                    width: finalWidth,
                    boxShadow: "0px 0px 10px rgba(0, 0, 0, 0.2)",
                    overflow: "none",
                    borderRadius: "10px",
                    padding: "34px 42px",
                  });
                }, 20);
        
                setTimeout(function () {
                    $j(tagMove).css({
                    transition: "0.3s all ease-in-out",
                    position: "absolute",
                    top: "80px", 
                  });
        
                  $j(linkAboP).css({
                    transition: "0.3s all ease-in-out",
                    opacity: 0
                  });
                }, 50);
        
                setTimeout(function () {
                  $modal.removeClass("link-abo-item");
                  $modal.html(modalContent);
                  $(".ametys-overlay-modal").addClass("active");
        
                  $j('.ametys-abonnements-list, .ametys-modal-header .ametys-modal-return').css({
                    transform: "scale(0)",
                    opacity: 0,
                  });
                  
                  $j('.ametys-abonnements-list').css({
                    height: (finalHeight-200) + "px",
                  });
                  
                    // Trap focus into modal
                    Accessibility.trapFocus($modal.get(0), true);
                    
                    // Close modal when ESCAPE key is pressed
                    $modal.on('keydown', closeNotificationsContentsOnEsc);
                }, 200);
        
                setTimeout(function () {
                  $j('.ametys-abonnements-list, .ametys-modal-header .ametys-modal-return').css({
                    transition: "0.4s all ease-in-out",
                    transform: "scale(1)",
                    opacity: 1
                  });
                }, 250);
                
                
            }
            
            // Close popup with all contents of a subscription on ESC key
            const closeNotificationsContentsOnEsc = (event) => {
                if (event.key === "Escape") {
                  closeNotificationsContents();
                }
            };
            
            // Close popup with all contents of a subscription with animation
            function closeNotificationsContents() {
                let $modal = $j(AmetysFront.UserNotifications.TAG_NOTIFICATIONS_CONTENTS_SELECTOR);
                
                const tagMove = $modal.find('.tag');
        
                $j(tagMove).css({
                  transition: "0.3s all ease-in-out",
                  position: "absolute",
                  top: "80px", 
                });
        
                $modal.css({
                  transition: "0.6s all ease-in-out",
                  top: parentItemPos.top - 12,
                  left: parentItemPos.left - 12,
                  height: parentHeight + 24,
                  width: parentSize + 24,
                  overflow: "hidden",
                  padding: "0px",
                  boxShadow: "none",
                  borderRadius: "10px",
                  padding: "12px",
                });
        
                setTimeout(function () {
                  $j(tagMove).css({
                    transition: "0.3s all ease-in-out",
                    position: "absolute",
                    top: "0", 
                  });
        
                  $j('.ametys-abonnements-list, .ametys-modal-header .ametys-modal-return').css({
                    transform: "scale(0)",
                    opacity: 0
                  });
        
                }, 50);
        
                setTimeout(function () {
                  $modal.addClass("link-abo-item");
                  $modal.html(aboItemContent);
                }, 300);
        
                setTimeout(function () {
                  $modal.html(modalContent);
                  $modal.removeClass("active");
                  $(".ametys-overlay-modal").removeClass("active");
                  
                  // Untrap focus 
                  Accessibility.untrapFocus($modal.get(0));
                  // Remove listener
                  $modal.off('keydown', closeNotificationsContentsOnEsc);
                  
                  openModalInvoker.focus();
                }, 600);
              }
            
            $j(document).ready(function () {
                 // Move popups and overlay to body
                $j(AmetysFront.UserNotifications.TAG_NOTIFICATIONS_CONTENTS_SELECTOR).appendTo(document.body);
                $j('.ametys-overlay-modal').appendTo(document.body);
                
                // Get notifications with 1 hour delay
                AmetysFront.UserNotifications.getUserTagContentNotifications(getTagNotificationsCb);
                
                setInterval(function() {
                    AmetysFront.UserNotifications.getUserTagContentNotifications(getTagNotificationsCb);
                }, <xsl:value-of select="$notificationCenterRefreshDelay"/>);
            }); 
        </script>
    </xsl:template>
    
    <!-- +
         | Popup and overlay for contents of a subscription 
         + -->
    <xsl:template name="notification-center-modal">
        <!-- Overlay -->
        <div class="ametys-overlay-modal" onclick="closeNotificationsContents()"></div>
        <!-- Modal -->
        <div class="ametys-modal ametys-modal-big" data-ametys-tag-notifications-contents="true" role="dialog" aria-modal="true" aria-labelledby="notification-center-modal-title">
          <button
            aria-label="skin.{$skin}:SKIN_MY_SUBSCRIPTIONS_POPUP_CLOSE"
            i18n:attr="aria-label"
            class="ametys-modal-close"
            onclick="closeNotificationsContents()">
            <svg aria-hidden="true" width="12px" height="12px" viewBox="0 0 12 12" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
                <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                    <g transform="translate(-1211, -209)" fill="#505767" fill-rule="nonzero">
                        <g transform="translate(516, 189)">
                            <g id="Top" transform="translate(0, 16)">
                                <g id="icon-close" transform="translate(695.1797, 4.1797)">
                                    <polygon id="Path"
                                        points="11.640625 1.171875 6.9921875 5.8203125 11.640625 10.46875 10.46875 11.640625 5.8203125 6.9921875 1.171875 11.640625 0 10.46875 4.6484375 5.8203125 0 1.171875 1.171875 0 5.8203125 4.6484375 10.46875 0"></polygon>
                                </g>
                            </g>
                        </g>
                    </g>
                </g>
            </svg>
          </button>

          <!-- Back to notifications -->
          <div class="ametys-modal-header">
            <button type="button" onclick="closeNotificationsContents()" class="ametys-modal-return">
              <i class="fas fa-arrow-left" aria-hidden="true"></i> <i18n:text i18n:key="SKIN_MY_SUBSCRIPTIONS_POPUP_BACK_TO_SUBSCRIPTIONS" i18n:catalogue="skin.{$skin}"/>
            </button>
          </div>

          <div class="ametys-modal-content">
            <div class="ametys-abonnements-modal">
                <div class="ametys-abonnements-modal-header">
                    <h1 id="notification-center-modal-title" class="tag" data-ametys-tag-notifications-contents-role="tag"></h1>
                    <span class="date" data-ametys-tag-notifications-contents-role="date"></span>
                </div>

                <ul class="ametys-abonnements-list" data-ametys-tag-notifications-contents-role="results">
                    <!-- contents will be inserted here -->
                </ul>
            </div>
          </div>
        </div>
    </xsl:template>
</xsl:stylesheet>