<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
		xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
		xmlns:xalan="http://xml.apache.org/xalan"
		xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
		xmlns:date="http://exslt.org/dates-and-times" extension-element-prefixes="date"
		exclude-result-prefixes="sitemap ametys">

	<xsl:import href="skin://templates/page/stylesheets/template.xsl" />
	<xsl:import href="plugin:front-edition://stylesheets/front-edition.xsl"/>
	
    <!-- To ignore UD transitional page in breadcrumb -->
    <xsl:variable name="ignoreTransitionPages">true</xsl:variable>
    
	<xsl:template name="additionnal-script" >
		<xsl:call-template name="ametys-front-edition-head">
			<xsl:with-param name="edition-mode-only" select="false()"/>
			<xsl:with-param name="editActionId" select="'42'"/> 
		</xsl:call-template>
	</xsl:template>
    
    <xsl:template name="additionnal-css">
        <style>
            .ametys-front-edition-content-toolbar {
                margin-bottom: 10px;
            }
            
            @media screen and (min-width: 1024px) {
                .ametys-front-edition-content-toolbar {
                    float: right;
                }
            }
        </style>
    </xsl:template>
    
    <xsl:template name="zone-item-before">
      <xsl:param name="position"/>
      <xsl:param name="count"/>
      <xsl:param name="zone-name"/>
      <xsl:param name="level"/>
      <xsl:param name="inherited"/>
      <xsl:param name="id"/>
      <xsl:param name="type"/>
      <xsl:param name="content-id"/>
      <xsl:param name="service"/>
      <xsl:param name="content-type"/>
      
      <xsl:if test="$type = 'CONTENT' and $zone-name = 'default'">
          <xsl:call-template name="ametys-front-edition-content-toolbar">
            <xsl:with-param name="content-id" select="$content-id"/>
            <xsl:with-param name="zone-name" select="$zone-name"/>
            <xsl:with-param name="zone-item-id" select="@id"/>
            <xsl:with-param name="edition-mode-only" select="false()"/>
            <xsl:with-param name="items">[{type: 'edit', label: 'Modifier la fiche complète'}]</xsl:with-param>
          </xsl:call-template>
      </xsl:if>
    </xsl:template>
	
	<xsl:template name="ametys-front-edition-page-toolbar"/>
	
    <xsl:template match="page[starts-with(@sitemap:id, 'udtransitional://')]" mode="breadcrumb">
    
        <xsl:if test="$ignoreTransitionPages != 'true'">
            <li class="ametys-breadcrumb__item">
                <xsl:if test="$conf-microformat='true'">
                   <xsl:attribute name="itemscope">itemscope</xsl:attribute>
                   <xsl:attribute name="itemtype">http://data-vocabulary.org/Breadcrumb</xsl:attribute>
               </xsl:if>
                   
               <xsl:call-template name="breadcrumb-separator"/>
               
               <xsl:choose>
                    <xsl:when test="not(@sitemap:current)">
                        <a href="{resolver:resolve('page', @sitemap:id)}" class="ametys-breadcrumb__link">
                           <xsl:if test="$conf-microformat='true'">
                               <xsl:attribute name="itemprop">url</xsl:attribute>
                           </xsl:if>
                           <xsl:value-of select="@sitemap:long-title" />
                       </a>
                   </xsl:when>
                   <xsl:otherwise>
                        <span>
                           <xsl:if test="$conf-microformat='true'">
                               <xsl:attribute name="itemprop">title</xsl:attribute>
                           </xsl:if>
                           <xsl:value-of select="@sitemap:long-title" />
                       </span>
                </xsl:otherwise>
                </xsl:choose>
            </li>
        </xsl:if>
        
        <xsl:apply-templates select="page[@sitemap:in-path = 'true']" mode="breadcrumb"/>
    
    </xsl:template>
</xsl:stylesheet>