<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:exsl="http://exslt.org/common"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                extension-element-prefixes="exsl ametys resolver">
    
    <xsl:import href="plugin:forms://pages/services/common/dashboard.xsl"/>
    
    <xsl:variable name="date-time-format" select="ametys:translate(concat('skin.', $skin, ':SKIN_DATE_TIME_FORMAT'), $lang)"></xsl:variable>
    
    <xsl:template name="dashboard-dialog-js">
        <script type="text/javascript" src="{ametys:pluginResourceURL('forms', 'js/DashboardHelper.js')}"></script>
        
        <script type="text/javascript">
            const hidePopupOnEscape = (event) => {
                if (event.key === "Escape") {
                  onHideDialog_<xsl:value-of select="$uniqueId"/>();
                }
            };
            
            var openPopupEl_<xsl:value-of select="$uniqueId"/> = null;
            
            function onShowEntry_<xsl:value-of select="$uniqueId"/>(formId, entryId, formLabel, el)
            {
                var uniqueId = '<xsl:value-of select="$uniqueId" />';
                var $dialog = $j(`[data-dashboard-entry-answers='${uniqueId}']`);
                $dialog.show();
                $j(`[data-dashboard-popup-overlay='${uniqueId}']`).show();
                
                // Trap focus into modal
                Accessibility.trapFocus($dialog.get(0), true);
                // Close modal when ESCAPE key is pressed
                $dialog.get(0).addEventListener('keydown', hidePopupOnEscape);
                
                openPopupEl_<xsl:value-of select="$uniqueId"/> = el;
            }
            
            function onHideEntry_<xsl:value-of select="$uniqueId"/>()
            {   
                var uniqueId = '<xsl:value-of select="$uniqueId" />';
                var $dialog = $j(`[data-dashboard-entry-answers='${uniqueId}']`);
               
                onHideDialog_<xsl:value-of select="$uniqueId"/>($dialog);
            }
            
            function onHideHistory_<xsl:value-of select="$uniqueId"/>(btn)
            {
                var uniqueId = '<xsl:value-of select="$uniqueId" />';
                
                var $dialog = $j(btn).closest(`[data-dashboard-popup='${uniqueId}']`);
                onHideDialog_<xsl:value-of select="$uniqueId"/>($dialog);
            }
            
            function onHideDialog_<xsl:value-of select="$uniqueId"/>($dialog)
            {
                var uniqueId = '<xsl:value-of select="$uniqueId" />';
                $dialog = $dialog || $j(`[data-dashboard-popup='${uniqueId}']:visible`);
                
                // Hide dialog
                $dialog.hide();
                $j(`[data-dashboard-popup-overlay='${uniqueId}']`).hide();
                
                // Untrap focus into modal
                if ($dialog.length)
                {
                    Accessibility.untrapFocus($dialog.get(0));
                    $dialog.get(0).removeEventListener('keydown', hidePopupOnEscape);
                }
                
                // Focus element that opened the popup
                if (openPopupEl_<xsl:value-of select="$uniqueId"/>)
                {
                    $j(openPopupEl_<xsl:value-of select="$uniqueId"/>).focus();
                    openPopupEl_<xsl:value-of select="$uniqueId"/> = null;
                }
            }
            
            function onShowHistory_<xsl:value-of select="$uniqueId"/>(formId, entryId, el)
            {
                var uniqueId = '<xsl:value-of select="$uniqueId" />';
                var $dialog = $j(`[data-dashboard-history-dialog='${uniqueId}-${formId}-${entryId}']`);
                $dialog.show();
                $j(`[data-dashboard-popup-overlay='${uniqueId}']`).show();
                
                // Trap focus into modal
                Accessibility.trapFocus($dialog.get(0), true);
                // Close modal when ESCAPE key is pressed
                $dialog.get(0).addEventListener('keydown', hidePopupOnEscape);
                
                openPopupEl_<xsl:value-of select="$uniqueId"/> = el;
            }
            
            function onShowError_<xsl:value-of select="$uniqueId"/>(title, error)
            {
                var uniqueId = '<xsl:value-of select="$uniqueId" />';
                var $dialog = $j(`[data-dashboard-popup-error='${uniqueId}']`);
                $j(`[data-dashboard-popup-error-message='${uniqueId}']`).text(error || title);
                $j(`[data-dashboard-popup-error-title='${uniqueId}']`).text(title || "<i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_ERROR_TITLE" i18n:catalogue="plugin.forms"/>");
                $dialog.show();
                $j(`[data-dashboard-popup-overlay='${uniqueId}']`).show();
                
                // Trap focus into modal
                Accessibility.trapFocus($dialog.get(0), true);
                // Close modal when ESCAPE key is pressed
                $dialog.get(0).addEventListener('keydown', hidePopupOnEscape);
            }
            
            function onHideError_<xsl:value-of select="$uniqueId"/>(actionId)
            {
                var uniqueId = '<xsl:value-of select="$uniqueId" />';
                var $dialog = $j(`[data-dashboard-popup-error='${uniqueId}']`);
                onHideDialog_<xsl:value-of select="$uniqueId"/>($dialog);
            }
            
            function onShowDashboard_<xsl:value-of select="$uniqueId"/>()
            {
                var uniqueId = '<xsl:value-of select="$uniqueId" />';
                // remove old popups
                $j(`body > [data-dashboard-popup='${uniqueId}']`).remove();
                // move new popups to body
                $j(`[data-dashboard-popup='${uniqueId}']`).appendTo(document.body);
            }
            
            function onHideActionDialog_<xsl:value-of select="$uniqueId"/>(actionId)
            {
                onHideDialog_<xsl:value-of select="$uniqueId"/>();
            }
            
            function onShowActionDialog_<xsl:value-of select="$uniqueId"/>(actionName, formId, entryId, actionId, el)
            {
                var uniqueId = '<xsl:value-of select="$uniqueId" />';
                var $dialog = $j(`[data-dashboard-${actionName}-dialog='${formId}-${entryId}-${actionId}']`);
                $dialog.show();
                $j(`[data-dashboard-popup-overlay='${uniqueId}']`).show();
                
                // Trap focus into modal
                Accessibility.trapFocus($dialog.get(0), true);
                // Close modal when ESCAPE key is pressed
                $dialog.get(0).addEventListener('keydown', hidePopupOnEscape);
                
                openPopupEl_<xsl:value-of select="$uniqueId"/> = el;
            }
            
            $j().ready(function() {
                // Move popups to body
                $j("*[data-dashboard-popup = '<xsl:value-of select="$uniqueId" />']").appendTo(document.body);
            });
        </script>
    </xsl:template>
    
    <xsl:template name="dashboard">
        <xsl:call-template name="dashboard-table" />

        <xsl:apply-templates select="answer" mode="history"/>
        
        <!-- Edit submitter action that need dialog -->
        <xsl:apply-templates select=".//action[@type='edit-by-submitter']" mode="action-dialog"/>
        
        <xsl:call-template name="show-answer-popup" />

        <xsl:call-template name="show-error-popup" />

        <!-- background overlay for popups -->
        <div class="dashboard-popup-overlay" data-dashboard-popup-overlay="{$uniqueId}" style="display: none;" onclick="onHideDialog_{$uniqueId}()"></div>
    </xsl:template>
    
    <xsl:template name="show-answer-popup">
        <div class="dashboard-popup dashboard-entry-answers" data-dashboard-popup="{$uniqueId}" data-dashboard-entry-answers="{$uniqueId}" style="display:none;" role="dialog" aria-modal="true" aria-labelledby="dashboard-entry-answers-title-{$uniqueId}">
            <button type="button" onclick="onHideEntry_{$uniqueId}()" class="close" title="skin.{$skin}:SKIN_SERVICES_FORMS_DASHBOARD_CLOSE" i18n:attr="title"><i class="fas fa-times" aria-hidden="true"></i></button>
            <h2 class="header" id="dashboard-entry-answers-title-{$uniqueId}"  data-dashboard-entry-values-title="{$uniqueId}" data-dashboard-title-attr="true"></h2>
            
            <div class="innercontent" data-dashboard-entry-values="{$uniqueId}">
                <!-- Rendered by entry-information.xsl -->
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="show-error-popup">
        <div class="dashboard-popup dashboard-popup-error" data-dashboard-popup="{$uniqueId}" data-dashboard-popup-error="{$uniqueId}" style="display:none;" role="dialog" aria-modal="true" aria-labelledby="dashboard-popup-error-{$uniqueId}">
            <h2 class="header" id="dashboard-popup-error-{$uniqueId}" data-dashboard-popup-error-title="{$uniqueId}"></h2>            
            
            <div class="innercontent" data-dashboard-popup-error-message="{$uniqueId}"/>
            
            <div class="bottom">
                <button class="btn" onclick="onHideError_{$uniqueId}()">
                    <span><i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_OK_BUTTON" i18n:catalogue="plugin.forms"/></span>
                </button>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template match="answer" mode="history">
        <div class="dashboard-popup" data-dashboard-popup="{$uniqueId}" data-dashboard-history-dialog="{$uniqueId}-{@formId}-{@id}" style="display:none;" role="dialog" aria-modal="true" aria-labelledby="dashboard-popup-header-{generate-id()}">
            <button type="button" onclick="onHideHistory_{$uniqueId}(this)" class="close" title="skin.{$skin}:SKIN_SERVICES_FORMS_DASHBOARD_CLOSE" i18n:attr="title"><i class="fas fa-times" aria-hidden="true"></i></button>
            <h2 class="header" id="dashboard-popup-header-{generate-id()}"><i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_HISTORY" i18n:catalogue="plugin.forms"/><span> / <xsl:value-of select="@formLabel"/></span></h2>
            
            <div class="innercontent"> 
                <ul class="{$cssPrefix}__historysteps">
                    <xsl:apply-templates select="step" mode="history"/>
                </ul>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template match="action[@type='edit-by-submitter']" mode="action-dialog">
        <div class="dashboard-popup dashboard-edit" data-dashboard-popup="{$uniqueId}" data-dashboard-edit-dialog="{../@formId}-{../@id}-{@id}" style="display:none;" role="dialog" aria-modal="true" aria-labelledby="dashboard-popup-header-{generate-id()}">
            <h2 class="header" id="dashboard-popup-header-{generate-id()}"><xsl:value-of select="."/></h2>
            
            <div class="innercontent">
                <div data-dashboard-edit-values="{../@formId}-{../@id}-{@id}">
                    <!-- Rendered by edit.xsl --> 
                </div>
                
                <xsl:apply-templates select="." mode="action-dialog-loader"/>
            </div>
            
            <div class="bottom">
                <button class="btn" onclick="DashboardHelper.editFormEntry('{$uniqueId}', '{../@formId}', '{../@id}', '{@id}')">
                    <span><i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_OK_BUTTON" i18n:catalogue="plugin.forms"/></span>
                </button>
                <button class="btn" onclick="onHideActionDialog_{$uniqueId}()">
                    <span><i18n:text i18n:key="PLUGINS_FORMS_SERVICE_DASHBOARD_CANCEL_BUTTON" i18n:catalogue="plugin.forms"/></span>
                </button>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template match="action" mode="action-dialog-loader">
        <div class="loading" data-ametys-dashboard-dialog-role="loading" style="display: none"><span aria-hidden="true" class="fas fa-spinner"></span></div>
    </xsl:template>
    
    <xsl:template match="step" mode="description">
        <span class="{$cssPrefix}__historystep_desc">
            <span><xsl:value-of select="description/label" /></span>
        </span>
    </xsl:template>
    
    <xsl:template match="step" mode="date">
        <div class="{$cssPrefix}__historystep_date">
            <i class="material-icons" aria-hidden="true">access_time</i>
            
            <span class="date">
                <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="{$date-time-format}" value="{@date}"/>
            </span>
        </div>
    </xsl:template>
    
    <xsl:template match="step" mode="icon"/>
</xsl:stylesheet>
