<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
		xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
		xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
		xmlns:orgUnit="org.ametys.plugins.userdirectory.transformation.xslt.OrgUnitXSLTHelper"
		xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
		xmlns:escaper="org.apache.commons.lang.StringEscapeUtils"
		xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
		xmlns:xalan="http://xml.apache.org/xalan"
		extension-element-prefixes="ametys orgUnit resolver sitemap">
		
	<xsl:import href="plugin:web://pages/services/search-pages/search_3.3.xsl"/>
	
<!--	<xsl:variable name="sitemap" select="ametys:sitemap(1)"/>-->
	
	<xsl:template name="common-service-head-css">
    	<link rel="stylesheet" href="{ametys:skinURL('zones/search-results/scss/main.css')}" media="screen, print, handheld"/>
		<link rel="stylesheet" href="{ametys:skinURL('zones/search-results/scss/print.css')}" media="print"/>
    </xsl:template> 
    
    <xsl:template name="common-service-body-nonempty-content-title">
    	<xsl:if test="$template != 'index'">
	        <xsl:call-template name="common-service-body-nonempty-content-title-content">
	            <xsl:with-param name="title" select="$header"/>
	        </xsl:call-template>    
	    </xsl:if>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-content">
    	<xsl:choose>
	        <xsl:when test="$search-mode = 'criteria-and-results' or $search-mode = 'criteria-or-results'" >
	            <xsl:call-template name="form-result"/>
	            <xsl:call-template name="form-result-js"/>
	        </xsl:when>
	        <xsl:otherwise>
	        	<xsl:call-template name="aside"/>
	        </xsl:otherwise>
        </xsl:choose>
    </xsl:template> 	
	
    <xsl:template name="aside">
   		<xsl:if test="$rendering-context = 'back'">
            <script type="text/javascript">
                function submitBO(pageId, title, href) 
                {
                    var Ext = window.parent.Ext;
                    Ext.MessageBox.show({
                           title:"<i18n:text i18n:key="FRONT_MODULE_SEARCH_BO_TITLE" i18n:catalogue="plugin.web"/>",
                           msg: "<i18n:text i18n:key="FRONT_MODULE_SEARCH_BO_MSG" i18n:catalogue="plugin.web"/> &lt;a href='" + href.replace(/'/g, "&amp;apos;") + "'&gt;" + title + "&lt;/a&gt;.",
                           buttons: Ext.MessageBox.OK,
                           icon: Ext.MessageBox.INFO
                        });
                }
            </script>
        </xsl:if>
		<form method="post" class="card shadow-none p-0" name="{$search-form-id}" id="{$search-form-id}">
			<xsl:if test="$template ='index'"><xsl:attribute name="class">card d-print-none rounded mb-4 <xsl:value-of select="$override-card-styles"/></xsl:attribute></xsl:if>
			
            <xsl:variable name="href"><xsl:value-of select="resolver:resolve('page', $search-page)"/></xsl:variable>
            <xsl:choose>
                <xsl:when test="$href = ''">
                    <xsl:attribute name="action"><xsl:value-of select="concat($site-uri-prefix, '/', /search/url)"/>#nav</xsl:attribute>
                </xsl:when>
                <xsl:when test="$rendering-context != 'back'">
                    <xsl:attribute name="action"><xsl:value-of select="$href"/>#nav</xsl:attribute>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:variable name="title"><xsl:value-of select="ametys:pageTitle($search-page)"/></xsl:variable>
                    <xsl:attribute name="action">#</xsl:attribute>
                    <xsl:attribute name="onSubmit">submitBO('<xsl:value-of select="$search-page"/>', '<xsl:value-of select="ametys:escapeJS($title)"/>', '<xsl:value-of select="ametys:escapeJS($href)"/>');return false;</xsl:attribute>
                </xsl:otherwise>
            </xsl:choose>
            
            <xsl:if test="$template = 'index'">
            	<header class="card-header">
					<h1 class="card-title">
						<xsl:call-template name="card-header-icon"/>
						<xsl:choose>
				            <xsl:when test="$header != ''">
				              	<xsl:value-of select="$header"/>
				            </xsl:when>
				            <xsl:otherwise>
				            	<i18n:text i18n:key="SKIN_USER_DIRECTORY_SEARCH" i18n:catalogue="skin.{$skin}"/>
				            </xsl:otherwise>
				        </xsl:choose>
					</h1>
				</header>
			</xsl:if>
			
			<xsl:if test="$facets">
                <noscript>
                    <div class="facets-noscript">
                        <i18n:text i18n:catalogue="plugin.web" i18n:key="FRONT_MODULE_SEARCH_FACETS_NOSCRIPT"/>
                    </div>
                    <div>
                        <input type="hidden" name="force-criteria-display" value="true"/>
                    </div>
                </noscript>
            </xsl:if>
            
			<div class="">
				<xsl:attribute name="class">
					<xsl:choose>
						<xsl:when test="$template = 'index'">card-body py-0</xsl:when>
						<xsl:otherwise>card-body px-0</xsl:otherwise>
					</xsl:choose>
				</xsl:attribute>
				<xsl:call-template name="form-search"/>
			</div>
			<footer class="card-footer d-flex flex-column flex-xl-row justify-content-end bg-transparent">
				<xsl:variable name="orgPageId" select="ametys:findPagesIdsByTag('ORGANIZATION_CHART')"/> 
				<xsl:if test="$orgPageId">
					<a class="btn btn-grey btn-sm d-block d-xl-inline-block mb-2 mb-xl-0" href="{resolver:resolve('page', $orgPageId/@id)}">
						<i18n:text i18n:key="SKIN_SEARCH_ORGANIZATION" i18n:catalogue="skin.{$skin}"/>
					</a>
				</xsl:if>
				<xsl:call-template name="common-utils-input-submit">
	               <xsl:with-param name="class-name">search</xsl:with-param>
	               <xsl:with-param name="i18nkey" select="'plugin.web:PLUGINS_WEB_SERVICE_SEARCH_VIEW_BUTTON_OK'" />                                
	           </xsl:call-template>
			</footer>
		</form>	
    </xsl:template>
    
    <xsl:template name="card-header-icon">
    	<span class="card-header__icon material-icons recent_actors"></span>
    </xsl:template>
    
    <xsl:template name="form-search">	
           <input type="hidden" name="submit-form">
               <xsl:if test="/search/group-id and normalize-space(/search/group-id) != ''">
                   <xsl:attribute name="value"><xsl:value-of select="/search/group-id"/></xsl:attribute>
               </xsl:if>
           </input>
           <xsl:if test="/search/zone-item/@id and $search-page = ''">
               <input type="hidden" name="zone-item-id" value="{/search/zone-item/@id}"/>
           </xsl:if>
           <!-- Metadata -->
           <xsl:call-template name="form-search-by-metadata"/>
           
           <!-- Textfield -->
<!--            <xsl:call-template name="form-search-element-keywords"/> -->
           
           <!-- All words -->
           <xsl:call-template name="form-search-element-allwords"/>
		
           <!-- Exact wording -->
           <xsl:call-template name="form-search-element-exactwording"/>
		
			<!-- No words -->
           <xsl:call-template name="form-search-element-nowords"/>
		
           <!-- Pages -->
           <xsl:call-template name="form-search-element-pages"/>            
		
           <!-- Content types display -->
           <xsl:call-template name="form-search-element-contenttypesdisplay"/>
           
           <!-- Tags category -->
			<xsl:call-template name="form-search-element-tags"/>

           <!-- Multisite -->
           <xsl:call-template name="form-search-element-multisite"/>
           
           <!-- Dates -->
           <xsl:call-template name="form-search-element-dates"/>
	</xsl:template>
    
    <!-- Keywords -->
    <xsl:template name="form-search-element-keywords">
    	<xsl:if test="/search/form/fields/textfield">
	        <div class="form-group">
<!-- 	            <div class="label"><label for="search-input-{$uniqueId}"><i18n:text i18n:key="FRONT_MODULE_SEARCH_KEYWORDS" i18n:catalogue="plugin.web"/></label></div> -->
                <input id="search-input-{$uniqueId}-bis" type="text" name="textfield-bis" value="{/search/form/values/textfield}" placeholder="plugin.web:FRONT_MODULE_SEARCH_KEYWORDS" i18n:attr="placeholder">
                	<xsl:attribute name="class">form-control<xsl:if test="$template != 'index'"> form-control--warning</xsl:if></xsl:attribute>
                	<xsl:attribute name="onkeyup">onKeywordKeyup()</xsl:attribute>
                </input>
                <input id="search-input-{$uniqueId}" type="hidden" name="textfield" value="{/search/form/values/textfield}"/>
                <xsl:if test="/search/illegal-textfield">
                    <p class="error"><i18n:text i18n:key="PLUGINS_WEB_SERVICE_FRONT_SEARCH_INVALID_TEXTFIELD" i18n:catalogue="plugin.web"/></p>
                </xsl:if>
	        </div>
	        
	        <script type="text/javascript">
	           function onKeywordKeyup()
	           {
	               var value = $j("#search-input-<xsl:value-of select="$uniqueId" />-bis").val();
	               if (value != "")
	               {
	                   value = value + "*";
	               }
	               $j("#search-input-<xsl:value-of select="$uniqueId" />").val(value);
	           }
	           
	           $j( document ).ready(function()
	           {
	               var value = $j("#search-input-<xsl:value-of select="$uniqueId" />").val();
	               value = value.substring(0, value.length - 1);
	               $j("#search-input-<xsl:value-of select="$uniqueId" />-bis").val(value);
	           });
	       </script>
	    </xsl:if>  
    </xsl:template>
    
    <!-- Search by text metadata   -->
    <xsl:template name="form-search-by-metadata-text">
    	<xsl:param name="value" />
    	<div class="form-group">
<!--        		<div class="label"><label for="search-metadata-{translate(@name, '/', '-')}-{$uniqueId}"><xsl:value-of select="label"/></label></div> -->
         		<input id="search-metadata-{translate(@name, '/', '-')}-{$uniqueId}-bis" type="text" name="metadata-{translate(@name, '/', '.')}-bis" value="{$value}" placeholder="{label}">
         			<xsl:attribute name="class">form-control<xsl:if test="$template != 'index'"> form-control--warning</xsl:if></xsl:attribute>
         			<xsl:attribute name="onkeyup">onKeyup('<xsl:value-of select="translate(@name, '/', '-')" />')</xsl:attribute>
         		</input>
         		<input id="search-metadata-{translate(@name, '/', '-')}-{$uniqueId}" type="hidden" name="metadata-{translate(@name, '/', '.')}" value="{$value}" class="text">
                </input>
   		</div>
   		
   		<script type="text/javascript">
           function onKeyup(name)
           {
               var value = $j("#search-metadata-" + name + "-<xsl:value-of select="$uniqueId" />-bis").val();
               if (value != "")
               {
                   value = value + "*";
               }
               $j("#search-metadata-" + name + "-<xsl:value-of select="$uniqueId" />").val(value);
           }
           
           $j( document ).ready(function()
           {
               var value = $j("#search-metadata-<xsl:value-of select="translate(@name, '/', '-')" />-<xsl:value-of select="$uniqueId" />").val();
               value = value.substring(0, value.length - 1);
               $j("#search-metadata-<xsl:value-of select="translate(@name, '/', '-')" />-<xsl:value-of select="$uniqueId" />-bis").val(value);
           });
       </script>
    </xsl:template>
    
    <!-- Search by enumerated metadata   -->
    <xsl:template name="form-search-by-metadata-enum">
    	<xsl:param name="value" />
    	
    	<xsl:variable name="name" select="@name"/>
    	<div class="form-group">
<!--     		<div class="label"><label for="search-metadata-{translate(@name, '/', '-')}-{$uniqueId}"><xsl:value-of select="label"/></label></div> -->
    		
       		<select id="search-metadata-{translate(@name, '/', '-')}-{$uniqueId}" name="metadata-{translate(@name, '/', '.')}">
       			<xsl:attribute name="class">form-control<xsl:if test="$template != 'index'"> form-control--warning</xsl:if></xsl:attribute>
       			<xsl:if test="$facets">
       				<xsl:attribute name="onchange">updateFormLists('<xsl:value-of select="concat($uri-prefix, $search-criteria-url)"/>', '<xsl:value-of select="$site"/>', '<xsl:value-of select="$lang"/>', '<xsl:value-of select="$search-form-id"/>', '<xsl:value-of select="$uniqueId"/>', '<xsl:value-of select="/search/zone-item/@id"/>')</xsl:attribute>
       			</xsl:if>
       			
       			<option value="">
       				<i18n:text i18n:key="FRONT_MODULE_SEARCH_ALL_OPTION" i18n:catalogue="plugin.web"/>
       				<xsl:if test="$facets and /search/form/facets/facet[@name = $name]">
       					<xsl:text> </xsl:text>(<xsl:value-of select="/search/form/facets/facet[@name = $name]/@total"/>)
       				</xsl:if>
       			</option>
       			<xsl:choose>
       				<xsl:when test="$facets">
       					<xsl:for-each select="enumeration/item">
       						<xsl:sort select="label" />
                             <xsl:if test="/search/form/facets/facet[@name = $name]/*[@value = current()/@value]/@count != '0'">
         					<option value="{escaper:escapeXml(@value)}">
	          				<xsl:if test="escaper:escapeXml(@value) = $value"><xsl:attribute name="selected">true</xsl:attribute></xsl:if>
	          				<xsl:value-of select="label"/>
          					<xsl:text> </xsl:text>
          					<xsl:choose>
          						<xsl:when test="/search/form/facets/facet[@name = $name]/*[@value = current()/@value]">
          							(<xsl:value-of select="/search/form/facets/facet[@name = $name]/*[@value = current()/@value]/@count"/>)
          						</xsl:when>
          						<xsl:otherwise>(0)</xsl:otherwise>
          					</xsl:choose>
          				</option>
         				</xsl:if>
        				</xsl:for-each>
       				</xsl:when>
       				<xsl:otherwise>
       					<xsl:for-each select="enumeration/item">
       					    <xsl:sort select="label" />
        					<option value="{@value}">
          				<xsl:if test="@value = $value"><xsl:attribute name="selected">true</xsl:attribute></xsl:if>
          				<xsl:value-of select="label"/>
         				</option>
         			</xsl:for-each>
       				</xsl:otherwise>
       			</xsl:choose>
       		</select>
       	</div>
    </xsl:template>
    
    <xsl:template name="form-result">
		<xsl:variable name="raw-is-title-visible">
            <xsl:call-template name="common-service-body-nonempty-content-title"/>
        </xsl:variable>
        <xsl:variable name="level">
            <xsl:choose>
                <xsl:when test="string-length($raw-is-title-visible) &gt; 0">2</xsl:when>
                <xsl:otherwise>1</xsl:otherwise>
            </xsl:choose>
        </xsl:variable> 
        
		<form action="{$site-uri-prefix}/{/search/url}#nav" method="post" class="search-result">
			<xsl:call-template name="form-search-hidden"/>
		
			<a name="nav"/>
			
			<xsl:if test="(/search/form/fields/content-types-choice = 'filter' or /search/form/fields/content-types-choice = 'checkbox-filter') and /search/content-types/*/hits">
				<xsl:call-template name="content-types-filter"/>
			</xsl:if>

			<xsl:if test="/search/hits/hit|/search/content-types/*[@current = 'true']/hits/hit">
	               <xsl:if test="/search/form/values/textfield != ''">
	                   <xsl:call-template name="results-for"/>
	               </xsl:if>
				
	               <xsl:call-template name="results-sort"/>
			</xsl:if>
		</form>	
       
		<xsl:choose>
			<xsl:when test="/search/hits/hit|/search/content-types/*[@current = 'true']/hits/hit">
				<xsl:call-template name="hits"/>
				<xsl:call-template name="pagination"/>
			</xsl:when>
			<xsl:when test="/search/form/values and not(/search/search/illegal-textfield)">
                <xsl:call-template name="no-result"/>  
			</xsl:when>
		</xsl:choose>
	</xsl:template>
    
    <xsl:template name="results-for"/>
    <xsl:template name="results-sort"/>
    
    <xsl:template name="hits">
        <ul class="ametys-search-results">
			<xsl:for-each select="/search/hits/hit|/search/content-types/*[@current = 'true']/hits/hit">
				<xsl:choose>
					<xsl:when test="type = 'resource'">
                        <xsl:call-template name="hit-resource"/>
					</xsl:when>
					<xsl:otherwise>
                        <xsl:call-template name="hit-page"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:for-each>
   		</ul>
	</xsl:template>
    
    
    <xsl:template name="hit-page">
        <li class="ametys-search-results__item">
        	<a title="{title}" class="ametys-search-results__link">
				<xsl:attribute name="href"><xsl:call-template name="hit-page-title-href" /></xsl:attribute>
	            <article class="ametys-search-results__content">
	            	<div class="ametys-search-results__img">
            			<xsl:choose>
							<xsl:when test="content/illustration/image/@filename != ''">
								<xsl:variable name="image" select="content/illustration/image"/>
								<img alt="{content/illustration/alt-text}" src="{resolver:resolveCroppedImage($image/@type, concat(content/illustration/image/@path, '?contentId=', content/@id), '80', '80')}" />
					        </xsl:when>
					        <xsl:when test="content/firstname">
					        	<xsl:value-of select="substring(content/firstname, 1, 1)"/>
					        </xsl:when>
					        <xsl:otherwise>
					        	<xsl:value-of select="substring(content/title, 1, 1)"/>
					        </xsl:otherwise>
					    </xsl:choose>
                	</div>
	            
			        <section class="ametys-search-results__middle">
						<h2 class="ametys-search-results__title">
           					<xsl:value-of select="content/firstname"/>
           					<xsl:text> </xsl:text>
           					<xsl:value-of select="content/lastname"/>
	           			</h2>
						<xsl:call-template name="function"/>
					</section>
				
					<section class="ametys-search-results__right">
						<ul class="ametys-search-results-contacts">
							<xsl:if test="content/phone or content/mobilePhone">
							<li class="ametys-search-results-contacts__item">
								<xsl:choose>
									<xsl:when test="content/mobilePhone">
										<span class="ametys-search-results-contacts__item-icon material-icons smartphone"></span>
										<xsl:value-of select="content/mobilePhone"/>
									</xsl:when>
									<xsl:otherwise>
										<span class="ametys-search-results-contacts__item-icon material-icons phone"></span>
										<xsl:value-of select="content/phone"/>
									</xsl:otherwise>
								</xsl:choose>
							</li>
							</xsl:if>
							<xsl:if test="content/mail">
								<li class="ametys-search-results-contacts__item">
									<span class="ametys-search-results-contacts__item-icon material-icons mail_outline"></span>
									<xsl:value-of select="substring-before(content/mail, '@')"/>
									<span style="position: absolute; left: -1000px; top: -1000px;"><xsl:text> </xsl:text></span>
									<xsl:text>@</xsl:text>
									<span style="position: absolute; left: -1000px; top: -1000px;"><xsl:text> </xsl:text></span>
									<xsl:value-of select="substring-after(content/mail, '@')"/>
								</li>
							</xsl:if>
						</ul>
					</section>
			
					<span class="ametys-search-results__icon material-icons keyboard_arrow_down"></span>
				</article>
			</a>
        </li>
    </xsl:template>
    
    <xsl:template name="function">
    	<xsl:if test="count(content/orgunits) > 0 or content/servcie or content/role">
			<h3 class="ametys-search-results__subtitle">
				<xsl:if test="count(content/orgunits) > 0">
					<xsl:for-each select="content/orgunits">
                    	<xsl:value-of select="@title" />
		            </xsl:for-each>
		        </xsl:if>
		        <xsl:call-template name="service"/>
			    <xsl:call-template name="role"/>
			</h3>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="role">
		<xsl:if test="content/role">
			<xsl:if test="count(content/orgunits) > 0 or content/service">
				<xsl:text> / </xsl:text>
			</xsl:if>
			<xsl:value-of select="content/role"/>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="service">
		<xsl:if test="content/service">
			<xsl:if test="count(content/orgunits) > 0">
				<xsl:text> / </xsl:text>
			</xsl:if>
			<xsl:value-of select="content/service"/>
		</xsl:if>
	</xsl:template>
	
	
	<!-- +
		 | Template for page navigation
		 + -->
	<xsl:template name="pagination">
		<form id="reload" method="post" action="{$site-uri-prefix}/{/search/url}#nav" accept-charset="UTF-8">
			<div class="pagination">
	            <xsl:call-template name="pagination-input-hidden"/>
	            
                <xsl:call-template name="common-utils-pagination-results">
                    <xsl:with-param name="i18nkey" select="'plugin.web:FRONT_MODULE_SEARCH_RESULTS'" />
                    <xsl:with-param name="pagination-start" select="$pagination/@start + 1" />
                    <xsl:with-param name="pagination-end" select="$pagination/@end" />
                    <xsl:with-param name="hits-total" select="$pagination/../hits/@total" />
                </xsl:call-template>
            
                <xsl:call-template name="common-utils-pagination">
                    <xsl:with-param name="nbPages" select="count($pagination/page)"/>
                    <xsl:with-param name="current-page" select="xalan:nodeset($pagination/page[@start = ../@start])"/>
                </xsl:call-template>            
			</div>
		</form>
	</xsl:template>
	
</xsl:stylesheet>		
