<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:math="java.lang.Math"
                exclude-result-prefixes="resolver math ametys">
                
    <xsl:import href="common/home-card-search.xsl"/>
    
    <xsl:template name="common-service-head-css">    
         <link rel="stylesheet" href="{ametys:skinURL('zones/index-offres/scss/main.css')}" />
    </xsl:template>
    
    <xsl:template name="hits-class-attribute">
        <xsl:attribute name="class">ametys-offres</xsl:attribute>
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.ContentSaxer']" mode="class-attribute">
        <xsl:text/>ametys-offres__item<xsl:text> </xsl:text>
    </xsl:template>           
    
    <xsl:template name="header-default">
        <i18n:text i18n:key="SKIN_JOB_OFFERS" i18n:catalogue="skin.{$skin}"/>
    </xsl:template>
    
    <xsl:template name="card-header-icon">
        <i class="card-header__icon material-icons">directions_walk</i>
    </xsl:template>
    
    <xsl:template name="link-default-title">
        <i18n:text i18n:key="SKIN_SEARCH_OFFERS" i18n:catalogue="skin.{$skin}"/>
   </xsl:template>
   
   <xsl:template name="hit">
        <li>
            <xsl:call-template name="hit-attributes"/>
            <xsl:apply-templates select="content/html" mode="content"/>
        </li>
    </xsl:template>
    
    <xsl:template match="html" mode="content">
        <xsl:apply-templates select="." mode="badge"/>
        <xsl:apply-templates select="." mode="title"/>
        <xsl:apply-templates select="." mode="closing-date"/>
        <xsl:apply-templates select="." mode="place"/>
    </xsl:template>
    
    <xsl:template match="html" mode="badge">
        <!-- Sample -->
        <!-- <xsl:variable name="direction" select="head/meta[@name='direction;title']/@content"/>
        <xsl:if test="$direction != ''">
            <span class="ametys-offres__item_badge">
                <xsl:value-of select="$direction"/>
            </span>
        </xsl:if> -->
    </xsl:template>
    
    <xsl:template match="html" mode="title">
        <xsl:variable name="title" select="head/meta[@name = 'title']/@content"/>
        <xsl:variable name="page-id" select="head/meta[@name = 'pages/page;id']/@content"/>
        
        <xsl:choose>
            <xsl:when test="$page-id != ''">
                <a href="{resolver:resolve('page', $page-id, false)}">
                    <h2 class="ametys-offres__item_title"><xsl:value-of select="$title"/></h2>
                </a>
            </xsl:when>
            <xsl:otherwise>
                <h2 class="ametys-offres__item_title"><xsl:value-of select="$title"/></h2>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template match="html" mode="closing-date">
        <xsl:variable name="closingDate" select="head/meta[@name='closingDate']/@content"/>
        
        <xsl:if test="$closingDate != ''">
            <span class="ametys-offres__item_icn font-italic">
                <i class="material-icons">access_time</i>
                <span style="font-weight:bold;">
                    <i18n:text i18n:key="CONTENT_JOB_OFFER_CLOSING_DATE" i18n:catalogue="plugin.job-offer" />
                </span> <xsl:text> : </xsl:text>
                <i18n:date src-pattern="yyyy-MM-dd'T'HH:mm:ss.SSSXXX" pattern="medium"><xsl:value-of select="$closingDate"/></i18n:date>
            </span>
         </xsl:if>
    </xsl:template>
    
    <xsl:template match="html" mode="place">
        <!-- Sample -->
        <!-- <xsl:variable name="place" select="head/meta[@name='service;title']/@content"/>
        <xsl:if test="$place != ''">
            <span class="ametys-offres__item_icn">
                <i class="material-icons">place</i>
                <xsl:value-of select="$place"/>
            </span>
        </xsl:if> -->
    </xsl:template>
	
	
</xsl:stylesheet>
