<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
        xmlns:sitemap="http://www.ametys.org/inputdata/sitemap/3.0"
        xmlns:xalan="http://xml.apache.org/xalan"
        xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
        xmlns:date="http://exslt.org/dates-and-times" extension-element-prefixes="date"
        exclude-result-prefixes="sitemap ametys">

    <xsl:import href="workspace:web://stylesheets/template-default.xsl"/>
    <xsl:import href="skin://stylesheets/main.xsl"/>
    <xsl:import href="plugin:cms://stylesheets/helper/html-hierarchy.xsl"/>
 
    <xsl:param name="lang"/>
    <xsl:param name="skin"/>
    <xsl:param name="site"/>
    <xsl:param name="cms-context"/>
    <xsl:param name="contextPath"/>
    <xsl:param name="template">page</xsl:param>
    <xsl:param name="rendering-context" select="ametys:renderingContext()"/>
    
    <xsl:param name="site-uri-prefix" select="$cms-context"/>
 
    <xsl:template match="/">
        <html lang="{$lang}" xml:lang="{$lang}">
            <head>
                <meta http-equiv="X-UA-Compatible" content="IE=9" />

                 <xsl:call-template name="favico"/>  

                <title><xsl:value-of select="/html/head/title"/> - <i18n:text i18n:key="SKIN_TITLE" i18n:catalogue="skin.{$skin}"/></title>

                <xsl:call-template name="head-js-jquery"/>                      
                <xsl:call-template name="head-js-pirobox"/>   
                <xsl:call-template name="head-js-mediaelement"/>                     
                
                <xsl:call-template name="head-css-jquery"/>                     
                <xsl:call-template name="head-css-pirobox"/>
                <xsl:call-template name="head-css-mediaelement"/>
                
                <xsl:call-template name="meta" />
                <xsl:call-template name="og-meta" />

                <xsl:call-template name="common-css" />
                <xsl:call-template name="additionnal-css" />
                
                <xsl:call-template name="common-script" />
                <xsl:call-template name="additionnal-script" />
                
                <xsl:copy-of select="/html/head/*[local-name() != 'title' and local-name() != 'meta']"/>
            </head>
            <body>
                 <h1 class="hidden-L"><xsl:value-of select="/html/head/title"/></h1>
                 
                 <div id="art-page-background-glare">
                     <div id="art-page-background-glare-image"> </div>
                 </div>
                 <div id="art-main">
                     <div class="cleared reset-box"></div>
                 <div class="art-sheet">
                     <div class="art-sheet-tl"></div>
                     <div class="art-sheet-tr"></div>
                     <div class="art-sheet-bl"></div>
                     <div class="art-sheet-br"></div>
                     <div class="art-sheet-tc"></div>
                     <div class="art-sheet-bc"></div>
                     <div class="art-sheet-cl"></div>
                     <div class="art-sheet-cr"></div>
                     <div class="art-sheet-cc"></div>
                     <div class="art-sheet-body">
                 <div class="art-content-layout">
                     <div class="art-content-layout-row">
                 <div class="art-layout-cell art-content">
                 
                 <!-- AMETYS BEGIN Content -->
                 <div class="art-tools">
                     <xsl:call-template name="pdf"/>
                     <div class="cleared"></div>
                 </div>
                 <xsl:call-template name="bread-crumb"/>
                 <div class="cleared"></div>
                 <!-- AMETYS END Content -->
                 
                 <div class="art-post">
                     <div class="art-post-body">
                 <div class="art-postcontent">
                 <xsl:call-template name="main-zone"/>
                 </div>
                 <div class="cleared"></div>
                 
                 		<div class="cleared"></div>
                     </div>
                 </div>
                 
                   <div class="cleared"></div>
                 
                 
                 
                 </div>
                 
                     </div>
                 </div>
                 <div class="cleared"></div>
                 
                 
                 		<div class="cleared"></div>
                     </div>
                 </div>
                 
                     <div class="cleared"></div>
                 </div>
                 
            </body>
        </html>
    </xsl:template>

    <xsl:template name="main-zone">
        <xsl:apply-templates select="html/body/node()" mode="move-hierarchy">
            <xsl:with-param name="level" select="2"/>
        </xsl:apply-templates>
    </xsl:template>
    
    <xsl:template name="bread-crumb"/>
    <xsl:template name="pdf"/>
    <xsl:template name="display-configure-links-btn-inputdata"/>
    <xsl:template name="links-thumbnails-inputdata"/>
    <xsl:template name="linkdirectory-configuration-error"/>
    
</xsl:stylesheet>