<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            xmlns:math="http://exslt.org/math"
							exclude-result-prefixes="ametys math">

	<xsl:import href="plugin:faq://stylesheets/content/faq/faq-main.xsl"/>	
	
	<xsl:variable name="category" select="/view/content/tags/*[@parent = 'CONTENT_CATEGORIES']"/>
	<xsl:variable name="uniqueId" select="substring-after(math:random(), '.')"/>

    <xsl:template name="custom-content-css">
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('zones/faq/scss/main.css')}" media="screen, print, handheld"/>
    </xsl:template>     
    
	<xsl:template name="common-content-head-js">
		<script type="text/javascript">
			/* ====== FAQ Toggle Boxes ===================== */
			$j(document).ready(function () {
				var device = $j(window).width() &lt;= '480' ? 'mobile' :
				$j(window).width() &lt;= '768' ? 'tablet' : 'desktop';
				// console.log(device);
				// Collapse responses if we are in Interview - desktop only
				if (device !== 'desktop' || !$j('.interview').length) {
					$j('#faq-<xsl:value-of select="$uniqueId"/> .panel').hide();
				}
				$j('#faq-<xsl:value-of select="$uniqueId"/> .toggle-view li').click(function (event) {
					$j(this).children('div.panel').slideToggle();
					$j(this).toggleClass('active');
				});
			});
		</script>
	</xsl:template>

 	<xsl:template name="common-content-body">
        <div class="ametys-cms-content {$common-content-css-class-name} wrapper" id="faq-{$uniqueId}">
            <xsl:call-template name="common-content-body-title"/>
            
            <xsl:call-template name="common-content-body-content"/>
        </div>            
    </xsl:template>

	<xsl:template name="common-content-body-content">
        <div class="flex-center">
            <!-- Tag -->
            <xsl:call-template name="badge"/>
        </div>
                    
        <!-- Rich content -->
        <div class="faq-description">
	        <xsl:call-template name="common-content-body-content-rich"/>
        </div>
        
        <div class="content-richtext-end"><xsl:comment>empty</xsl:comment></div>
    
        <!-- FAQ -->
        <xsl:call-template name="faq-details"/>
        
        <!-- Comments -->
        <xsl:call-template name="common-content-body-comments"/>     
    </xsl:template>
	
	<xsl:template name="faq-details">
        <xsl:if test="metadata/questions/entry[question != '']">
            <xsl:call-template name="questions-list-details"/>
            
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="question-title">
        <h2 class="question"><xsl:value-of select="question"/></h2>    
    </xsl:template>
    
    <xsl:template name="questions-list-details">
        <ul class="questions toggle-view">
            <xsl:apply-templates select="metadata/questions/entry[question != '']">
                <xsl:with-param name="prefix" select="concat('content-', @name)"/>
            </xsl:apply-templates>
        </ul>      
    </xsl:template>
    
    <xsl:template match="entry">
    	<xsl:param name="prefix"/>
    	
    	<li data-category="{$category}" data-element="list-element" data-date="{question-date}" class="element {$category}">
            <xsl:attribute name="class">item<xsl:text> </xsl:text>
                <xsl:call-template name="common-utils-class"/>
            </xsl:attribute>
        	
        	<xsl:if test="/view/content/tags/INTERVIEW">
				<xsl:attribute name="class">item interview</xsl:attribute>
			</xsl:if>
        	
            <a name="{$prefix}{@name}{$uniqueId}"/>
        	
            <xsl:call-template name="question-title"/>
            <div class="clear"></div>
            
            <div class="panel clearfix">
	            <xsl:call-template name="question-anwser"/>
	            
	            <xsl:call-template name="question-link"/>
	            
	            <xsl:call-template name="question-additionalinfo"/>
            </div>
        </li>
    </xsl:template>
	
</xsl:stylesheet>
