<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
							xmlns:docbook="http://docbook.org/ns/docbook"
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
							exclude-result-prefixes="docbook ametys">

	<xsl:import href="flashinfo.xsl"/>
	
	<!-- THIS VIEW IS USED TO DISPLAY STATIC FILTER : ALERTES BLOQUANTES -->

	<xsl:variable name="common-content-css-class-name">flash-info view-link</xsl:variable>
	
	<xsl:template name="common-content-body-title-content"/>
	
    <xsl:template name="common-content-body-content">
        <p class="content-abstract">
            <strong><xsl:value-of select="metadata/title"/>: </strong>
	        <xsl:call-template name="common-utils-simpletext">
                <xsl:with-param name="text" select="metadata/text"/>                
                <xsl:with-param name="defaultText" select="metadata/content/docbook:article"/>                
                <xsl:with-param name="maxDefaultTextSize" select="'150'"/>                
            </xsl:call-template>    
        </p>
        
        <!-- Read more -->
    	<xsl:call-template name="common-content-body-readmore"/>
	</xsl:template>
		
</xsl:stylesheet>