<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:docbook="http://docbook.org/ns/docbook"
                              xmlns:text="http://ametys.org/text/3.0" 
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              xmlns:user="org.ametys.plugins.userdirectory.transformation.xslt.UserXSLTHelper"
                              exclude-result-prefixes="docbook"
                              extension-element-prefixes="text resolver ametys user">

	<xsl:import href="skin://stylesheets/content/common-abstract.xsl"/>
    <xsl:import href="skin://stylesheets/utils.xsl" />
    
    <xsl:variable name="common-content-css-class-name">abstract-view head-staff ametys-mb-20</xsl:variable>
	
    
    <xsl:template name="common-content-body-content">
        <xsl:variable name="page-id"><xsl:call-template name="get-page-id"/></xsl:variable>
        
        <div class="ametys-document flex-column ametys-document--frame ametys-document--user">
            <xsl:call-template name="content"/>
        </div>
        <script src="{ametys:skinURL('templates/common/js/svgconvert.js')}"></script>
    </xsl:template>     
    
    <xsl:template name="get-page-id">
        <xsl:value-of select="user:getUserPage(@id)"/>
    </xsl:template>
    
    <xsl:template name="content">
        
        <xsl:call-template name="content-image"/>
        
        <xsl:call-template name="content-badge"/>
        
        <div class="ametys-document__txt ametys-document__txt--limit">
            <xsl:call-template name="content-ctype"/>
            
            <xsl:call-template name="content-title"/>
            
            <xsl:call-template name="content-abstract"/>
            
            <xsl:call-template name="content-phones"/>
            <xsl:call-template name="content-email"/>
        </div>
    </xsl:template>
    
    <xsl:template name="content-image">
        <xsl:variable name="page-id"><xsl:call-template name="get-page-id"/></xsl:variable>
        <a href="{resolver:resolve('page', $page-id, false)}" class="ametys-document__img">
            <xsl:choose>
                <xsl:when test="metadata/illustration/image">
                    <img alt="{metadata/illustration/alt-text}" src="{resolver:resolveCroppedImage(metadata/illustration/image/@type, metadata/illustration/image/@path, 154, 154)}" />
                </xsl:when>
                <xsl:when test="metadata/user">
                    <xsl:call-template name="user-profile-image">
                        <xsl:with-param name="size">154</xsl:with-param>
                        <xsl:with-param name="population" select="metadata/user/@populationId"/>
                        <xsl:with-param name="login" select="metadata/user/@login"/>
                    </xsl:call-template>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="content-default-image"/>
                </xsl:otherwise>
            </xsl:choose>
        </a>
    </xsl:template>
    
    <xsl:template name="content-default-image">
		<svg version="1.1" id="Calque_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
			 viewBox="0 0 140 140" style="enable-background:new 0 0 140 140;" xml:space="preserve" width="140">
			<path style="fill-rule:evenodd;clip-rule:evenodd;fill:#EFE9E8;" d="M120,116l1.8,1.1c1.2-1.4,2.4-2.8,3.5-4.2l-2.3-1.4l5.6-3.3
				c3-4.6,5.5-9.6,7.4-14.9V91l0.7,0.4c2.2-6.7,3.3-13.9,3.3-21.4c0-29.1-17.7-54-43-64.6V6l-1-0.5l0.5-0.3C88.4,1.9,79.4,0,70,0
				c-8.6,0-16.9,1.6-24.6,4.4L46,5l-1,1V4.6c-5.6,2.2-10.9,5-15.8,8.5L31,14l-2,1v-1.7C12.5,25.2,1.4,44.2,0.1,65.9L1,66.5l-0.9,0.7
				C0,68.1,0,69.1,0,70c0,8.1,1.4,15.8,3.9,23L6,92v3l-1.7-0.9c2.4,6.5,5.7,12.5,9.7,17.9v-3l4,2.5l-2.9,1.8c1.4,1.8,2.9,3.5,4.5,5.1
				L22,117v3.9c2.9,2.7,6,5.2,9.3,7.4L37,125v6.7c3.4,1.8,7,3.4,10.8,4.6L53,133v4.9c1.6,0.4,3.3,0.8,5,1v-6l7,4.5l-3.1,2
				c2.7,0.3,5.4,0.5,8.1,0.5c2.9,0,5.8-0.2,8.6-0.5L76,138l7-4v4.8c2-0.4,4-0.9,6-1.4V134l3.8,2.2c3.9-1.3,7.6-3,11.2-5V125l5.2,3
				c3.9-2.6,7.5-5.7,10.8-9V116z M136,57l2,1l-2,1V57z M136,74l3,1.5l-3,1.5V74z M128,96l-4-2.5l4-2.5V96z M127,40v1l-1-0.5L127,40z
				 M128,57v2l-2-1L128,57z M128,74v3l-3-1.5L128,74z M122,49l1,0.5l-1,0.5V49z M121.1,31l0.9,0.5l-0.9,0.5V31z M121,65l2,1.5l-2,1.5
				V65z M121,83l3,2l-3,2V83z M120,99l5,3l-5,3V99z M5,57v3l-2-1.5L5,57z M6,77l-3-1.5L6,74V77z M14,39l2,1.5L14,42V39z M14,57l3,1.5
				L14,60V57z M14,74l3,1.5L14,77V74z M14,91l3,2l-3,2V91z M21,104l-4-2l4-2V104z M21,87l-3-2l3-2V87z M21,68l-3-1.5l3-1.5V68z M21,51
				l-2-1.5l2-1.5V51z M21,33l-2-1l2-1V33z M51,13v2l-1-1L51,13z M52,100v5l-4-2.5L52,100z M51,31v2l-2-1L51,31z M51,48v2l-2-1L51,48z
				 M51,65v3l-2-1.5L51,65z M51,83v4l-3-2L51,83z M45,22l2,1l-2,1V22z M45,40l2,1l-2,1V40z M45,57l2,1l-2,1V57z M44,74l3,1.5L44,77V74z
				 M44,91l4,2l-4,2V91z M44,108l5,3l-5,3V108z M36,22v2l-2-1L36,22z M36,40v2l-2-1L36,40z M36,57v3l-2-1.5L36,57z M36,74v3l-3-1.5
				L36,74z M29,31l2,1l-2,1V31z M29,48l2,1.5L29,51V48z M29,65l3,1.5L29,68V65z M29,83l3,2l-3,2V83z M29,100l4,2.5l-4,2.5V100z M29,123
				v-6l5,3L29,123z M37,114l-5-3l5-3V114z M37,95l-4-2l4-2V95z M43,133v-8l7,4L43,133z M53,123l-6-3.5l6-3.5V123z M66,5v1l-1-0.5L66,5z
				 M66,22v1l-1-0.5L66,22z M66,40v2l-1-1L66,40z M67,57v2l-2-1L67,57z M67,74v3l-3-1.5L67,74z M63,93l4-2v4L63,93z M67,108v6l-5-3
				L67,108z M60,14l1,0.5L60,15V14z M60,31l1,1l-1,1V31z M60,48l2,1l-2,1V48z M60,65l2,1.5L60,68V65z M60,83l3,2l-3,2V83z M59,100
				l4,2.5l-4,2.5V100z M59,116l6,3.5l-6,3.5V116z M68,133l-7-4l7-4V133z M81,14v1l-1-0.5L81,14z M81,31v1l-1-0.5L81,31z M81,49v1
				l-1-0.5L81,49z M82,66v2l-2-1L82,66z M82,83v3l-3-1.5L82,83z M82,100v5l-4-2.5L82,100z M76,5l1,0.5L76,6V5z M76,22l1,0.5L76,23V22z
				 M76,40l1,0.5L76,41V40z M75,57l2,1l-2,1V57z M75,74l2,1.5L75,77V74z M75,91l4,2l-4,2V91z M74,108l5,3l-5,3V108z M74,133v-8l7,4
				L74,133z M83,123l-6-3.5l6-3.5V123z M97,22v1l-1-0.5L97,22z M97,40v1l-1-0.5L97,40z M97,57v2l-1-1L97,57z M97,74v3l-2-1.5L97,74z
				 M98,91v4l-4-2L98,91z M91,14l1,0.5L91,15V14z M91,31l1,0.5L91,32V31z M91,49l1,0.5L91,50V49z M91,66l2,1l-2,1V66z M90,83l3,1.5
				L90,86V83z M90,100l5,2.5l-5,2.5V100z M98,108v6l-6-3L98,108z M89,116l6,3.5l-6,3.5V116z M99,133l-7-4l7-4V133z M111.9,14v1
				l-0.9-0.5L111.9,14z M112,31v1l-0.9-0.5L112,31z M112,49v1l-1-0.5L112,49z M112,66v2l-2-1L112,66z M113,83v4l-3-2L113,83z M113,99v6
				l-5-3L113,99z M106,22l0.9,0.5L106,23V22z M106,40l1,0.5l-1,0.5V40z M106,57l2,1l-2,1V57z M106,74l3,1.5l-3,1.5V74z M105,91l4,2.5
				l-4,2.5V91z M105,108l6,3.5l-6,3.5V108z M114,123l-6-3.5l6-3.5V123z"/>
			<g id="avatar_profile_2199084" style="mask:url(#mask-2_00000031924886558751387210000008791357337734429329_);">
				<g transform="translate(31.000000, 44.000000)">
					<path id="Shape" class="primary" d="M36.1,30.2c8.4,0,15.1-6.7,15.1-15.1S44.5,0,36.1,0S21,6.7,21,15.1S27.7,30.2,36.1,30.2
						z M36.1,3.9c6.1,0,11.1,5,11.1,11.1S42.2,26,36.1,26S25,21,25,14.9S29.8,3.9,36.1,3.9z"/>
					<path id="Path" class="primary" d="M70.2,67.1c-4.9-21.8-25.5-35.4-46.1-30.4l0,0c-9.9,2.5-18.5,8.9-23.9,18.2L4,57.4
						C14,40.6,34.9,35.4,50.8,45.8c7.7,5,13.1,13,15.1,22.3c1.8,7.9,0.9,16.2-2.3,23.6c0,0,4.6-1.8,5.7-2.4
						C71.4,82.1,71.8,74.5,70.2,67.1z"/>
				</g>
			</g>
		</svg>
    </xsl:template>
    
    <xsl:template name="content-ctype">
        <h2 class="ametys-document__txt_name">
            <i18n:text i18n:key="SKIN_CONTENT_TYPE_USER" i18n:catalogue="skin.{$skin}"/>
        </h2>
    </xsl:template>
    
    
    <xsl:template name="content-title">
        <h1 class="ametys-document__txt_title">
            <xsl:if test="normalize-space(metadata/firstname) != '' or normalize-space(metadata/lastname) != ''">
    			<xsl:if test="normalize-space(metadata/civilite) != ''">
					<xsl:value-of select="metadata/civilite" /><xsl:text> </xsl:text>
				</xsl:if>
				<xsl:if test="normalize-space(metadata/firstname) != ''">
					<xsl:value-of select="metadata/firstname" /><xsl:text> </xsl:text>
				</xsl:if>
				<xsl:if test="normalize-space(metadata/lastname) != ''">
					<xsl:value-of select="metadata/lastname" />
				</xsl:if>
			</xsl:if>
        </h1>
    </xsl:template>
    
    <xsl:template name="content-abstract">
        <xsl:if test="normalize-space(metadata/organisation) != ''">
            <p class="ametys-document__paragraph">
                <xsl:value-of select="metadata/organisation" />
            </p>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="content-phones">
        <!-- Phones -->
        <xsl:if test="normalize-space(metadata/phone) != ''">
            <a href="tel:{metadata/phone}" class="ametys-document__txt_data">
                <i class="material-icons">phone</i>
                <xsl:value-of select="metadata/phone" />
            </a>
        </xsl:if>
        <xsl:if test="normalize-space(metadata/mobile) != ''">
            <a href="tel:{metadata/mobile}" class="ametys-document__txt_data">
                <i class="material-icons">phone</i>
                   <xsl:value-of select="metadata/mobile" />
            </a>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="content-email">
        <xsl:if test="normalize-space(metadata/email) != '' and contains(metadata/email, '@')">
    		<span class="ametys-document__txt_data">
    			<i class="material-icons">mail_outline</i>
                
    			<xsl:call-template name="mail-antispam">
					<xsl:with-param name="mail" select="metadata/email" />
					<xsl:with-param name="class" select="'user-mail'" />
				</xsl:call-template>
			</span>
		</xsl:if>
    </xsl:template>
    
</xsl:stylesheet>
