<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                extension-element-prefixes="ametys">
                
    <xsl:import href="plugin:user-directory://pages/services/organization-chart/organization-chart.xsl"/>

    <xsl:template name="common-service-head-css">
        <link type="text/css" rel="stylesheet" href="{ametys:skinURL('templates/common/scss/organization-chart.css')}" media="screen, print, handheld"/>  
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty">
        <div class="ametys-cms-service {$common-service-css-class-name} wrapper">
            <xsl:call-template name="common-service-body-nonempty-content-title"/>
            
            <xsl:call-template name="common-service-body-nonempty-content-content"/>            
        </div>
    </xsl:template>
    
    <xsl:template name="orgUnit-focus">
        <xsl:param name="level" />
        <xsl:if test="$level != 1">
	        <div class="orgUnit-focus">
	            <a href="#" onclick="try{{AmetysOrganizationChart._focusOrgunit(this)}}finally{{return false;}}" data-orgunit-id="ud-{@unique-id}" class="focus" i18n:attr="title" title="plugin.user-directory:PLUGINS_USER_DIRECTORY_ORGANIZATION_CHART_FOCUS_MSG">
	                <i class="fas fa-search-plus"></i>
	            </a>
	            <a href="#" onclick="try{{AmetysOrganizationChart._backToParent(this)}}finally{{return false;}}" data-orgunit-id="ud-{@unique-id}" style="display:none" class="back-to-parent" i18n:attr="title" title="plugin.user-directory:PLUGINS_USER_DIRECTORY_ORGANIZATION_CHART_BACK_TO_PARENT_MSG">
	                <i class="fas fa-search-minus"></i>
	            </a>
	            <a href="#" onclick="try{{AmetysOrganizationChart._removeFocus()}}finally{{return false;}}" style="display:none" class="remove-focus" i18n:attr="title" title="plugin.user-directory:PLUGINS_USER_DIRECTORY_ORGANIZATION_CHART_REMOVE_FOCUS_MSG">
	                <i class="fas fa-times"></i>
	            </a>
	        </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template match="orgUnit">
        <xsl:param name="level"/>
        <li>
	        <xsl:if test="orgUnits">
                <input class="checkbox" type="checkbox" id="{generate-id()}">
                    <xsl:if test="not($maxLevel) or $level &lt; $maxLevel">
                        <xsl:attribute name="checked" />
                    </xsl:if>
                </input>
            </xsl:if>
	        
	        <div>
		        <xsl:call-template name="orgUnit-focus" >
		          <xsl:with-param name="level" select="$level" />
		        </xsl:call-template>

                <xsl:copy-of select="html/body/node()" />
    	        <xsl:call-template name="main-user"/>
    	        <xsl:if test="orgUnits">
	                <label for="{generate-id()}">
	                	<span><i18n:text i18n:key="PLUGINS_USER_DIRECTORY_ORGANIZATION_CHART_TOGGLE_LABEL" i18n:catalogue="plugin.user-directory"/></span>
                		<i class="fas fa-plus"></i>
                		<i class="fas fa-minus"></i>
	                	
	                </label>
	            </xsl:if>
    	    </div>

            <xsl:apply-templates select="orgUnits" mode="children">
                <xsl:with-param name="level" select="$level + 1"/>
            </xsl:apply-templates>
        </li>
    </xsl:template>

</xsl:stylesheet>
