<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:docbook="http://docbook.org/ns/docbook"
                xmlns:math="java.lang.Math"
                exclude-result-prefixes="resolver math ametys docbook">
                
    <xsl:import href="plugin:web://pages/services/search/search-default.xsl"/>
    <xsl:import href="service:web://pages/services/search/search-default/results/facets.xsl"/>
    <xsl:import href="service:web://pages/services/search/search-default/results/sorts.xsl"/>
    <xsl:import href="service:web://pages/services/search/search-default/results/pagination.xsl"/>
    <xsl:import href="service:web://pages/services/search/search-default/results/hits.xsl"/>
    
    
    <xsl:template name="common-service-head-css">    
        <link type="text/css" rel="stylesheet" href="{ametys:skinURL('zones/index-carousel/scss/main.css')}" media="screen, print, handheld"/>
        <link type="text/css" rel="stylesheet" href="{ametys:skinURL('zones/index-carousel/scss/print.css')}" media="screen, print, handheld"/>
    </xsl:template>
    
    <xsl:variable name="common-service-css-class-name">search-carousel</xsl:variable>
    
    <xsl:variable name="uniqueId" select="substring-after(math:random(), '.')"/>
    
    <xsl:template name="common-service-body-nonempty-content-title"/>
    
    <xsl:template name="common-service-body-nonempty-content-content">
    	<xsl:call-template name="link"/>
    	
    	<div id="ametys-cms-zone-carousel-item-{$uniqueId}">
			<div id="carousel-{$uniqueId}" class="ametys-main-carousel mb-4"
			     data-autoplay="true"
			     data-infinite="true"
			     data-fade="true"
			     data-speed="5000"
			     data-pagi-classes="ametys-main-carousel__dots">
			     
			     <xsl:choose>
           			<xsl:when test="/search/hits/hit">
	           				<xsl:for-each select="/search/hits/hit">
								<div class="slide">
							        <xsl:variable name="page-id" select="content/html/head/meta[@name = 'pages/page;id']/@content"/>
							        <xsl:variable name="content">
							        	<xsl:value-of select="content/html/head/meta[@name = 'abstract']/@content"/>
<!-- 							        	<xsl:call-template name="common-utils-simpletext"> -->
<!-- 							                <xsl:with-param name="text" select="content/html/head/meta[@name = 'abstract']/@content"/>                 -->
<!-- 							                <xsl:with-param name="defaultText" select="content/html/head/meta[@name = 'content']/@content"/>                 -->
<!-- 							                <xsl:with-param name="maxDefaultTextSize" select="200"/>                 -->
<!-- 							            </xsl:call-template> -->
							        </xsl:variable>
                                    
									<div class="ametys-main-carousel__item" >
										
										<xsl:apply-templates select="." mode="picture"/>
                                        
										<div class="ametys-main-carousel__item-text">
											<article class="ametys-cms-content article view-abstract">
												<xsl:call-template name="carousel-tag"/>
												
												<h2 class="content-title"><xsl:value-of select="content/html/head/meta[@name = 'title']/@content" /></h2>
												 <xsl:if test="normalize-space($content) != ''">
													 <p class="content-text"><xsl:value-of select="$content"/></p>
											    </xsl:if>
												<a href="{resolver:resolve('page', $page-id, false)}" class="ametys-main-carousel__item_more" tabindex="-1">
					                              <i18n:text i18n:key="SKIN_KNOW_MORE" i18n:catalogue="skin.{$skin}"/>
					                            </a>
											</article>
										</div>
									</div>
								</div>
							</xsl:for-each>
					</xsl:when>
					<xsl:otherwise>
               			<xsl:if test="/search/hits">
<!--                				hits is present but no single hit => there is no result -->
			                <xsl:call-template name="no-result"/>
		                </xsl:if>
		            </xsl:otherwise>
		        </xsl:choose>
			</div>
			
			<script>
				
				$j.HSCore.components.HSCarousel.init('#carousel-<xsl:value-of select="$uniqueId"/>');
				
				$j.resize.delay = 10;
				
				$j('#ametys-cms-zone-carousel-item-<xsl:value-of select="$uniqueId"/>').bind( 'resize', function(e) {
					
					$('#carousel-<xsl:value-of select="$uniqueId"/>').slick('setPosition');
					
				});
			
			</script>
		</div>
	</xsl:template>
    
    <xsl:template match="hit" mode="picture">
        <xsl:variable name="type" select="content/html/head/meta[@name = 'illustration/image;type']/@content"/>        
        <xsl:variable name="uri" select="content/html/head/meta[@name = 'illustration/image;uri']/@content"/>
         
        <xsl:choose>
            <xsl:when test="$type != ''">                           
		         <picture>
		            <source srcset="{resolver:resolveCroppedImage($type, $uri, '211', '428')}" media="(max-width: 440px)" />
		            <source srcset="{resolver:resolveCroppedImage($type, $uri, '320', '768')}" media="(max-width: 768px)" />
		            <source srcset="{resolver:resolveCroppedImage($type, $uri, '367', '674')}" media="(max-width: 1024px)" />
		            <source srcset="{resolver:resolveCroppedImage($type, $uri, '367', '610')}" media="(max-width: 1280px)" />
		            <source srcset="{resolver:resolveCroppedImage($type, $uri, '367', '668')}" media="(max-width: 1366px)" />
		            <source srcset="{resolver:resolveCroppedImage($type, $uri, '367', '781')}" media="(max-width: 1536px)" />
		            <img src="{resolver:resolveCroppedImage($type, $uri, '367', '972')}" alt="" />
		        </picture>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="hit-default-picture"/>
		    </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <xsl:template name="hit-default-picture">
    </xsl:template>
	
	<xsl:template name="carousel-tag">
	   <xsl:if test="content/html/head/meta[@content='CONTENT_CATEGORIES' and contains(@name, ';parent')]">
	        <!-- Get first tag of CONTENT_CATEGORIES theme -->
            <xsl:variable name="parentTagName" select="content/html/head/meta[@content='CONTENT_CATEGORIES' and contains(@name, ';parent')]/@name"/> 
            <!-- Get tag name in meta  -->
            <xsl:variable name="tagMetaName" select="substring-before($parentTagName, ';parent')"/>
            <!-- Extract tag's name -->
			<xsl:variable name="tagName" select="substring-after($tagMetaName, 'tags/')"/>
	
	      <span class="content-tag ametys-tag-v2">
              <xsl:if test="$useTagColor">
                  <xsl:variable name="tagColor" select="ametys:tagColor(ametys:site(), $tagName)/main"/>
                  <xsl:if test="$tagColor"><xsl:attribute name="style">background-color : <xsl:value-of select="$tagColor"/>; color: <xsl:value-of select="@textColor"/></xsl:attribute></xsl:if>
              </xsl:if>
              
              <xsl:value-of select="content/html/head/meta[@name = $tagMetaName]/@content"/>
          </span>
        </xsl:if>
	</xsl:template>
	
</xsl:stylesheet>
