<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:math="java.lang.Math"
                exclude-result-prefixes="resolver math ametys">
                
    <xsl:import href="plugin:web://pages/services/search/search-default.xsl"/>
    <xsl:import href="service:web://pages/services/search/search-default/results/facets.xsl"/>
    <xsl:import href="service:web://pages/services/search/search-default/results/sorts.xsl"/>
    <xsl:import href="service:web://pages/services/search/search-default/results/pagination.xsl"/>
    <xsl:import href="service:web://pages/services/search/search-default/results/hits.xsl"/>
    
    <xsl:template name="common-service-head-css">    
	    <link rel="stylesheet" href="{ametys:skinURL('zones/index-notes/scss/main.css')}" />
    </xsl:template>
    
    <xsl:variable name="uniqueId" select="substring-after(math:random(), '.')"/>
    
    <xsl:template name="common-service-body-nonempty-content-title"/>
    
    <xsl:template name="common-service-body-nonempty-content-content">
		<div>
			<xsl:if test="$template ='index'"><xsl:attribute name="class">card mb-4 <xsl:value-of select="$override-card-styles"/></xsl:attribute></xsl:if>
			<xsl:call-template name="header"/>
			
			<div class="card-body pt-0 pb-4 px-0">
				<xsl:choose>
		           	<xsl:when test="/search/hits/hit">
						<xsl:call-template name="hits"/>
					</xsl:when>
					<xsl:otherwise>
               			<xsl:if test="/search/hits">
							<!-- hits is present but no single hit => there is no result -->
			                <xsl:call-template name="no-result"/>
		                </xsl:if>
		            </xsl:otherwise>
				</xsl:choose>
			</div>
		</div>
	</xsl:template>
	
	<xsl:template name="header">
		<header class="card-header card-header--space-between flex-wrap">
			<h1 class="card-title">
	        	<xsl:call-template name="card-header-icon"/>
	        	 <xsl:choose>
		            <xsl:when test="$header != ''">
		              	<xsl:value-of select="$header"/>
		            </xsl:when>
		            <xsl:otherwise>
		            	<i18n:text i18n:key="SKIN_AGENDA" i18n:catalogue="skin.{$skin}"/>
		            </xsl:otherwise>
		        </xsl:choose>
        	</h1>
        	<xsl:call-template name="link"/>
        </header>
	</xsl:template>
	
	<xsl:template name="link">
		<xsl:if test="link/page != ''">
    		<div class="mb-2 d-flex flex-wrap align-items-center ">
			
				<a class="card-link" href="{resolver:resolve('page', link/page)}">
					<xsl:choose>
						<xsl:when test="link/title != ''"><xsl:value-of select="link/title"/></xsl:when>
						<xsl:otherwise><xsl:call-template name="default-link-text"/></xsl:otherwise>
					</xsl:choose>
				</a>
			</div>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="default-link-text">
		<i18n:text i18n:key="SKIN_SEARCH_OFFERS" i18n:catalogue="skin.{$skin}"/>
	</xsl:template>
	
	<xsl:template name="card-header-icon">
		<span class="card-header__icon icofont-papers"></span>
	</xsl:template>
	
	<xsl:template name="hits">
		<ul class="ametys-notes">
   			<xsl:for-each select="/search/hits/hit">
				<li class="ametys-notes__item">
					<xsl:copy-of select="content/html/body"/>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>
	
</xsl:stylesheet>
