<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2023 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:math="java.lang.Math"
                exclude-result-prefixes="resolver math ametys">
     
    <xsl:import href="common/home-card-search.xsl"/>
    
    <xsl:variable name="openMediaOnClick" select="ametys:serviceViewParameter('openMediaOnClick')" />
    
    <xsl:variable name="first-thumbnail-width">287</xsl:variable>
    <xsl:variable name="first-thumbnail-height">160</xsl:variable>
    <xsl:variable name="default-thumbnail-width">188</xsl:variable>
    <xsl:variable name="default-thumbnail-height">88</xsl:variable>
        
    <xsl:template name="common-service-head-css">    
         <link rel="stylesheet" href="{ametys:skinURL('zones/index-video-search/scss/main.css')}" />
         <link rel="stylesheet" href="{ametys:skinURL('zones/index-video-search/scss/print.css')}" />
    </xsl:template>
    
    <xsl:template name="search-results-class-attribute">
        <xsl:attribute name="class">card-body d-flex flex-wrap align-items-sm-end flex-column flex-sm-row pt-0</xsl:attribute>
    </xsl:template>
    
    <xsl:template name="hits-class-attribute">
        <xsl:attribute name="class">ametys-video-search-list</xsl:attribute>
    </xsl:template>
    
    <xsl:template match="hit[@saxer = 'org.ametys.web.frontoffice.search.metamodel.impl.ContentSaxer']" mode="class-attribute">
        <xsl:text/>ametys-video-search-list__item<xsl:text> </xsl:text>
    </xsl:template>           
    
    <xsl:template name="header-default">
        <i18n:text i18n:key="SKIN_VIDEO" i18n:catalogue="skin.{$skin}"/>
    </xsl:template>
    
    <xsl:template name="card-header-icon">
        <i class="card-header__icon far fa-play-circle"/>
    </xsl:template>
    
    <xsl:template name="hits">
        <xsl:variable name="nbItem" select="count(/search/hits/hit)"/>
         
        <ul data-ametys-search-role="hits">
        	<xsl:attribute name="class">
        		<xsl:text>ametys-video-search-list</xsl:text>
           		<xsl:choose>
           			<xsl:when test="$nbItem = 3"> trio</xsl:when>
           			<xsl:when test="$nbItem &lt;= 2"> duo</xsl:when>
           		</xsl:choose>
           	</xsl:attribute>
            <!-- highlight first item -->
            <li class="ametys-video-search-list__item">
                <xsl:for-each select="/search/hits/hit[position() = '1']">
                    <xsl:call-template name="hit-content">
	        			<xsl:with-param name="image-width" select="$first-thumbnail-width"/>
                        <xsl:with-param name="image-height" select="$first-thumbnail-height"/>
                     </xsl:call-template>
                </xsl:for-each>
            </li>
            <li class="ametys-video-search-list__group">
                <!-- Display title on mouseover -->
                <xsl:for-each select="/search/hits/hit[position() = '1']">
                
                 <div class="ametys-video-search-list__group__title">
                     <span data-default="{content/@title}" 
                         class="ametys-video-search-list__group__title__title">
                         <xsl:value-of select="content/@title"/>
                     </span>
                     
                     <xsl:variable name="abstract-content">
                     	<xsl:choose>
                     		<xsl:when test="normalize-space(content/html/head/meta[@name = 'abstract']/@content) != ''">
                     			<xsl:value-of select="content/html/head/meta[@name = 'abstract']/@content"/>
                     		</xsl:when>
                     		<xsl:otherwise>
                     			<xsl:value-of select="substring(content/html/head/meta[@name = 'content']/@content, 0, 100)"/>
                     		</xsl:otherwise>
                     	</xsl:choose>
                     </xsl:variable>
                     
                     <span data-default="{$abstract-content}" class="ametys-video-search-list__group__title__text">
                         <xsl:value-of select="$abstract-content"/>
                     </span>
                 </div>
             </xsl:for-each>
                <!-- List of the other items -->
                <div class="ametys-video-search-list__group__videos">
                    <xsl:for-each select="/search/hits/hit[position() != '1' and position() &lt;= '4']">
                        <xsl:call-template name="hit-content">
					        <xsl:with-param name="image-width" select="$default-thumbnail-width"/>
                            <xsl:with-param name="image-height" select="$default-thumbnail-height"/>
                     </xsl:call-template>
                    </xsl:for-each>
                </div>
            </li>
        </ul>
        <script> 
              $j('.ametys-video-search-list__group__videos .home-view.video').hover(function() {
                const title = $j(this).data('title');
                const text = $j(this).data('text');

                $j('.ametys-video-search-list__group__title__title').text(title);
                $j('.ametys-video-search-list__group__title__text').text(text);
              }, function() {
                const title = $j('.ametys-video-search-list__group__title__title').data('default');
                const text = $j('.ametys-video-search-list__group__title__text').data('default');

                $j('.ametys-video-search-list__group__title__title').text(title);
                $j('.ametys-video-search-list__group__title__text').text(text);
              });
        </script>
    </xsl:template>
    
    <!-- Template used to display a content -->
    <xsl:template name="hit-content">
        <xsl:param name="image-width"/>
        <xsl:param name="image-height"/>
        
        <xsl:variable name="page-id" select="content/html/head/meta[@name = 'pages/page;id']/@content"/>
        
        <xsl:variable name="abstract-content">
            <xsl:choose>
                <xsl:when test="normalize-space(content/html/head/meta[@name = 'abstract']/@content) != ''">
                    <xsl:value-of select="content/html/head/meta[@name = 'abstract']/@content"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="substring(content/html/head/meta[@name = 'content']/@content, 0, 100)"/>
                </xsl:otherwise>
            </xsl:choose>
         </xsl:variable>
                     
        <div data-title="{content/@title}"
             class="ametys-cms-content home-view video wrapper">
             <xsl:attribute name="data-text"><xsl:value-of select="$abstract-content"/></xsl:attribute>
             <div>
                <a class="ametys-video-search-list__item_link ametys-video-search--play ametys--video">
                   <xsl:choose>
                        <xsl:when test="$openMediaOnClick = 'true'">
                            <xsl:call-template name="content-open-media-attributes"/>
                        </xsl:when>
                        <xsl:when test="$page-id != ''">
                            <xsl:attribute name="href"><xsl:value-of select="resolver:resolve('page', $page-id, false)"/></xsl:attribute>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:attribute name="href">#</xsl:attribute>
                        </xsl:otherwise>
                    </xsl:choose>
                    
                    <!-- Immage -->
                    <xsl:call-template name="hit-content-image">
                       <xsl:with-param name="image-width" select="$image-width"/>
                       <xsl:with-param name="image-height" select="$image-height"/>
                    </xsl:call-template>
                </a>
             </div>
             <xsl:if test="$openMediaOnClick = 'true'">
                <xsl:call-template name="content-open-media-js"/>
            </xsl:if>
         </div>
    </xsl:template>
    
    <xsl:template name="content-open-media-attributes">
        <xsl:attribute name="href">#player-<xsl:value-of select="generate-id()"/></xsl:attribute>
        <xsl:attribute name="id">video-link-<xsl:value-of select="generate-id()"/></xsl:attribute>
        <xsl:attribute name="data-fancybox"></xsl:attribute>
    </xsl:template>
    
    <xsl:template name="hit-content-image">
        <xsl:param name="image-width"/>
        <xsl:param name="image-height"/>
        
        <xsl:variable name="image-type" select="content/html/head/meta[@name = 'illustration/image;type']/@content"/>
		<xsl:variable name="image-uri" select="content/html/head/meta[@name = 'illustration/image;uri']/@content"/>

        <!-- Image -->
        <div class="content-illustration">
          <xsl:choose>
        	<xsl:when test="$image-type != '' and $image-uri != ''">
                <img alt="" src="{resolver:resolveCroppedImage($image-type, $image-uri, $image-height, $image-width)}" width="{$image-width}" height="{$image-height}"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="hit-content-image-default"/>
            </xsl:otherwise>
          </xsl:choose>
        </div>
        <xsl:call-template name="hit-content-image-icon"/>
    </xsl:template>    
    
     <xsl:template name="hit-content-image-default">
         <img src="{ametys:skinURL('zones/document/img/pattern.png')}"/>
     </xsl:template>
    
    <xsl:template name="hit-content-image-icon">
        <i class="card-header__icon material-icons">play_arrow</i>
    </xsl:template>
    
    <xsl:template name="content-open-media-js">
    	<xsl:variable name="file-type" select="content/html/head/meta[@name = 'file;type']/@content"/>
		<xsl:variable name="file-uri" select="content/html/head/meta[@name = 'file;uri']/@content"/>
		
        <div class="ametys-video__modal">
            <video id="player-{generate-id()}" class="ametys-video__modal_frame"></video>
        </div>
        
        <script type="text/javascript">
           var videoPlayer<xsl:value-of select="generate-id()"/>;
        
           $j(document).ready(function() {
            $j("#video-link-<xsl:value-of select="generate-id()"/>").fancybox({
              beforeShow: function(){
                videoPlayer<xsl:value-of select="generate-id()"/> = new MediaElementPlayer('player-<xsl:value-of select="generate-id()"/>', {
                  alwaysShowControls: true,
                  success: function(media) {
                    media.setSrc("<xsl:value-of select="resolver:resolve($file-type, $file-uri, 'true')"/>");
                    media.load();
                  }
                });
              },
              afterShow: function() {
                $j($j('#player-<xsl:value-of select="generate-id()"/>')[0]).find('video').prop("controls", true)
                $j('#player-<xsl:value-of select="generate-id()"/>')[0].play();
              },
              beforeClose: function (){
                videoPlayer<xsl:value-of select="generate-id()"/>.remove();
              }
            });
          });
        </script>
    </xsl:template>
</xsl:stylesheet>
