<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                              xmlns:docbook="http://docbook.org/ns/docbook"
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent" 
                              xmlns:text="http://ametys.org/text/3.0" 
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              exclude-result-prefixes="docbook resolver"
                              extension-element-prefixes="text">

	<xsl:import href="plugin:web://stylesheets/content/article/article-abstract.xsl"/>	
	<xsl:import href="skin://stylesheets/content/common-abstract.xsl"/>
	
	<xsl:variable name="common-content-css-class-name"> 
		<xsl:choose>
			<xsl:when test="$zone = 'aside'">article view-main card mb-4</xsl:when>
			<xsl:otherwise>abstract-view article ametys-mb-20 </xsl:otherwise>
		</xsl:choose>
	</xsl:variable>
	
    <xsl:template name="custom-content-css">
        <!-- TODO to remove ? -->
	    <link rel="stylesheet" href="{ametys:skinURL('zones/document/scss/main.css')}" />
	</xsl:template>
    
    <xsl:template name="content-ctype">
        <h2 class="ametys-document__txt_name">
            <i18n:text i18n:key="SKIN_CONTENT_TYPE_ARTICLE" i18n:catalogue="skin.{$skin}"/>
        </h2>
    </xsl:template>
	
</xsl:stylesheet>
