/*
 *  Copyright 2023 Anyware Services
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
Accessibility = {
    
    FOCUSABLE_ELEMENTS_SELECTOR: 'a[href]:not([disabled]), button:not([disabled]), textarea:not([disabled]), input[type="text"]:not([disabled]), input[type="radio"]:not([disabled]), input[type="checkbox"]:not([disabled]), select:not([disabled]), [tabindex]:not([tabindex="-1"])',
    
    KEYCODE_TAB: 9,
    
    firstFocusableEl: null,
    lastFocusableEl: null,
    
    handleTabKeyPress: function(event) 
    {
      var isTabPressed = (event.key === 'Tab' || event.keyCode === Accessibility.KEYCODE_TAB);
	  if (!isTabPressed) { 
	      return; 
	  }
    
      if (event.shiftKey && document.activeElement === Accessibility.firstFocusableEl) 
      {
        event.preventDefault();
        Accessibility.lastFocusableEl.focus();
      } 
      else if (!event.shiftKey && document.activeElement === Accessibility.lastFocusableEl) 
      {
        event.preventDefault();
        Accessibility.firstFocusableEl.focus();
      }
	},
    
    /**
     * Trap focus into the given modal. Assume that this modal and any other modals into this modal have a "role='dialog"" attribute
     * @param modal the modal with role='dialog' attribute
     * @param focusFirstElmt set to tru to focus the first focusable element
     */
    trapFocus: function(modalEl, focusFirstElmt)
    {
        // Reinit event
        Accessibility.untrapFocus(modalEl);
        
        var focusableEls = modalEl.querySelectorAll(Accessibility.FOCUSABLE_ELEMENTS_SELECTOR);
  
        // Remove elements from sub-modal
        var $focusableEls = $j(focusableEls).filter(function (i, elmt){
            return $j(elmt).closest("[role='dialog']").length === 0 || $j(elmt).closest("[role='dialog']").get(0) == modalEl;
        });
        
        if ($focusableEls.length)
        {
	        Accessibility.firstFocusableEl = $focusableEls.get(0);  
	        Accessibility.lastFocusableEl = $focusableEls.get($focusableEls.length - 1);
            
            if (focusFirstElmt)
            {
		        // Put focus on first focusable element
		        $j(Accessibility.firstFocusableEl).focus();
            }
	        
	        modalEl.addEventListener('keydown', Accessibility.handleTabKeyPress);
        }
    },
    
    untrapFocus: function(modalEl)
    {
        modalEl.removeEventListener('keydown', Accessibility.handleTabKeyPress);
        Accessibility.firstFocusableEl = null;
        Accessibility.firstFocusableEl = null;
    }
}