<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:exsl="http://exslt.org/common"
                xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                extension-element-prefixes="exsl ametys resolver">
    
    <xsl:import href="plugin:forms://pages/services/display/mini-survey.xsl"/>
    
    <!-- Can be : pie, doughnut, or horizontalBar -->
    <xsl:variable name="chart-type">doughnut</xsl:variable>
    <xsl:variable name="chart-width">300</xsl:variable>     
    <xsl:variable name="chart-height">300</xsl:variable>     
    
    <xsl:variable name="common-service-css-class-name">mini-survey</xsl:variable>
    
    <!-- Do not display form if no access -->
    <xsl:variable name="is-empty" select="//form/@hasReadAccess != 'true'"/>
    
    <xsl:template name="common-service-head-other-css">
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('zones/forms/scss/main.css')}"/>
        <link rel="stylesheet" type="text/css" href="{ametys:skinURL('zones/index-survey/scss/main.css')}"/>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty"> 
        <div class="ametys-cms-service {$common-service-css-class-name} wrapper">
        	<div class="card rounded mb-4">
            	<xsl:call-template name="common-service-body-nonempty-content-title"/>
            	<div class="card-body pt-0 pb-0 px-0">
            		<xsl:call-template name="common-service-body-nonempty-content-content"/>
            		
            		<xsl:call-template name="input-radio-script"/>
            	</div>
            </div>
        </div>
    </xsl:template>
    
    <xsl:template name="common-service-body-nonempty-content-title-rendering">
        <xsl:param name="title"/>
        
        <header class="card-header justify-content-between pb-0 align-items-center">
        	<h1 class="card-title">
        		<xsl:call-template name="card-header-icon"/>
        		<xsl:copy-of select="$title"/>
        	</h1>
        </header>
   </xsl:template>
   
   <xsl:template name="card-header-icon">
       <span class="card-header__icon icofont-papers"></span>
   </xsl:template>
   
   <xsl:template name="input-radio-script">
		<script>
            $j(document).ready(function () {
              $j('.mini-survey input[type="radio"]').change(
                function () {
                  $j(".mini-survey .field-radio .label").removeClass("active");
                  $j(this)
                    .closest(".field-radio")
                    .find(".label")
                    .addClass("active");
                }
              );

              $j(".mini-survey__votes").each(function () {
                $j(this).insertBefore(
                  $j(this)
                    .closest(".mini-survey")
                    .find(".buttons")
                );
              });

            
            });
          </script>
    </xsl:template>
    
    <!-- Legend configuration -->
    <xsl:template name="chart-legend-color">#151515</xsl:template>
    <xsl:template name="chart-legend-font-family">'DINProMedium500',sans-serif</xsl:template>
    <xsl:template name="chart-legend-font-size">14</xsl:template>
    <xsl:template name="chart-legend-box-width">30</xsl:template>
    
</xsl:stylesheet>
