<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:math="java.lang.Math"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                exclude-result-prefixes="ametys">
                
    <xsl:import href="plugin:web://pages/services/search/search-default/results/facets.xsl"/>

    <!-- +
         | Template for filter by facets
         + -->
    <xsl:template name="facet-filter">
        <xsl:if test="/search/form/facets/facet[@total > 0]">
	        <xsl:variable name="unique" select="concat('search-facet-', substring-after(math:random(), '.'))"/>
	        <div id="{$unique}" class="ametys-filter">
		        <xsl:for-each select="/search/form/facets/facet[@total > 0]">
	                <xsl:call-template name="facet-filter-name"/>
		            <div class="ametys-search__customselect ametys-filter__customselect" data-ametys-search-role="facet-filter" data-ametys-search-facet-name="{current()/@name}">
		                <xsl:call-template name="facet-filter-list"/>
		            </div>
		        </xsl:for-each>
	        </div>
	    </xsl:if>
    </xsl:template>
    
    <!-- +
         | Template for facet name
         + -->
    <xsl:template name="facet-filter-name"/>
    
    <!-- +
         | Template for facet list to filter
         + -->
    <xsl:template name="facet-filter-list">
    	<button class="ametys-search__customselect_btn" type="button">
    		<input placeholder="{label}" disabled="disabled" />
    	</button>
    	 <ul class="ametys-search__customselect_list">
        		<xsl:call-template name="facet-filter-elements"/>
        </ul>
        
    </xsl:template>
    
    <!-- +
         | Template for an element of the facet list
         + -->
    <xsl:template name="facet-filter-element">
    	<xsl:variable name="id" select="concat(@name, '-', substring-after(math:random(), '.'))"/>
        
        <xsl:call-template name="facet-filter-element-checkbox">
            <xsl:with-param name="selected" select="@selected"/>
            <xsl:with-param name="id" select="$id"/>
        </xsl:call-template>
    </xsl:template>

    <xsl:template name="facet-filter-element-checkbox">
        <xsl:param name="selected" select="@selected"/>
        <xsl:param name="id" select="@name"/>
    
    		<xsl:variable name="onclick">
	         	<xsl:call-template name="search-js-facet">
	        		<xsl:with-param name="callback-function">filtersFunction</xsl:with-param>
	        	</xsl:call-template>
	         </xsl:variable>
         
	        <li>
	        	<input type="checkbox" name="{../@name}" id="lb-{generate-id()}" onclick="{$onclick}"  value="{@value}">
	            <xsl:choose>
		            <xsl:when test="string($selected) = 'true'">
		                <xsl:attribute name="data-ametys-search-role">facet-selected</xsl:attribute>
		                <xsl:attribute name="selected">selected</xsl:attribute>
		            </xsl:when>
		            <xsl:otherwise>
	                    <xsl:attribute name="data-ametys-search-role">facet-unselected</xsl:attribute>
		            </xsl:otherwise>
	            </xsl:choose>
	            </input>
	            
	            <label for="lb-{generate-id()}">
	            	<xsl:choose>
	            		<xsl:when test="text() != ''">
	            			<xsl:value-of select="text()"/>
	            		</xsl:when>
	            		<xsl:otherwise>
                            <!-- CMS-10799 Tag facets has no label (for version 4.6.0 or lower)-->
            				<xsl:variable name="tagLabel" select="ametys:tagLabel(ametys:site(), @value, $lang)"/>
	            			<xsl:value-of select="$tagLabel"/>
	            		</xsl:otherwise>
	            	</xsl:choose>
                    <span class="facet-count"> (<xsl:value-of select="@count"/>)</span>
	            </label>
	        </li>
    </xsl:template>
    
</xsl:stylesheet>
