<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xalan="http://xml.apache.org/xalan"
                xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper">

    <xsl:import href="plugin:web://pages/services/search/search-default/results/pagination.xsl"/>
    
    <!-- +
         | Template for page navigation
         + -->
    <xsl:template name="pagination">
    	<xsl:if test="/search/pagination/@total > 1">
        <form id="reload">
            <div class="pagination">
                <nav aria-label="plugin.web:FRONT_MODULE_SEARCH_NAV_PAGES" i18n:attr="aria-label">
                	<ul class="ametys-pagination list-inline">
	                    <xsl:apply-templates select="ametys:pagination(/search/pagination/@total + 0, /search/pagination/@current + 0, 0, 5, 0)" mode="search-pagination">
	                        <xsl:with-param name="original-context-node" select="/"/>
	                    </xsl:apply-templates>
	                </ul>
                </nav>
            </div>
        </form>
	    </xsl:if>
    </xsl:template>
    
    <xsl:template match="gotofirstpage" mode="search-pagination">
        <xsl:param name="original-context-node"/>
        
        <xsl:if test="@enabled!='false'">
        <li>
        	<xsl:attribute name="class">
           		<xsl:text>ametys-pagination__item ametys-pagination__item_first</xsl:text>
           	</xsl:attribute>
            <xsl:call-template name="common-utils-input-submit">
            	<xsl:with-param name="class-name" select="'ametys-pagination__link first'"/>
                <xsl:with-param name="i18nkey" select="'plugin.web:FRONT_MODULE_SEARCH_NAV_FIRST'" />
                <xsl:with-param name="i18ntitle" select="'plugin.web:FRONT_MODULE_SEARCH_NAV_FIRST_TITLE'" />
                <xsl:with-param name="onclick">
                    <xsl:call-template name="search-js-page">
                        <xsl:with-param name="original-context-node" select="$original-context-node"/>
                        <xsl:with-param name="callback-function">filtersFunction</xsl:with-param>
                  <xsl:with-param name="page" select="."/>
              </xsl:call-template>
                </xsl:with-param>
            </xsl:call-template>                        
        </li>
	    </xsl:if>
    </xsl:template>
    <xsl:template match="gotopreviouspage" mode="search-pagination">
        <xsl:param name="original-context-node"/>
        
        <xsl:if test="@enabled!='false'">
        <li>
        	<xsl:attribute name="class">
        		<xsl:text>ametys-pagination__item  ametys-pagination__item_prev</xsl:text>
        	</xsl:attribute>
            <xsl:call-template name="common-utils-input-submit">
            	<xsl:with-param name="class-name" select="'ametys-pagination__link prev'"/>
                <xsl:with-param name="i18nkey" select="'plugin.web:FRONT_MODULE_SEARCH_NAV_PRECEDE'" />        
                <xsl:with-param name="i18ntitle" select="'plugin.web:FRONT_MODULE_SEARCH_NAV_PRECEDE_TITLE'" />                        
                <xsl:with-param name="onclick">
                <xsl:call-template name="search-js-page">
                    <xsl:with-param name="original-context-node" select="$original-context-node"/>
                    <xsl:with-param name="callback-function">filtersFunction</xsl:with-param>
                    <xsl:with-param name="page" select="."/>
                </xsl:call-template>
            </xsl:with-param>
            </xsl:call-template>                        
        </li>
	    </xsl:if>
    </xsl:template>
    <xsl:template match="space" mode="search-pagination"/>
    <xsl:template match="separator" mode="search-pagination">
    	<li class="ametys-pagination__item">
			<span class="ametys-pagination__dots">...</span>
		</li>
    </xsl:template>
    <xsl:template match="page" mode="search-pagination">
        <xsl:param name="original-context-node"/>
        
        <li>
            <xsl:attribute name="class">
                <xsl:text>ametys-pagination__item</xsl:text>
                <xsl:if test=". = ../gotofirstpage"><xsl:text> ametys-pagination__item_first</xsl:text></xsl:if>
                <xsl:if test=". = ../gotolastpage"><xsl:text> ametys-pagination__item_last</xsl:text></xsl:if>
            </xsl:attribute>
            
            <xsl:call-template name="common-utils-input-submit">
            	<xsl:with-param name="class-name" select="'ametys-pagination__link'"/>
                <xsl:with-param name="text"><xsl:value-of select="."/></xsl:with-param>
                <xsl:with-param name="onclick">
                    <xsl:call-template name="search-js-page">
                        <xsl:with-param name="original-context-node" select="$original-context-node"/>
                        <xsl:with-param name="callback-function">filtersFunction</xsl:with-param>
		                <xsl:with-param name="page" select="."/>
		            </xsl:call-template>
                </xsl:with-param>
            </xsl:call-template>                            
        </li>
    </xsl:template>
    <xsl:template match="current" mode="search-pagination">
        <li class="ametys-pagination__item"><span class="ametys-pagination__link ametys-pagination__link_active"><xsl:value-of select="."/></span></li>
    </xsl:template>
    <xsl:template match="gotonextpage" mode="search-pagination">
        <xsl:param name="original-context-node"/>
        
        <xsl:if test="@enabled!='false'">
        <li>
        	<xsl:attribute name="class">
        		<xsl:text>ametys-pagination__item  ametys-pagination__item_next</xsl:text>
        	</xsl:attribute>
            <xsl:call-template name="common-utils-input-submit">
            	<xsl:with-param name="class-name" select="'ametys-pagination__link next'"/>
                <xsl:with-param name="i18nkey" select="'plugin.web:FRONT_MODULE_SEARCH_NAV_NEXT'" />
                <xsl:with-param name="i18ntitle" select="'plugin.web:FRONT_MODULE_SEARCH_NAV_NEXT_TITLE'" />
                <xsl:with-param name="onclick">
                 <xsl:call-template name="search-js-page">
                     <xsl:with-param name="original-context-node" select="$original-context-node"/>
                     <xsl:with-param name="callback-function">filtersFunction</xsl:with-param>
                     <xsl:with-param name="page" select="."/>
                 </xsl:call-template>
             </xsl:with-param>
            </xsl:call-template>                                            
        </li>
	    </xsl:if>
    </xsl:template>
    <xsl:template match="gotolastpage" mode="search-pagination">
        <xsl:param name="original-context-node"/>
        
        <xsl:if test="@enabled!='false'">
        <li>
        	<xsl:attribute name="class">
        		<xsl:text>ametys-pagination__item  ametys-pagination__item_last</xsl:text>
        	</xsl:attribute>
            <xsl:call-template name="common-utils-input-submit">
            	<xsl:with-param name="class-name" select="'ametys-pagination__link last'"/>
                <xsl:with-param name="i18nkey" select="'plugin.web:FRONT_MODULE_SEARCH_NAV_LAST'" />
                <xsl:with-param name="i18ntitle" select="'plugin.web:FRONT_MODULE_SEARCH_NAV_LAST_TITLE'" />
                <xsl:with-param name="onclick">
                 <xsl:call-template name="search-js-page">
                     <xsl:with-param name="original-context-node" select="$original-context-node"/>
                     <xsl:with-param name="callback-function">filtersFunction</xsl:with-param>
                     <xsl:with-param name="page" select="."/>
                 </xsl:call-template>
             </xsl:with-param>
            </xsl:call-template>
        </li>
	    </xsl:if>
    </xsl:template>
    
</xsl:stylesheet>
