<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                              xmlns:docbook="http://docbook.org/ns/docbook" 
                              xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
                              xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                              xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
                              exclude-result-prefixes="ametys docbook resolver">

	<xsl:import href="plugin:classified-ads://stylesheets/content/ads/ads-main.xsl"/>	
	
	<xsl:template name="custom-content-css">
        <!-- Used for home search only -->
		 <link rel="stylesheet" type="text/css" href="{ametys:skinURL('zones/index-advertisement/scss/main.css')}" media="screen, print, handheld"/>
		 <link rel="stylesheet" type="text/css" href="{ametys:skinURL('zones/index-advertisement/scss/print.css')}" media="print"/>
		 <link rel="stylesheet" media="screen" href="{ametys:skinURL('templates/common/plugins/simple-lightbox/css/simple-lightbox.min.css')}" type="text/css" />
	</xsl:template>	
	
	<xsl:template name="common-content-head-js">
        <script type="text/javascript" src="{ametys:skinURL('templates/common/plugins/simple-lightbox/js/simple-lightbox.jquery.min.js')}"/>
        <script type="text/javascript">
            $j(document).ready(function () {
                $j('.photo-gallery a').simpleLightbox();
            });
        </script>
    </xsl:template>
    
        
    <xsl:template name="common-content-body-content">
        <br style="clear: both;" />

        <div class="row">
            <div class="col-lg-5">
                <span class="ametys-advertisement__cat">
                    <xsl:value-of select="metadata/category/@title" />
                </span>
        
                <xsl:call-template name="ads-infos"/>
                <xsl:call-template name="common-content-body-content-rich" />
            </div>
            
            <xsl:call-template name="ads-photos"/>
        </div>
    </xsl:template> 
    
    <xsl:template name="ads-infos">
        <ul class="list-unstyled">
            <xsl:call-template name="ads-price"/>
            <xsl:call-template name="ads-location"/>
            <xsl:call-template name="ads-author"/>
            <xsl:call-template name="ads-author-mail"/>
            <xsl:call-template name="ads-phone"/>
        </ul>
    </xsl:template>
    
    <xsl:template name="infos-item">
        <xsl:param name="value"/>
        <xsl:param name="iconCls"/>
        
        <xsl:if test="$value">
            <li class="dropdown-item">
                <span class="ads-user">
                    <i class="{$iconCls}"></i>
                    <xsl:text> </xsl:text>
                </span>
                <xsl:value-of select="$value" />
            </li>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="infos-item-price">
        <xsl:param name="value"/>
        <xsl:param name="iconCls"/>
        
        <xsl:if test="$value">
            <li class="dropdown-item">
                <span class="ads-user">
                    <i class="{$iconCls}"></i>
                    <xsl:text> </xsl:text>
                </span>
                <xsl:choose>
	                <xsl:when test="contains($value, '.0')"><xsl:value-of select="substring-before($value, '.0')"/></xsl:when>
	                <xsl:otherwise><xsl:value-of select="translate($value, '.', ',')"/></xsl:otherwise>
                </xsl:choose>
            </li>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="ads-price">
        <xsl:call-template name="infos-item-price">
            <xsl:with-param name="value" select="metadata/price"/>
            <xsl:with-param name="iconCls">fas fa-euro-sign</xsl:with-param>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="ads-location">
        <xsl:call-template name="infos-item">
            <xsl:with-param name="value" select="metadata/location"/>
            <xsl:with-param name="iconCls">fas fa-map-marker-alt</xsl:with-param>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="ads-author">
        <xsl:call-template name="infos-item">
            <xsl:with-param name="value" select="metadata/ugc-contact/name"/>
            <xsl:with-param name="iconCls">fas fa-user</xsl:with-param>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="ads-author-mail">
        <xsl:call-template name="infos-item">
            <xsl:with-param name="value" select="metadata/ugc-contact/mail"/>
            <xsl:with-param name="iconCls">fas fa-envelope</xsl:with-param>
        </xsl:call-template>
    </xsl:template>
    
    <xsl:template name="ads-phone">
        <xsl:call-template name="infos-item">
            <xsl:with-param name="value" select="metadata/phone"/>
            <xsl:with-param name="iconCls">fas fa-mobile-alt</xsl:with-param>
        </xsl:call-template>
    </xsl:template>

    <xsl:template name="ads-photos">
        <xsl:if test="metadata/illustrations/*">
            <div class="col-lg-7 photo-gallery">
                <xsl:for-each select="metadata/illustrations/*">
                    <xsl:call-template name="photo">
                        <xsl:with-param name="image" select="."/>
                    </xsl:call-template>
                </xsl:for-each>
            </div>
        </xsl:if>
    </xsl:template>
    
    <xsl:template name="photo">
        <xsl:param name="image" />
        <xsl:param name="maxWidth">300</xsl:param>
        <xsl:param name="maxHeight">200</xsl:param>
        <xsl:param name="class">figure floatleft g-mr-20</xsl:param>
        
        <figure class="{$class}" style="text-align: center;">
            <a href="{resolver:resolve($image/@type, $image/@path)}" title="{$image/@filename}">
                <xsl:attribute name="rel">
                    <xsl:choose>
                        <xsl:when test="count(../entry[image]) &gt; 1"><xsl:text>gallery</xsl:text></xsl:when>
                        <xsl:otherwise><xsl:text>single</xsl:text></xsl:otherwise>
                    </xsl:choose>
                </xsl:attribute>
                <xsl:attribute name="class">
                    <xsl:text>pirobox</xsl:text>
                    <xsl:if test="count(../entry[image]) &gt; 1"><xsl:text>_gall_</xsl:text><xsl:value-of select="$uniqueId"/></xsl:if>
                </xsl:attribute>
                 <xsl:if test="$rendering-context = 'back'">
                    <xsl:attribute name="internal">internal</xsl:attribute>
                </xsl:if>
            
                <img alt="{$image/@filename}" src="{resolver:resolveBoundedImage($image/@type, $image/@path, $maxHeight, $maxWidth)}"/>
            </a>
        </figure>
    </xsl:template>
    
</xsl:stylesheet>
