<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							xmlns:i18n="http://apache.org/cocoon/i18n/2.1" 
                            xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
                            xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
							exclude-result-prefixes="ametys"
							extension-element-prefixes="resolver">

	<xsl:import href="plugin:multimedia://stylesheets/content/photosGallery/photosGallery-main.xsl"/>	
	<xsl:import href="photosGallery.xsl"/>	
	
	<xsl:template name="common-content-body-content">
        <!-- Rich content -->
        <xsl:call-template name="common-content-body-content-rich"/>
        
        <!-- Photos -->            
        <xsl:call-template name="photos"/>
        
        <!-- Comments -->
        <xsl:call-template name="common-content-body-comments"/>        
    </xsl:template>	
    
    <xsl:template name="photos">
        <xsl:if test="metadata/photos/entry/image">
            <div class="row">
                <xsl:for-each select="metadata/photos/entry[image]">
                    <xsl:call-template name="photo"/>
                </xsl:for-each>
            </div>
        </xsl:if>
    </xsl:template>
	
    <xsl:template name="photo">
		<div class="col-md-3 g-mb-30">
			<a class="js-fancybox d-block u-block-hover u-bg-overlay g-bg-black-opacity-0_3--after g-bg-primary-opacity-0_8--hover--after g-transition-0_3" href="javascript:;" data-fancybox="lightbox-gallery--03" data-src="{resolver:resolve(image/@type, image/@path)}"  data-speed="350" data-caption="{alt-text}">
				<img class="img-fluid" src="{resolver:resolveCroppedImage(image/@type, image/@path, 275, 400)}" alt=""/>
			
				<span class="u-block-hover__additional--fade g-color-white g-z-index-2">
			       <i class="hs-icon hs-icon-magnifier g-absolute-centered g-font-size-25"></i>
			    </span>
			</a>
		</div>
    </xsl:template>
	
</xsl:stylesheet>
