<?xml version="1.0" encoding="UTF-8"?>
<!--
   Copyright 2022 Anyware Services

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
   -->
<xsl:stylesheet version="1.0"
    xmlns:xalan="http://xml.apache.org/xalan"
    xmlns:math="java.lang.Math" 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns:i18n="http://apache.org/cocoon/i18n/2.1"
    xmlns:str="http://exslt.org/strings"
    xmlns:exslt="http://exslt.org/common"
    xmlns:ametys="org.ametys.web.transformation.xslt.AmetysXSLTHelper"
    xmlns:user="org.ametys.plugins.userdirectory.transformation.xslt.UserXSLTHelper"
    xmlns:resolver="org.ametys.cms.transformation.xslt.ResolveURIComponent"
    exclude-result-prefixes="xalan math str ametys resolver user exslt">  
    
    <xsl:import href="plugin:web://stylesheets/utils.xsl"/>
    <xsl:import href="workspace:web://stylesheets/variables.xsl"/>
    <xsl:import href="skin://stylesheets/variables.xsl"/>
    
    <xsl:variable name="openNewWindowSuffix" select="ametys:translate(concat('skin.', $skin, ':SKIN_LINK_OPEN_NEW_WINDOW_SUFFIX'), $lang)"></xsl:variable>
    
	<!-- +
		 | HEADERS
		 + -->
	<xsl:template name="zone-header">
		<xsl:param name="content"/>
		
		<h1 class="ametys-content-title"><xsl:copy-of select="$content"/></h1>
	</xsl:template>
    
    
   <!-- Template used by submit button -->
    <xsl:template name="common-utils-input-submit">
        <xsl:param name="class"/>
    	<xsl:param name="class-name" select="$class"/><!-- to avoid migration -->
        <xsl:param name="text"/>
        <xsl:param name="i18nkey"/>
        <xsl:param name="name"/>   
        <xsl:param name="i18ntitle"/>  
        <xsl:param name="title"/>      
        <xsl:param name="id"/>        
        <xsl:param name="onclick"/>        
        <xsl:param name="width"/>        
        <xsl:param name="type">submit</xsl:param>        
        <xsl:param name="disabled" select="false()"/> 
        
        <div class="button">
            <button type="{$type}">
                <xsl:attribute name="class">
	            	<xsl:choose>
	            		<xsl:when test="$class-name != ''">
	            			<xsl:value-of select="$class-name"/>
	            		</xsl:when>
	            		<xsl:otherwise>
	            			<xsl:text>btn btn-info</xsl:text>
	            		</xsl:otherwise>
	            	</xsl:choose>
	            </xsl:attribute>
                <xsl:if test="$name != ''">
                    <xsl:attribute name="name"><xsl:value-of select="$name"/></xsl:attribute>
                </xsl:if>
                <xsl:if test="$id != ''">
                    <xsl:attribute name="id"><xsl:value-of select="$id"/></xsl:attribute>
                </xsl:if>
                <xsl:if test="$onclick != ''">
                    <xsl:attribute name="onclick"><xsl:value-of select="$onclick"/></xsl:attribute>
                </xsl:if>
       	        <xsl:if test="$disabled">
   	                <xsl:attribute name="disabled">disabled</xsl:attribute>
                </xsl:if>
                <xsl:if test="$width != ''">
                    <xsl:attribute name="style">width: <xsl:value-of select="$width"/>px;</xsl:attribute>
                </xsl:if>
                <xsl:choose>
                    <xsl:when test="$i18ntitle != ''">
                        <xsl:attribute name="title"><xsl:value-of select="$i18ntitle"/></xsl:attribute>
                        <xsl:attribute name="i18n:attr">title<xsl:if test="$i18nkey != ''"> value</xsl:if></xsl:attribute>
                    </xsl:when>
                    <xsl:otherwise><xsl:attribute name="title"><xsl:value-of select="$title"/></xsl:attribute></xsl:otherwise>                
                </xsl:choose>
                <xsl:choose>
                	<xsl:when test="contains($class-name, 'first') or contains($class-name, 'prev') or contains($class-name, 'last') or contains($class-name, 'next')">
                		<span class="ametys-pagination__icon" aria-hidden="true">
                			<xsl:choose>
                				<xsl:when test="contains($class-name, 'first')">
                					<span class="fas fa-angle-double-left"></span>
                				</xsl:when>
                				<xsl:when test="contains($class-name, 'prev')">
                					<span class="fas fa-angle-left"></span>
                				</xsl:when>
                				<xsl:when test="contains($class-name, 'last')">
                					<span class="fas fa-angle-double-right"></span>
                				</xsl:when>
                				<xsl:when test="contains($class-name, 'next')">
                					<span class="fas fa-angle-right"></span>
                				</xsl:when>
                			</xsl:choose>
		                  
		                </span>
                	</xsl:when>
                	<xsl:otherwise></xsl:otherwise>
                </xsl:choose>
                
                <xsl:choose>
                    <!-- i18n key -->
                    <xsl:when test="$i18nkey != ''">
                    	<xsl:choose>
                    		<xsl:when test="contains($class-name, 'first') or contains($class-name, 'prev') or contains($class-name, 'last') or contains($class-name, 'next')">
                    			<span class="sr-only">
                                    <xsl:choose>
                                        <xsl:when test="contains($i18nkey,':')">
                                            <i18n:text i18n:catalogue="{substring-before($i18nkey,':')}" i18n:key="{substring-after($i18nkey,':')}"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <i18n:text i18n:key="{$i18nkey}"/>
                                        </xsl:otherwise>
                                    </xsl:choose>
                                </span>
                    		</xsl:when>
                    		<xsl:otherwise>
                    			<xsl:choose>
                                    <xsl:when test="contains($i18nkey,':')">
                                        <i18n:text i18n:catalogue="{substring-before($i18nkey,':')}" i18n:key="{substring-after($i18nkey,':')}"/>
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <i18n:text i18n:key="{$i18nkey}"/>
                                    </xsl:otherwise>
                                </xsl:choose>
                    		</xsl:otherwise>
                    	</xsl:choose>
                    </xsl:when>
                    <!-- text value -->
                    <xsl:otherwise><xsl:value-of select="$text"/></xsl:otherwise>                
                </xsl:choose>
            </button>
        </div>
    </xsl:template>                     
 
    <xsl:template name="user-info">
        <xsl:param name="login" select="ametys:user()/user/@login"/>
        <xsl:param name="population" select="ametys:user()/user/@population"/>
        <xsl:param name="userIdentity"/>
        <xsl:param name="imgWidth">40</xsl:param>
        
        <xsl:variable name="fUserIdentity">
        	<xsl:choose>
        		<xsl:when test="$userIdentity != ''"><xsl:text/><xsl:value-of select="$userIdentity"/></xsl:when>
        		<xsl:otherwise><xsl:text/><xsl:value-of select="concat($login, '#', $population)"/></xsl:otherwise>
        	</xsl:choose>
        </xsl:variable>

        <xsl:variable name="userContentId" select="user:getUserContent($lang, $fUserIdentity)"/>
        <xsl:variable name="userPageId" select="user:getUserPage($userContentId, ametys:config('workspaces.member.userdirectory.site.name'))"/>
        <xsl:variable name="ametysUser" select="ametys:user($fUserIdentity)"/>
         
        <user> 
            <login><xsl:value-of select="$ametysUser/user/@login"/></login>
            <population><xsl:value-of select="$ametysUser/user/@population"/></population>
            <xsl:choose>
                <xsl:when test="$userContentId != ''">
                   <xsl:variable name="imgPath" select="concat('illustration/image?contentId=', $userContentId)" />
                   <xsl:variable name="imgUrl" select="resolver:resolveCroppedImage('attribute', $imgPath, $imgWidth, $imgWidth)"/>
                   
                   <xsl:choose>
                        <xsl:when test="$imgUrl != ''">
                            <imgUrl><xsl:value-of select="$imgUrl"/></imgUrl>
                        </xsl:when>
                        <xsl:otherwise></xsl:otherwise>
                   </xsl:choose>
                   <xsl:variable name="firstname" select="ametys:contentAttribute($userContentId, 'firstname')"/>
                   <xsl:variable name="lastname" select="ametys:contentAttribute($userContentId, 'lastname')"/>
                   <firstname><xsl:value-of select="$firstname"/></firstname>
                   <lastname><xsl:value-of select="$lastname"/></lastname>
                   <fullname><xsl:value-of select="$firstname"/><xsl:if test="$firstname != ''"><xsl:text> </xsl:text></xsl:if><xsl:value-of select="$lastname"/></fullname>
                   <email><xsl:value-of select="ametys:contentAttribute($userContentId, 'email')"/></email>
                   <role><xsl:value-of select="ametys:contentAttribute($userContentId, 'function')"/></role>
                   <organisation><xsl:value-of select="ametys:contentAttribute($userContentId, 'organisation')"/></organisation>
                   <organisationAccronym><xsl:value-of select="ametys:contentAttribute($userContentId, 'organisation-accronym')"/></organisationAccronym>
                   <contentId><xsl:value-of select="$userContentId"/></contentId>
                </xsl:when>
                <xsl:when test="$ametysUser/user/fullname !=''">
                    <firstname><xsl:value-of select="$ametysUser/user/firstname"/></firstname>
                    <lastname><xsl:value-of select="$ametysUser/user/lastname"/></lastname>
                    <fullname><xsl:value-of select="$ametysUser/user/fullname"/></fullname>
                    <email><xsl:value-of select="$ametysUser/user/email"/></email>
                    <imgUrl><xsl:value-of select="concat($site-uri-prefix, '/_plugins/core-ui/user/', substring-after($fUserIdentity, '#'), '/', substring-before($fUserIdentity, '#'), '/image_', $imgWidth)"/></imgUrl>
                </xsl:when>
                <xsl:otherwise>
                    <fullname><xsl:value-of select="ametys:translate(concat('skin.', $skin, ':UNKNOWN_USER'))"/></fullname>
                     <imgUrl><xsl:value-of select="ametys:skinURL('templates/common/img/avatar.png')"/></imgUrl>
                </xsl:otherwise>
            </xsl:choose>
            <pageId><xsl:value-of select="$userPageId"/></pageId>
        </user>
    </xsl:template>
    
    <!-- Template used for pagination -->
    <xsl:template name="common-utils-pagination">
        <xsl:param name="nbPages"/>
        <xsl:param name="current-page"/>
        <xsl:param name="hasNbPages" select="true()" />
        <xsl:param name="onclick"/>
        
        <nav aria-label="plugin.web:FRONT_MODULE_SEARCH_NAV_PAGES" i18n:attr="aria-label">
	        <ul class="ametys-pagination list-inline">
                <!-- First page -->
                <li>
                	<xsl:attribute name="class">
                		<xsl:text>ametys-pagination__item ametys-pagination__item_first</xsl:text>
                		<xsl:if test="$current-page/@index = 1"> ametys-pagination__item_disabled</xsl:if>
                	</xsl:attribute>
                    <xsl:call-template name="common-utils-input-submit">
                    	<xsl:with-param name="class-name" select="'ametys-pagination__link first'"/>
                        <xsl:with-param name="i18nkey" select="'plugin.web:FRONT_MODULE_SEARCH_NAV_FIRST'" />
                        <xsl:with-param name="i18ntitle" select="'plugin.web:FRONT_MODULE_SEARCH_NAV_FIRST_TITLE'" />
                        <xsl:with-param name="name">page-<xsl:value-of select="$current-page/../page[position() = 1]/@index"/></xsl:with-param>
                        <xsl:with-param name="onclick" select="$onclick" />
                    </xsl:call-template>                        
                </li>
	            
                <!-- Precede page -->
                <li>
                	<xsl:attribute name="class">
                		<xsl:text>ametys-pagination__item  ametys-pagination__item_prev</xsl:text>
                		<xsl:if test="$current-page/@index = 1"> ametys-pagination__item_disabled</xsl:if>
                	</xsl:attribute>
                    <xsl:call-template name="common-utils-input-submit">
                    	<xsl:with-param name="class-name" select="'ametys-pagination__link prev'"/>
                        <xsl:with-param name="i18nkey" select="'plugin.web:FRONT_MODULE_SEARCH_NAV_PRECEDE'" />        
                        <xsl:with-param name="i18ntitle" select="'plugin.web:FRONT_MODULE_SEARCH_NAV_PRECEDE_TITLE'" />                        
                        <xsl:with-param name="name">page-<xsl:value-of select="$current-page/preceding-sibling::page[1]/@index"/></xsl:with-param>
                        <xsl:with-param name="onclick" select="$onclick" />
                    </xsl:call-template>                        
                </li>
                <xsl:if test="$current-page/preceding-sibling::page[position() &gt;= 5]">
	                <li class="ametys-pagination__item">
						<span class="ametys-pagination__dots">...</span>
					</li>
				</xsl:if>
	            
	            <xsl:if test="$hasNbPages">
		            <xsl:for-each select="$current-page/preceding-sibling::page[position() &lt; 5]">
		                 <li class="ametys-pagination__item">
		                    <xsl:call-template name="common-utils-input-submit">
		                    	<xsl:with-param name="class-name" select="'ametys-pagination__link'"/>
		                        <xsl:with-param name="text"><xsl:value-of select="@index"/></xsl:with-param>
		                        <xsl:with-param name="name">page-<xsl:value-of select="@index"/></xsl:with-param>                                
		                        <xsl:with-param name="onclick" select="$onclick" />
		                    </xsl:call-template>                            
		                 </li>
		            </xsl:for-each>
	            </xsl:if>
	            
	            <li class="ametys-pagination__item"><span class="ametys-pagination__link ametys-pagination__link_active"><xsl:value-of select="$current-page/@index"/></span></li>
	            
	            <xsl:if test="$hasNbPages">
	                <xsl:for-each select="$current-page/following-sibling::page[position() &lt; 5]">
	                     <li class="ametys-pagination__item">
	                        <xsl:call-template name="common-utils-input-submit">
	                        	<xsl:with-param name="class-name" select="'ametys-pagination__link'"/>
	                            <xsl:with-param name="text"><xsl:value-of select="@index"/></xsl:with-param>
	                            <xsl:with-param name="name">page-<xsl:value-of select="@index"/></xsl:with-param>                                
	                            <xsl:with-param name="onclick" select="$onclick" />
	                        </xsl:call-template>                            
	                     </li>
	                </xsl:for-each>
	            </xsl:if>           
	            <xsl:if test="$current-page/following-sibling::page[position() &gt;= 5]">
	                <li class="ametys-pagination__item">
						<span class="ametys-pagination__dots">...</span>
					</li>
				</xsl:if>
	            <xsl:choose>
	                <xsl:when test="$hasNbPages">
                        <!--  Next page -->
                        <li>
                        	<xsl:attribute name="class">
		                		<xsl:text>ametys-pagination__item ametys-pagination__item_next</xsl:text>
		                		<xsl:if test="$current-page/@index = $nbPages"> ametys-pagination__item_disabled</xsl:if>
		                	</xsl:attribute>
                            <xsl:call-template name="common-utils-input-submit">
                            	<xsl:with-param name="class" select="'ametys-pagination__link next'"/>
                                <xsl:with-param name="i18nkey" select="'plugin.web:FRONT_MODULE_SEARCH_NAV_NEXT'" />
                                <xsl:with-param name="i18ntitle" select="'plugin.web:FRONT_MODULE_SEARCH_NAV_NEXT_TITLE'" />
                                <xsl:with-param name="name">page-<xsl:value-of select="$current-page/following-sibling::page[1]/@index"/></xsl:with-param>                                
                                <xsl:with-param name="onclick" select="$onclick" />
                            </xsl:call-template>                                            
                        </li>
	                    
	                    <!-- Last page -->
                        <li>  
                        	<xsl:attribute name="class">
		                		<xsl:text>ametys-pagination__item ametys-pagination__item_last</xsl:text>
                        		<xsl:if test="$current-page/@index = $nbPages"> ametys-pagination__item_disabled</xsl:if>
                        	</xsl:attribute>
                            <xsl:call-template name="common-utils-input-submit">
                            	<xsl:with-param name="class-name" select="'ametys-pagination__link last'"/>
                                <xsl:with-param name="i18nkey" select="'plugin.web:FRONT_MODULE_SEARCH_NAV_LAST'" />
                                <xsl:with-param name="i18ntitle" select="'plugin.web:FRONT_MODULE_SEARCH_NAV_LAST_TITLE'" />
                                <xsl:with-param name="name">page-<xsl:value-of select="$current-page/../page[position() = last()]/@index"/></xsl:with-param>                                
                                <xsl:with-param name="onclick" select="$onclick" />
                            </xsl:call-template>
                        </li>
	                </xsl:when>
	                <xsl:otherwise>
                        <!--  Next page -->
                        <li>
                        	<xsl:attribute name="class">
		                		<xsl:text>ametys-pagination__item ametys-pagination__item_next</xsl:text>
                        		<xsl:if test="$current-page/@index = $nbPages"> ametys-pagination__item_disabled</xsl:if>
                        	</xsl:attribute>
                            <xsl:call-template name="common-utils-input-submit">
                            	<xsl:with-param name="class-name" select="'ametys-pagination__link next'"/>
                                <xsl:with-param name="i18nkey" select="'plugin.web:FRONT_MODULE_SEARCH_NAV_NEXT'" />
                                <xsl:with-param name="i18ntitle" select="'plugin.web:FRONT_MODULE_SEARCH_NAV_NEXT_TITLE'" />
                                <xsl:with-param name="name">page-<xsl:value-of select="$current-page/following-sibling::page[1]/@index"/></xsl:with-param>                                
		                        <xsl:with-param name="onclick" select="$onclick" />
                            </xsl:call-template>                                            
                        </li>
	                </xsl:otherwise>
	            </xsl:choose>
	        </ul>
	    </nav>
    </xsl:template>
    
    <!-- Template used for pagination results message -->
    <xsl:template name="common-utils-pagination-results"/>
    
    <xsl:template name="user-profile-image">
        <xsl:param name="size">45</xsl:param>
        <xsl:param name="login"/>
        <xsl:param name="population"/>
        <xsl:param name="lang" select="ametys:lang()"/>
        <xsl:param name="class"/>
        
        <xsl:variable name="url">
            <xsl:call-template name="user-profile-image-url">
                <xsl:with-param name="size" select="$size"/>
                <xsl:with-param name="login" select="$login"/>
                <xsl:with-param name="population" select="$population"/>
                <xsl:with-param name="lang" select="$lang"/>
            </xsl:call-template>
        </xsl:variable>
        <img src="{$url}">
            <xsl:if test="$class != ''">
                <xsl:attribute name="class"><xsl:value-of select="$class"/></xsl:attribute>
            </xsl:if>
        </img>
    </xsl:template>
    
    <xsl:template name="user-profile-image-url">
        <xsl:param name="size">45</xsl:param>
        <xsl:param name="login"/>
        <xsl:param name="population"/>
        <xsl:param name="lang" select="ametys:lang()"/>

        <xsl:value-of select="concat($site-uri-prefix, '/_plugins/user-directory/user/', $population, '/', $login, '/image_', $size, '?lang=', $lang)"/>        
    </xsl:template>
    
    <xsl:template name="get-content-tags">
        <xsl:param name="tags" select="tags/*"/>
        
        <xsl:for-each select="$tags">
            <xsl:variable name="tagId" select="local-name()"/>
            <xsl:variable name="tagPath" select="ametys:tagPath($site, $tagId)"/>
            <xsl:variable name="tagColor" select="ametys:tagColor($site, $tagId)"/>
            
            <xsl:if test="contains($tagPath, 'CONTENT_CATEGORIES')">
                <tag bgColor="{$tagColor/main}" textColor="{$tagColor/text}"><xsl:value-of select="." /></tag>
            </xsl:if>
        </xsl:for-each>
    </xsl:template>
    
    <!-- Templates for attributes to add on external links -->
    <xsl:template name="external-link-attributes">
        <xsl:param name="title"/>
        <xsl:param name="className">external</xsl:param>
        
        <xsl:attribute name="target">_blank</xsl:attribute>
        <xsl:attribute name="class"><xsl:value-of select="$className"/></xsl:attribute>
        <xsl:attribute name="title"><xsl:value-of select="concat($title, $openNewWindowSuffix)"/></xsl:attribute>
    </xsl:template>
        
</xsl:stylesheet>    